/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnAccountParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnGeneralParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.KmcCryptUtils;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnAccountVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnVmVo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper
public interface SdnConverter {
    @Mappings(value={@Mapping(target="sdnGeneralParam", expression="java(toSdnGeneralParam(sdnParamVo.getSdnGeneralVo()))"), @Mapping(target="sdnAccountParam", expression="java(toSdnAccountParam(sdnParamVo.getAccount()))"), @Mapping(target="sdnVmParams", expression="java(toSdnVmParams(sdnParamVo))"), @Mapping(target="fcLoginInfo", expression="java(sdnParamVo.getSdnGeneralVo().getFcLoginInfo())")})
    public SdnParam toSdnParam(SdnParamVo var1, String var2);

    @Mappings(value={@Mapping(target="templateCnaName", source="sdnGeneralVo.templateCna"), @Mapping(target="templateDataStoreName", source="sdnGeneralVo.templateDataStore")})
    public SdnGeneralParam toSdnGeneralParam(SdnGeneralVo var1);

    default public SdnAccountParam toSdnAccountParam(SdnAccountVo sdnAccountVo) {
        return SdnAccountParam.builder().sdnPwd(KmcCryptUtils.encrypt((String)sdnAccountVo.getSdnPwd())).sdnUser(sdnAccountVo.getSdnUser()).build();
    }

    default public List<SdnVmParam> toSdnVmParams(SdnParamVo sdnParamVo) {
        if (CollectionUtils.isEmpty(sdnParamVo.getSdnVmVos()) || Objects.isNull(sdnParamVo.getSdnPlanVo())) {
            return Collections.emptyList();
        }
        return sdnParamVo.getSdnVmVos().stream().map(sdnVmVo -> this.toSdnVm((SdnVmVo)sdnVmVo, sdnParamVo.getSdnPlanVo())).collect(Collectors.toList());
    }

    @Mappings(value={@Mapping(target="nicConfigs", expression="java(toNicConfigs(sdnVmVo, sdnPlanVo))"), @Mapping(target="diskCmds", expression="java(toDiskCmds(sdnVmVo))")})
    public SdnVmParam toSdnVm(SdnVmVo var1, SdnPlanVo var2);

    default public List<VmNicConfigCmd> toNicConfigs(SdnVmVo sdnVmVo, SdnPlanVo sdnPlanVo) {
        return Arrays.asList(VmNicConfigCmd.builder().ip(sdnVmVo.getOmIp()).portGroupName(sdnPlanVo.getManagePortGroup()).netmask(sdnPlanVo.getManageMask()).gateway(sdnPlanVo.getManageGateway()).build(), VmNicConfigCmd.builder().ip(sdnVmVo.getServiceIp()).portGroupName(sdnPlanVo.getServicePortGroup()).netmask(sdnPlanVo.getServiceMask()).build(), VmNicConfigCmd.builder().portGroupName(sdnPlanVo.getServicePortGroup()).build(), VmNicConfigCmd.builder().portGroupName(sdnPlanVo.getServicePortGroup()).build(), VmNicConfigCmd.builder().portGroupName(sdnPlanVo.getServicePortGroup()).build(), VmNicConfigCmd.builder().portGroupName(sdnPlanVo.getServicePortGroup()).build());
    }

    default public List<DiskCmd> toDiskCmds(SdnVmVo sdnVmVo) {
        return Arrays.asList(DiskCmd.builder().dateStoreName(sdnVmVo.getDataStoreName()).quantityGB(sdnVmVo.getSysDisk()).build(), DiskCmd.builder().dateStoreName(sdnVmVo.getDataStoreName()).quantityGB(sdnVmVo.getDataDisk()).build());
    }
}

