/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.BondPort;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.Cifs;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.CifsPermission;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DataProtocol;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.FileResource;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.FileSystem;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.IpConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.License;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.LogicPort;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.Nfs;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.NfsPermission;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.PortType;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.StoragePoolConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.UserInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.Vlan;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.StorageDeployError;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageLogicInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StorageConverter {
    private static final Logger log = LoggerFactory.getLogger(StorageConverter.class);

    public DeviceConfig toDeviceConfig(String softwarePath, StorageInfo storageInfo) {
        return DeviceConfig.builder().name(storageInfo.getName()).esn(storageInfo.getSn()).defaultIp(storageInfo.getCurrentManageIp()).userName(storageInfo.getUsername()).curPassword(storageInfo.getLoginPwd()).ipConfig(this.buildIpConfig(storageInfo)).license(License.builder().licensePath(FilePathValidatorUtils.joinChildPath((String[])new String[]{softwarePath, storageInfo.getLicenseName()})).build()).logicPort(this.buildLogicPort(storageInfo)).storagePoolConfig(this.buildStoragePool(storageInfo)).fileResources(this.buildFileResources(storageInfo)).interAccount(this.buildInterAccount(storageInfo)).build();
    }

    private UserInfo buildInterAccount(StorageInfo storageInfo) {
        return UserInfo.builder().userName(storageInfo.getInterconnectInfo().getAccount()).curPassword(storageInfo.getInterconnectInfo().getAccountPwd()).roleId("1").scope(0).build();
    }

    private LogicPort buildLogicPort(StorageInfo storageInfo) {
        List bandPorts = storageInfo.getLogicInfo().stream().filter(storageLogicInfo -> StringUtils.isNotEmpty((CharSequence)storageLogicInfo.getBondName())).map(this::buildBondPort).collect(Collectors.toList());
        ArrayList<LogicPort> logicPorts = new ArrayList<LogicPort>();
        for (StorageLogicInfo logicInfo : storageInfo.getLogicInfo()) {
            if (StringUtils.isEmpty((CharSequence)logicInfo.getIp())) {
                log.info("id:{}. logic port ip : {} is empty.", (Object)logicInfo.getId(), (Object)logicInfo.getIp());
                continue;
            }
            BondPort bondPort = bandPorts.stream().filter(bondPort1 -> bondPort1.getName().equals(logicInfo.getBondName())).findFirst().orElse(BondPort.builder().build());
            LogicPort logicPort = LogicPort.builder().name("logic_port_" + logicInfo.getIp()).ip(logicInfo.getIp()).subnetMask(storageInfo.getNetmask()).gateway(storageInfo.getGateway()).location(logicInfo.getNetCardName()).portType(PortType.parse((String)logicInfo.getPortType())).dataProtocol(DataProtocol.NFS_CIFS).bondPort(bondPort).vlanId(String.valueOf(logicInfo.getVlanId())).vlan(this.getVlan(logicInfo)).build();
            log.info("logic port:{}", (Object)JsonUtils.toJson((Object)logicPort));
            logicPorts.add(logicPort);
        }
        return LogicPort.builder().dataProtocol(DataProtocol.NFS_CIFS).logicPort(logicPorts).bondPorts(bandPorts).build();
    }

    private Vlan getVlan(StorageLogicInfo storageLogicInfo) {
        if (!Objects.equals(storageLogicInfo.getPortType(), "VLAN")) {
            return Vlan.builder().build();
        }
        return Vlan.builder().tag(String.valueOf(storageLogicInfo.getVlanId())).portType(this.getPortType(storageLogicInfo)).port(this.getHomePort(storageLogicInfo)).build();
    }

    private PortType getPortType(StorageLogicInfo storageLogicInfo) {
        if (StringUtils.isNotEmpty((CharSequence)storageLogicInfo.getBondName())) {
            return PortType.BOND_PORT;
        }
        return PortType.ETH_PORT;
    }

    private String getHomePort(StorageLogicInfo storageLogicInfo) {
        if (StringUtils.isNotEmpty((CharSequence)storageLogicInfo.getBondName())) {
            return storageLogicInfo.getBondName();
        }
        return storageLogicInfo.getNetCardName();
    }

    private BondPort buildBondPort(StorageLogicInfo storageLogicInfo) {
        String[] recordArr = storageLogicInfo.getNetCardName().split(",");
        List ports = Arrays.stream(recordArr).collect(Collectors.toList());
        return BondPort.builder().name(storageLogicInfo.getBondName()).ports(ports).build();
    }

    private StoragePoolConfig buildStoragePool(StorageInfo storageInfo) {
        return StoragePoolConfig.builder().name(storageInfo.getPoolInfo().getPoolName()).raidLevel("5").raidMemberNum("25").hotSparePolicy("1").engineIds(this.buildStorageEngineIds(storageInfo)).capacityAlarmThreshold("80").capacityUsedUpAlarmThreshold("90").build();
    }

    private List<String> buildStorageEngineIds(StorageInfo storageInfo) {
        return CollectionUtils.emptyIfNull(storageInfo.getLogicInfo()).stream().filter(info -> StringUtils.isNotEmpty((CharSequence)info.getManageIp())).map(info -> info.getId().substring(0, 4)).distinct().collect(Collectors.toList());
    }

    private List<FileResource> buildFileResources(StorageInfo storageInfo) {
        ArrayList<FileResource> fileResources = new ArrayList<FileResource>();
        FileResource fileResource = FileResource.builder().fileSystem(this.buildFileSystem(storageInfo)).nfs(this.buildNfs()).cifs(this.buildCifs()).build();
        fileResources.add(fileResource);
        return fileResources;
    }

    private FileSystem buildFileSystem(StorageInfo storageInfo) {
        return FileSystem.builder().name("fileSystem001").storagePoolId("0").description("").capacityThreshold(80).securityStyle("3").isShowSnapDir(true).aTime(false).aTimeUpdateMode(0xFFFFFFFFL).workLoadTypeId(11).isAuditLogFs(false).scheduleName("NAS_DEFAULT_BUILDIN").capacity(this.transToByte(storageInfo)).vstoreId("0").build();
    }

    private long transToByte(StorageInfo storageInfo) {
        try {
            return Long.parseLong(storageInfo.getPoolInfo().getCapacity()) * 1024L * 1024L * 1024L / 512L;
        }
        catch (NumberFormatException ex) {
            log.error("number :{} format error", (Object)storageInfo.getPoolInfo().getCapacity());
            throw new DeployException((ErrorKey)StorageDeployError.CAPACITY_INPUT_ERROR);
        }
    }

    private List<Nfs> buildNfs() {
        return Collections.singletonList(Nfs.builder().description("").characterEncoding("0").vstoreId("0").nfsPermissions(this.buildNfsPermissions()).build());
    }

    private List<NfsPermission> buildNfsPermissions() {
        ArrayList<NfsPermission> nfsPermissions = new ArrayList<NfsPermission>();
        NfsPermission nfsPermission = NfsPermission.builder().name("*").accessVal("1").allSquash("1").rootSquash("0").secure("1").sync("0").vstoreId("0").build();
        nfsPermissions.add(nfsPermission);
        return nfsPermissions;
    }

    private List<Cifs> buildCifs() {
        return Collections.singletonList(Cifs.builder().name("f1_CIFS_Share_" + System.currentTimeMillis()).description("").enableNotify(true).enableCa(true).cifsPermissions(this.buildCifsPermissions()).vstoreId("0").build());
    }

    private List<CifsPermission> buildCifsPermissions() {
        ArrayList<CifsPermission> cifsPermissions = new ArrayList<CifsPermission>();
        CifsPermission cifsPermission = CifsPermission.builder().name("@Everyone").domainType(2).permission(1).vstoreId("0").build();
        cifsPermissions.add(cifsPermission);
        return cifsPermissions;
    }

    private IpConfig buildIpConfig(StorageInfo storageInfo) {
        return IpConfig.builder().ctrlAIp(storageInfo.getAManagerIp()).ctrlBIp(storageInfo.getBManagerIp()).subnetMask(storageInfo.getNetmask()).ipv4GateWay(storageInfo.getGateway()).build();
    }
}

