/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.integrate;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.CampusCoreIntegrateClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.CampusIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.IntegrateConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.CampusIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class CampusIntegrateExternalTask {
    private static final Logger log = LoggerFactory.getLogger(CampusIntegrateExternalTask.class);
    private static final String CAMPUS_INTEGRATE = "eCampusCoreIntegrate:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final IntegrateConverter integrateConverter;
    private final CampusCoreIntegrateClient campusCoreIntegrateClient;

    @Bean
    @ExternalTaskSubscription(value="startCampusCoreIntegrate")
    public ExternalTaskHandler startCampusCoreIntegrate() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((CampusCoreIntegrateClient)this.campusCoreIntegrateClient).startCampusCoreIntegrateTask(arg_0), CAMPUS_INTEGRATE), this.retryTaskHandler(arg_0 -> ((CampusCoreIntegrateClient)this.campusCoreIntegrateClient).startCampusCoreIntegrateTask(arg_0), true, CAMPUS_INTEGRATE));
    }

    private ExternalTaskHandler startHandler(Consumer<CampusIntegrateParams> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    @Bean
    @ExternalTaskSubscription(value="queryCampusCoreIntegrateDetail")
    public ExternalTaskHandler queryCampusCoreIntegrateDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(CAMPUS_INTEGRATE), this.retryTaskHandler(arg_0 -> ((CampusCoreIntegrateClient)this.campusCoreIntegrateClient).retryCampusCoreIntegrateTask(arg_0), false, CAMPUS_INTEGRATE));
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> this.queryHandler(type, externalTask, externalTaskService);
    }

    void queryHandler(String type, ExternalTask externalTask, ExternalTaskService externalTaskService) {
        Response response = this.campusCoreIntegrateClient.queryCampusCoreIntegrateTaskDetail(type.concat(externalTask.getProcessInstanceId()));
        if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
            log.error("query CampusCore integrate eDME details failed, response error.");
            return;
        }
        DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
    }

    private ExternalTaskHandler retryTaskHandler(Consumer<CampusIntegrateParams> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<CampusIntegrateParams> action, boolean isNotifyFinish, String type) {
        Optional<CampusIntegrateVo> param = Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), IntegrateDmeProcessConfig.class)).map(IntegrateDmeProcessConfig::getCampusIntegrateVo);
        if (!param.isPresent()) {
            log.error("eCampusCore integrate failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            CampusIntegrateVo campusIntegrateVo = param.get();
            action.accept(this.integrateConverter.toCampusIntegrateParams(campusIntegrateVo, type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("eCampusCore integrate failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    public CampusIntegrateExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, IntegrateConverter integrateConverter, CampusCoreIntegrateClient campusCoreIntegrateClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.integrateConverter = integrateConverter;
        this.campusCoreIntegrateClient = campusCoreIntegrateClient;
    }
}

