/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.integrate;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.HiCloudIntegrateClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.HiCloudIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.IntegrateConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.HiCloudIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class HiCloudIntegrateExternalTask {
    private static final Logger log = LoggerFactory.getLogger(HiCloudIntegrateExternalTask.class);
    private static final String HICLOUD_INTEGRATE = "hiCloudIntegrate:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final IntegrateConverter integrateConverter;
    private final HiCloudIntegrateClient hiCloudIntegrateClient;

    @Bean
    @ExternalTaskSubscription(value="startHiCloudIntegrate")
    public ExternalTaskHandler startHiCloudIntegrate() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((HiCloudIntegrateClient)this.hiCloudIntegrateClient).startHiCloudIntegrateTask(arg_0), HICLOUD_INTEGRATE), this.retryTaskHandler(arg_0 -> ((HiCloudIntegrateClient)this.hiCloudIntegrateClient).retryHiCloudIntegrateTask(arg_0), true, HICLOUD_INTEGRATE));
    }

    @Bean
    @ExternalTaskSubscription(value="queryHiCloudIntegrateDetail")
    public ExternalTaskHandler queryHiCloudIntegrateDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(HICLOUD_INTEGRATE), this.retryTaskHandler(arg_0 -> ((HiCloudIntegrateClient)this.hiCloudIntegrateClient).retryHiCloudIntegrateTask(arg_0), false, HICLOUD_INTEGRATE));
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> {
            Response response = this.hiCloudIntegrateClient.queryHiCloudIntegrateTaskDetail(type.concat(externalTask.getProcessInstanceId()));
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query hiCloud integrate eDME details failed, response error.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    private ExternalTaskHandler startHandler(Consumer<HiCloudIntegrateParams> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    private ExternalTaskHandler retryTaskHandler(Consumer<HiCloudIntegrateParams> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<HiCloudIntegrateParams> action, boolean isNotifyFinish, String type) {
        Optional<HiCloudIntegrateVo> param = Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), IntegrateDmeProcessConfig.class)).map(IntegrateDmeProcessConfig::getHiCloudIntegrateVo);
        if (!param.isPresent()) {
            log.error("hiCloud integrate failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            HiCloudIntegrateVo hiCloudIntegrateVo = param.get();
            action.accept(this.integrateConverter.toHiCloudIntegrateParams(hiCloudIntegrateVo, type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("hiCloud integrate failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    public HiCloudIntegrateExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, IntegrateConverter integrateConverter, HiCloudIntegrateClient hiCloudIntegrateClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.integrateConverter = integrateConverter;
        this.hiCloudIntegrateClient = hiCloudIntegrateClient;
    }
}

