/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.integrate;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.SfsIntegrateClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.SfsIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.IntegrateConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.SfsIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class SfsIntegrateExternalTask {
    private static final Logger log = LoggerFactory.getLogger(SfsIntegrateExternalTask.class);
    private static final String SFS_INTEGRATE = "sfsIntegrate:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final IntegrateConverter integrateConverter;
    private final SfsIntegrateClient sfsIntegrateClient;

    @Bean
    @ExternalTaskSubscription(value="startSfsIntegrate")
    public ExternalTaskHandler startSfsIntegrate() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((SfsIntegrateClient)this.sfsIntegrateClient).startSfsIntegrateTask(arg_0), SFS_INTEGRATE), this.retryTaskHandler(arg_0 -> ((SfsIntegrateClient)this.sfsIntegrateClient).retrySfsIntegrateTask(arg_0), true, SFS_INTEGRATE));
    }

    @Bean
    @ExternalTaskSubscription(value="querySfsIntegrateDetail")
    public ExternalTaskHandler querySfsIntegrateDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(SFS_INTEGRATE), this.retryTaskHandler(arg_0 -> ((SfsIntegrateClient)this.sfsIntegrateClient).retrySfsIntegrateTask(arg_0), false, SFS_INTEGRATE));
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> {
            Response response = this.sfsIntegrateClient.querySfsIntegrateTaskDetail(type.concat(externalTask.getProcessInstanceId()));
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query Sfs integrate eDME details failed, response error.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    private ExternalTaskHandler startHandler(Consumer<SfsIntegrateParams> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    private ExternalTaskHandler retryTaskHandler(Consumer<SfsIntegrateParams> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<SfsIntegrateParams> action, boolean isNotifyFinish, String type) {
        Optional<SfsIntegrateVo> param = Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), IntegrateDmeProcessConfig.class)).map(IntegrateDmeProcessConfig::getSfsIntegrateVo);
        if (!param.isPresent()) {
            log.error("sfs integrate failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            SfsIntegrateVo sfsIntegrateVo = param.get();
            action.accept(this.integrateConverter.toSfsIntegrateParams(sfsIntegrateVo, type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("sfs integrate failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    public SfsIntegrateExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, IntegrateConverter integrateConverter, SfsIntegrateClient sfsIntegrateClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.integrateConverter = integrateConverter;
        this.sfsIntegrateClient = sfsIntegrateClient;
    }
}

