/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.integrate;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.client.UltraVrIntegrateClient;
import com.huawei.yinglong.river.sitedeployment.dcs.componentsintegrate.entity.UltraVrIntegrateParams;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.IntegrateConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.UltraVrIntegrateVo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class UltraVrIntegrateExternalTask {
    private static final Logger log = LoggerFactory.getLogger(UltraVrIntegrateExternalTask.class);
    private static final String ULTRA_INTEGRATE = "ultraVRIntegrate:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final IntegrateConverter integrateConverter;
    private final UltraVrIntegrateClient ultraVrIntegrateClient;

    @Bean
    @ExternalTaskSubscription(value="startUltraVRIntegrate")
    public ExternalTaskHandler startUltraVRIntegrate() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((UltraVrIntegrateClient)this.ultraVrIntegrateClient).startUltraVrIntegrateTask(arg_0), ULTRA_INTEGRATE), this.retryTaskHandler(arg_0 -> ((UltraVrIntegrateClient)this.ultraVrIntegrateClient).retryUltraVrIntegrateTask(arg_0), true, ULTRA_INTEGRATE));
    }

    private ExternalTaskHandler startHandler(Consumer<UltraVrIntegrateParams> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    private ExternalTaskHandler retryTaskHandler(Consumer<UltraVrIntegrateParams> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    @Bean
    @ExternalTaskSubscription(value="queryUltraVRIntegrateDetail")
    public ExternalTaskHandler queryUltraVRIntegrateDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(ULTRA_INTEGRATE), this.retryTaskHandler(arg_0 -> ((UltraVrIntegrateClient)this.ultraVrIntegrateClient).retryUltraVrIntegrateTask(arg_0), false, ULTRA_INTEGRATE));
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> {
            Response response = this.ultraVrIntegrateClient.queryUltraVrIntegrateTaskDetail(type.concat(externalTask.getProcessInstanceId()));
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query UltraVR integrate eDME details failed, response error.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<UltraVrIntegrateParams> action, boolean isNotifyFinish, String type) {
        Optional<UltraVrIntegrateVo> param = Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), IntegrateDmeProcessConfig.class)).map(IntegrateDmeProcessConfig::getUltraVrIntegrateVo);
        if (!param.isPresent()) {
            log.error("ultraVR integrate failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            UltraVrIntegrateVo ultraVrIntegrateVo = param.get();
            action.accept(this.integrateConverter.toUltraVrIntegrateParams(ultraVrIntegrateVo, type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("ultraVR integrate failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    public UltraVrIntegrateExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, IntegrateConverter integrateConverter, UltraVrIntegrateClient ultraVrIntegrateClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.integrateConverter = integrateConverter;
        this.ultraVrIntegrateClient = ultraVrIntegrateClient;
    }
}

