/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.config;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageType;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import com.huawei.yinglong.virtualization.deploy.config.AreaConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaConfigTool {
    private static final Logger log = LoggerFactory.getLogger(AreaConfigTool.class);
    private static volatile AreaConfigTool areaConfigTool;
    private AreaConfig areaConfig;

    private AreaConfigTool() {
        this.initAreaConfigJson();
    }

    public static synchronized AreaConfigTool getInstance() {
        if (Objects.isNull(areaConfigTool)) {
            areaConfigTool = new AreaConfigTool();
        }
        return areaConfigTool;
    }

    public String getTimezoneWithArea(String area) {
        return LanguageUtils.getCurrentLanguage() == LanguageType.EN ? this.areaConfig.getEn().get(area) : this.areaConfig.getZh().get(area);
    }

    private void initAreaConfigJson() {
        try (InputStream resource = this.getClass().getResourceAsStream("/excel-verify/AreaConfig.json");){
            if (Objects.isNull(resource)) {
                log.warn("area config resource not found");
                return;
            }
            String areaJson = IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
            this.areaConfig = (AreaConfig)JsonUtils.toObject((String)areaJson, AreaConfig.class);
        }
        catch (IOException e) {
            log.warn("init area config error", (Throwable)e);
        }
    }
}

