/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.constant;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public enum InstallModeEnum {
    CNA("fc_cna", "FusionCompute"),
    VRM("fc_vrm", "FusionCompute"),
    EBACKUP("eBackup", "eBackup"),
    ULTRAVR("ultraVR", "UltraVR"),
    DME("dme", "eDME"),
    DAYU("eDataInsight", "eDataInsight"),
    HICLOUD("hiCloud", "HiCloud"),
    SFS("SFS", "SFS"),
    A3000_OS("os", "A3000"),
    A3000_STORAGE("storage", "A3000"),
    A3000_SOFTWARE("software", "A3000"),
    A3000_DRIVER_PLUGIN("driverPlugin", "A3000"),
    A3000_RESOURCE_MANAGE("resource", "A3000"),
    SDN("SDN", "SDN"),
    CAMPUS("eCampusCore", "eCampusCore"),
    FUSION_CUBE_8_2_MIGRATION("fusionCubeMigration82", "fusionCube");

    private final String installMode;
    private final String component;

    public static boolean containFcDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && (deployMode.contains(CNA.getInstallMode()) || deployMode.contains(VRM.getInstallMode()));
    }

    public static boolean containFcCnaDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(CNA.getInstallMode());
    }

    public static boolean containFcVrmDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(VRM.getInstallMode());
    }

    public static boolean containEbackupDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(EBACKUP.getInstallMode());
    }

    public static boolean containUltraVRdeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(ULTRAVR.getInstallMode());
    }

    public static boolean containDmeDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(DME.getInstallMode());
    }

    public static boolean containDayuDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(DAYU.getInstallMode());
    }

    public static boolean containHiCloudDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(HICLOUD.getInstallMode());
    }

    public static boolean containSfsDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(SFS.getInstallMode());
    }

    public static boolean containCampusCoreDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(CAMPUS.getInstallMode());
    }

    public static boolean containSdnDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(SDN.getInstallMode());
    }

    public static boolean containFusionCube82xDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(FUSION_CUBE_8_2_MIGRATION.getInstallMode());
    }

    public static boolean containCampusDeployScene(List<String> deployMode) {
        return CollectionUtils.isNotEmpty(deployMode) && deployMode.contains(CAMPUS.getInstallMode());
    }

    public static int transferInstallSceneToValidParamsType(List<String> deployMode) {
        if (InstallModeEnum.containFcCnaDeployScene(deployMode) && InstallModeEnum.containFcVrmDeployScene(deployMode)) {
            return 0;
        }
        if (InstallModeEnum.containFcVrmDeployScene(deployMode)) {
            return 1;
        }
        if (InstallModeEnum.containFcCnaDeployScene(deployMode)) {
            return 2;
        }
        if (InstallModeEnum.containDmeDeployScene(deployMode)) {
            return 3;
        }
        if (InstallModeEnum.containUltraVRdeployScene(deployMode)) {
            return 4;
        }
        if (InstallModeEnum.containEbackupDeployScene(deployMode)) {
            return 5;
        }
        return -1;
    }

    public static boolean isNewMod(String installMode) {
        return installMode.equals(DAYU.getInstallMode()) || installMode.equals(HICLOUD.getInstallMode()) || installMode.equals(SFS.getInstallMode()) || installMode.equals(CAMPUS.getInstallMode()) || installMode.equals(SDN.getInstallMode());
    }

    public static boolean isHighLevelServiceMod(String installMode) {
        return InstallModeEnum.isNewMod(installMode) || InstallModeEnum.isFusionMigration82(installMode);
    }

    private static boolean isFusionMigration82(String installMode) {
        return installMode.equals(FUSION_CUBE_8_2_MIGRATION.getInstallMode());
    }

    private boolean isFusionCubeScene() {
        return Objects.equals("fusionCube", this.component);
    }

    public boolean isA3000Mode() {
        return Objects.equals("A3000", this.component);
    }

    public boolean isCampusMode() {
        return Objects.equals("eCampusCore", this.component);
    }

    public boolean isDcsMode() {
        return !this.isA3000Mode() && !this.isFusionCubeScene();
    }

    private InstallModeEnum(String installMode, String component) {
        this.installMode = installMode;
        this.component = component;
    }

    public String getInstallMode() {
        return this.installMode;
    }

    public String getComponent() {
        return this.component;
    }
}

