/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.constant;

import com.huawei.smartkit.baseserver.report.business.excel.ReportCellStyle;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public enum ReportCellStypeEnum implements ReportCellStyle
{
    DEFAULT(workbook -> ReportCellStypeEnum.createDefaultCellStyle(workbook, IndexedColors.BLACK)),
    TITLE(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.ROYAL_BLUE, IndexedColors.WHITE)),
    HEADER(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.GREY_25_PERCENT)),
    HEADER_CENTER(workbook -> ReportCellStypeEnum.createColorCenterCellStyle(workbook, IndexedColors.GREY_25_PERCENT)),
    FIRST_CNA(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.LIGHT_CORNFLOWER_BLUE)),
    OTHER_CNA(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.LIGHT_TURQUOISE)),
    VRM_DEPLOY(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.ROSE)),
    CLEAN_ENV(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.CORNFLOWER_BLUE)),
    DME_VM(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.LIGHT_GREEN)),
    DME_DATA(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.PALE_BLUE)),
    ULTRAVR(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.LEMON_CHIFFON)),
    EBACKUP(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.AQUA)),
    HI_CLOUD(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.AQUA)),
    EDATAINSIGHT(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.LIGHT_GREEN)),
    SFS(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.AQUA)),
    SDN(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.AQUA)),
    CAMPUS(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.AQUA)),
    MIGRATION(workbook -> ReportCellStypeEnum.createColorCellStyle(workbook, IndexedColors.AQUA));

    private final Function<Workbook, CellStyle> styleCreator;

    private static CellStyle createColorCellStyle(Workbook workbook, IndexedColors bgColor) {
        return ReportCellStypeEnum.createColorCellStyle(workbook, bgColor, IndexedColors.BLACK);
    }

    private static CellStyle createColorCenterCellStyle(Workbook workbook, IndexedColors bgColor) {
        CellStyle cellStyle = ReportCellStypeEnum.createColorCellStyle(workbook, bgColor);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        return cellStyle;
    }

    private static CellStyle createColorCellStyle(Workbook workbook, IndexedColors bgColor, IndexedColors textColor) {
        CellStyle cellStyle = ReportCellStypeEnum.createDefaultCellStyle(workbook, textColor);
        cellStyle.setFillForegroundColor(bgColor.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    private static CellStyle createDefaultCellStyle(Workbook workbook, IndexedColors textColor) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setFont(ReportCellStypeEnum.createCustomFont(workbook, textColor));
        cellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private static Font createCustomFont(Workbook workbook, IndexedColors textColor) {
        Font defaultFont = workbook.createFont();
        defaultFont.setFontName("\u5b8b\u4f53");
        defaultFont.setFontHeightInPoints((short)12);
        defaultFont.setColor(textColor.getIndex());
        return defaultFont;
    }

    public CellStyle createCellStyle(Workbook workbook) {
        return this.styleCreator.apply(workbook);
    }

    private ReportCellStypeEnum(Function<Workbook, CellStyle> styleCreator) {
        this.styleCreator = styleCreator;
    }
}

