/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.controller;

import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.service.ManageIpService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.StorageConverter;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageInfo;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportParams;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportParams;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportResult;
import com.huawei.yinglong.virtualization.deploy.exception.ImportTemplateException;
import com.huawei.yinglong.virtualization.deploy.service.A3000DeployParamsChecker;
import com.huawei.yinglong.virtualization.deploy.service.A3000DeployReportGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployParametersImporter;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"engine/a3000-deploy"})
public class A3000DeployController {
    private static final Logger log = LoggerFactory.getLogger(A3000DeployController.class);
    private final VirtualizationDeployParametersImporter parametersImporter;
    private final ManageIpService manageIpService;
    private final StorageConverter converter;
    private final A3000DeployReportGenerator reportGenerator;
    private final A3000DeployParamsChecker paramsChecker;

    @GetMapping(value={"/download/params"})
    public Response<String> downloadParametersTemplate(@RequestParam(value="downloadPath") String downloadPath) {
        if (ToolEnvUtils.isA3000Expansion()) {
            return this.parametersImporter.handleDownloadTemplate(downloadPath, "deploy.params.a3000.expansion.file");
        }
        return this.parametersImporter.handleDownloadTemplate(downloadPath, "deploy.params.a3000.file");
    }

    @PostMapping(value={"/import/params"})
    public Response<ImportResult<A3000DeployProcessConfig>> importDeployParameters(@RequestBody ImportParams importParams) {
        try {
            return this.parametersImporter.importA3000Parameters(importParams);
        }
        catch (ImportTemplateException exception) {
            ImportResult result = new ImportResult();
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("A3000", String.join((CharSequence)System.lineSeparator(), exception.getLocationError()));
            result.setValidResult(resultMap);
            return ResponseUtil.success(result);
        }
    }

    @PostMapping(value={"/union-check-params"})
    public Response<List<String>> unionCheckParams(@RequestBody A3000DeployProcessConfig processConfig) {
        List<String> validResults = this.paramsChecker.validUnionParams(processConfig);
        log.info("a3000 deploy valid params : {}.", validResults);
        if (CollectionUtils.isEmpty(validResults)) {
            return ResponseUtil.success(validResults);
        }
        return ResponseUtil.failed(validResults);
    }

    @PostMapping(value={"/export/report"})
    public Response<Boolean> exportDeployReports(@RequestBody ExportParams exportParams) {
        String reportResult = this.reportGenerator.generateReport(exportParams);
        if (StringUtils.isNotEmpty((CharSequence)reportResult)) {
            return ResponseUtil.failed((String)reportResult, (String)"");
        }
        return ResponseUtil.success((Object)true);
    }

    @PostMapping(value={"/storage/config-manage-ip"})
    public Response<Boolean> configStorageManageIp(@RequestBody StorageInfo info) {
        try {
            this.manageIpService.modifyManageIp(this.converter.toDeviceConfig("", info));
            return ResponseUtil.success((Object)true);
        }
        catch (TaskException e) {
            return ResponseUtil.failed((String)e.getErrorMessage(), (String)e.getSuggestMessage());
        }
    }

    public A3000DeployController(VirtualizationDeployParametersImporter parametersImporter, ManageIpService manageIpService, StorageConverter converter, A3000DeployReportGenerator reportGenerator, A3000DeployParamsChecker paramsChecker) {
        this.parametersImporter = parametersImporter;
        this.manageIpService = manageIpService;
        this.converter = converter;
        this.reportGenerator = reportGenerator;
        this.paramsChecker = paramsChecker;
    }
}

