/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.controller;

import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyResultVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.PackageConsistencyVo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.PackageConsistencyImpl;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportParams;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportResult;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckItem;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.exception.ImportTemplateException;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployParametersImporter;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployPrecheckService;
import com.huawei.yinglong.virtualization.deploy.utils.ToolConfigUtils;
import com.huawei.yinglong.virtualization.deploy.utils.integrate.validate.ValidateIntegrateParamsUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"engine/integrate-deploy"})
public class IntegrateDeployController {
    private static final Logger log = LoggerFactory.getLogger(IntegrateDeployController.class);
    private final VirtualizationDeployParametersImporter parametersImporter;
    private final VirtualizationDeployPrecheckService precheckService;
    private final PackageConsistencyImpl packageConsistencyImpl;

    @GetMapping(value={"/download/params"})
    public Response<String> downloadParametersTemplate(@RequestParam(value="downloadPath") String downloadPath) {
        return this.parametersImporter.handleDownloadTemplate(downloadPath, "deploy.params.integrate.file");
    }

    @PostMapping(value={"/import/params"})
    public Response<ImportResult<IntegrateDmeProcessConfig>> importDeployParameters(@RequestBody ImportParams importParams) {
        try {
            return this.parametersImporter.importIntegrateParameters(importParams);
        }
        catch (ImportTemplateException exception) {
            ImportResult result = new ImportResult();
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("integrate", String.join((CharSequence)System.lineSeparator(), exception.getLocationError()));
            result.setValidResult(resultMap);
            return ResponseUtil.success(result);
        }
    }

    @PostMapping(value={"/validate-params"})
    public Response<Map<String, String>> deployDcsValidateParams(@RequestBody IntegrateDmeProcessConfig processConfig) {
        return ValidateIntegrateParamsUtils.validateIntegrateParams(processConfig);
    }

    @GetMapping(value={"/support-component"})
    public Response<List<String>> getSupportComponent() {
        return ResponseUtil.success(Stream.of(InstallModeEnum.HICLOUD, InstallModeEnum.SFS, InstallModeEnum.CAMPUS).map(InstallModeEnum::getComponent).distinct().collect(Collectors.toList()));
    }

    @GetMapping(value={"/precheck/items"})
    public Response<List<CheckItem>> getPrecheckItems(@RequestParam(value="instanceId") String instanceId) {
        return ResponseUtil.success(this.precheckService.getCheckItemsFromFile(instanceId));
    }

    @PostMapping(value={"/precheck/items"})
    public Response<List<CheckResult>> executePreCheckItems(@RequestParam(value="instanceId") String instanceId, @RequestBody List<String> itemIds) {
        return ResponseUtil.success(this.precheckService.executeCheck(instanceId, itemIds));
    }

    @PostMapping(value={"/precheck/items/{instanceId}"})
    public Response<Boolean> updatePrecheckItemsResult(@PathVariable String instanceId, @RequestBody List<CheckItem> checkItems) {
        return ResponseUtil.success((Object)this.precheckService.updateCheckResult(instanceId, checkItems));
    }

    @GetMapping(value={"/ui-config"})
    public Response<Map<String, String>> getUiConfigs() {
        return ResponseUtil.success(ToolConfigUtils.get("integrate"));
    }

    @GetMapping(value={"/consistency/start-package-consistency"})
    public Response<PackageConsistencyVo> deployIntegrateValidatePackageConsistency(@RequestParam(value="path") String path, @RequestParam(value="type") int type, @RequestParam(value="installMode", required=false) String installMode) {
        return this.packageConsistencyImpl.validatePkgConsistency(path, Integer.valueOf(type), StringUtils.defaultString((String)installMode));
    }

    @GetMapping(value={"/consistency/package-consistency-result"})
    public Response<ConsistencyResultVo> deploIntegrateQueryPkgConsistencyResult(@RequestParam(value="uuid") String uuid) {
        return this.packageConsistencyImpl.queryPkgConsistencyResult(uuid);
    }

    public IntegrateDeployController(VirtualizationDeployParametersImporter parametersImporter, VirtualizationDeployPrecheckService precheckService, PackageConsistencyImpl packageConsistencyImpl) {
        this.parametersImporter = parametersImporter;
        this.precheckService = precheckService;
        this.packageConsistencyImpl = packageConsistencyImpl;
    }
}

