/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.controller;

import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyResultVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.PackageConsistencyVo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.ParamTemplateBo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.PortGroupInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.SwitchInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.client.DayuDeployClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeInstallParamFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeInstallServiceFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeInstallTaskFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.impl.DeployEbackupFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.DeployFcCnaImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.PackageConsistencyImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.QueryRunningLogsImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.FcEntityBase;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.ConnectProtocol;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.StorageUnit;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.dvswitch.DvSwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmDeployFitImpl;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.entity.DatastoreVo;
import com.huawei.yinglong.virtualization.deploy.entity.SupportDevice;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportParams;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportParams;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportResult;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckItem;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.service.SupportDeviceService;
import com.huawei.yinglong.virtualization.deploy.service.TimezoneService;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployParametersGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployParametersImporter;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployPrecheckService;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployReportGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationParametersValidator;
import com.huawei.yinglong.virtualization.deploy.utils.ToolConfigUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"engine/virtualization-deploy"})
public class VirtualizationDeployController {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployController.class);
    @Autowired
    private DeployEbackupFitImpl deployEbackupImpl;
    @Autowired
    private DmeInstallServiceFitImpl dmeInstallServiceImpl;
    @Autowired
    private DmeInstallTaskFitImpl dmeInstallTaskImpl;
    @Autowired
    private DmeInstallParamFitImpl dmeInstallParamImpl;
    @Autowired
    private VmDeployFitImpl vmDeployImpl;
    @Autowired
    private PackageConsistencyImpl packageConsistencyImpl;
    @Autowired
    private VirtualizationDeployParametersGenerator parametersGenerator;
    @Autowired
    private VirtualizationDeployParametersImporter parametersImporter;
    @Autowired
    private VirtualizationDeployReportGenerator reportGenerator;
    @Autowired
    private VirtualizationDeployPrecheckService precheckService;
    @Autowired
    private SupportDeviceService supportDeviceService;
    @Autowired
    private TimezoneService timezoneService;
    @Autowired
    private VirtualizationParametersValidator parametersValidator;
    @Autowired
    private QueryRunningLogsImpl queryRunningLogsImpl;
    @Autowired
    private DeployFcCnaImpl deployFcCnaImpl;
    @Autowired
    private DayuDeployClient dayuDeployClient;
    @Autowired
    private BpmEngineService bpmEngineService;

    @PostMapping(value={"/dme/validate-params"})
    public Response<String> deployDmeValidateParams(@RequestBody Map<String, String> params) {
        return this.parametersValidator.validateDmeParams(params);
    }

    @GetMapping(value={"/dme/skip-task/{taskKey}"})
    public Response<Void> deployDmeSkipTask(@PathVariable(value="taskKey") String taskKey) {
        this.dmeInstallTaskImpl.skipTask(taskKey);
        return ResponseUtil.success();
    }

    @GetMapping(value={"/dme/retry-task/{taskKey}"})
    public Response<Void> deployDmeRetryTask(@PathVariable(value="taskKey") String taskKey) {
        this.dmeInstallTaskImpl.retryTask(taskKey);
        return ResponseUtil.success();
    }

    @GetMapping(value={"/eDataInsight/stop"})
    public Response<Void> stopDayuServiceTask() {
        if (this.dayuDeployClient.stopDayuServiceDeploy()) {
            return ResponseUtil.success();
        }
        return ResponseUtil.failed((String)"execute ssh error ", (String)"check ssh connect ip");
    }

    @GetMapping(value={"/dme/param-templates"})
    public Response<List<ParamTemplateBo>> deployDmeGetParamTemplates() {
        List vmTemplates;
        LinkedList templates = new LinkedList();
        List dmeTemplates = this.dmeInstallParamImpl.getParamTemplates();
        if (dmeTemplates != null) {
            templates.addAll(dmeTemplates);
        }
        if ((vmTemplates = this.vmDeployImpl.getVmParamTemplates()) != null) {
            templates.addAll(vmTemplates);
        }
        if (templates.isEmpty()) {
            log.warn("get dme and vm param templates is empty.");
            return ResponseUtil.failed(templates);
        }
        return ResponseUtil.success(templates);
    }

    @GetMapping(value={"/dme/stop-install"})
    public Response<Void> deployDmeStopInstall() {
        this.dmeInstallServiceImpl.stop();
        return ResponseUtil.success();
    }

    @GetMapping(value={"/dme/check-ready"})
    public Response<Boolean> deployDmeCheckReady() {
        return this.dmeInstallServiceImpl.isEnable();
    }

    @PostMapping(value={"/fc/validate-params/{deployType}"})
    public Response<String> deployFcValidateParams(@PathVariable int deployType, @RequestBody FcInstallParamsVo paramsVo) {
        return this.parametersValidator.validateFcParams(deployType, paramsVo);
    }

    @PostMapping(value={"/ultravr/validate-params"})
    public Response<String> deployUltraVRValidateParams(@RequestBody UltraVRParams paramsVo) {
        return this.parametersValidator.validateUltraVRParams(paramsVo);
    }

    @PostMapping(value={"/ebackup/validate-params"})
    public Response<String> deployEbackupValidateParams(@RequestBody EbackupParams paramsVo) {
        return this.parametersValidator.validateEbackupParams(paramsVo);
    }

    @GetMapping(value={"/port-groups"})
    public Response<PortGroupInfo> queryAllPortGroups(@RequestParam(value="instanceId") String instanceId, @RequestParam(value="eventType") String eventType) {
        try {
            List dvSwitches = this.createFcRequestApi(instanceId, eventType).map(ApiClient::getDvSwitches).orElseThrow(() -> new FcTaskException((ErrorKey)ApiError.REQUEST_FAILED, new Object[0]));
            return ResponseUtil.success((Object)PortGroupInfo.builder().switchInfo(dvSwitches.stream().map(this::buildSwitchInfo).collect(Collectors.toList())).build());
        }
        catch (FcTaskException e) {
            log.error("query all port group error.", (Throwable)e);
            return ResponseUtil.failed((String)ResourceConfigLoader.getErrorMessage("error.query.portgroup.failed"), (String)"");
        }
    }

    private SwitchInfo buildSwitchInfo(DvSwitch dvSwitch) {
        return SwitchInfo.builder().switchName(dvSwitch.getName()).portGroupNames(dvSwitch.getPortGroups().stream().map(FcEntityBase::getName).collect(Collectors.toList())).build();
    }

    @GetMapping(value={"/all-datastore"})
    public Response<List<DatastoreVo>> queryAllDatastores(@RequestParam(value="instanceId") String instanceId, @RequestParam(value="eventType") String eventType) {
        try {
            ApiClient apiClient = this.createFcRequestApi(instanceId, eventType).orElseThrow(() -> new FcTaskException((ErrorKey)ApiError.REQUEST_FAILED, new Object[0]));
            List allHosts = apiClient.getAllHost();
            Map<String, String> hostUrnMaps = allHosts.stream().collect(Collectors.toMap(FcEntityBase::getUrn, FcEntityBase::getName));
            Map<String, String> hostIdMaps = allHosts.stream().collect(Collectors.toMap(FcEntityBase::getId, FcEntityBase::getName));
            return ResponseUtil.success(apiClient.getDataStores("").stream().map(datastore -> this.buildDatastoreInfo((DataStore)datastore, hostUrnMaps, hostIdMaps)).collect(Collectors.toList()));
        }
        catch (FcTaskException e) {
            log.error("query all datastore error.", (Throwable)e);
            return ResponseUtil.failed((String)ResourceConfigLoader.getErrorMessage("error.query.datastore.failed"), (String)"");
        }
    }

    private DatastoreVo buildDatastoreInfo(DataStore dataStore, Map<String, String> hostMaps, Map<String, String> hostIdMaps) {
        return DatastoreVo.builder().name(dataStore.getName()).capacityGB(dataStore.getCapacityGB()).freeSizeGB(dataStore.getFreeSizeGB()).storageType(dataStore.getStorageType()).status(dataStore.getStatus()).belongSdName(this.getDatastoreSdName(dataStore)).hosts(this.getHostNames(dataStore, hostMaps)).hostConnectProtocols(this.getHostConnectProtocolMaps(dataStore, hostIdMaps)).build();
    }

    private List<String> getHostNames(DataStore dataStore, Map<String, String> hostMaps) {
        return dataStore.getHosts().stream().map(hostMaps::get).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private Map<String, String> getHostConnectProtocolMaps(DataStore dataStore, Map<String, String> hostIdMaps) {
        return CollectionUtils.emptyIfNull((Collection)dataStore.getHostConnectProtocols()).stream().filter(protocol -> hostIdMaps.containsKey(protocol.getUrn())).collect(Collectors.toMap(protocol -> (String)hostIdMaps.get(protocol.getUrn()), ConnectProtocol::getAccessProtocol));
    }

    private String getDatastoreSdName(DataStore dataStore) {
        return dataStore.getStorageUnits().stream().filter(storageUnit -> Objects.equals(dataStore.getSuName(), storageUnit.getSuName())).filter(storageUnit -> FcRequestUtils.getIdFromUrn((String)dataStore.getSuUrn()).equals(storageUnit.getUrn())).findFirst().map(StorageUnit::getSdName).orElse("");
    }

    private Optional<ApiClient> createFcRequestApi(String instanceId, String eventType) {
        ProcessConfig processConfig = (ProcessConfig)ObjectMapperUtils.transObject((Object)this.bpmEngineService.queryProcessInstance(instanceId).getProcessConfig(), ProcessConfig.class, (Object)new ProcessConfig());
        VirtualizationDeployProcessConfig virCofnig = (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)processConfig.getBusiness(), VirtualizationDeployProcessConfig.class, (Object)new VirtualizationDeployProcessConfig());
        if (Objects.equals("fcDeployEvent", eventType)) {
            return this.createApiClientByFusionComputeParams(virCofnig);
        }
        if (Objects.equals("ultraVRDeployEvent", eventType)) {
            return this.createApiClientByUltraVRParams(virCofnig);
        }
        if (Objects.equals("eBackupDeployEvent", eventType)) {
            return this.createApiClientByEBackupParams(virCofnig);
        }
        if (Objects.equals("vmDeployEvent", eventType)) {
            return this.createApiClientByDmeMaps(virCofnig);
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<ApiClient> createApiClientByFusionComputeParams(VirtualizationDeployProcessConfig virCofnig) {
        if (CollectionUtils.isEmpty(virCofnig.getDeployFc())) {
            return Optional.empty();
        }
        return Optional.ofNullable(virCofnig.getDeployFc().get(0)).map(FcInstallParamsVo::getVrm).map(VrmInstallParamsVo::getVrm).map(vrm -> FcClientService.createApiService((FcLoginInfo)FcLoginInfo.builder().url(FcRequestUtils.toFcUrl((String)(Objects.equals("double", vrm.getMode()) ? vrm.getFloatIp() : vrm.getMasterIp()))).user(Objects.equals("three", vrm.getUserMode()) ? "sysadmin" : "admin").password(Objects.equals("three", vrm.getUserMode()) ? vrm.getSysAdminPwd() : vrm.getAdminPwd()).build()));
    }

    @NotNull
    private Optional<ApiClient> createApiClientByUltraVRParams(VirtualizationDeployProcessConfig virCofnig) {
        return Optional.ofNullable(virCofnig.getUltraVRParams()).map(UltraVRParams::getFusionComputeInfo).map(fcInfo -> FcClientService.createApiService((FcLoginInfo)FcLoginInfo.builder().url(FcRequestUtils.toFcUrl((String)fcInfo.getFloatIp())).user(fcInfo.getUserName()).password(fcInfo.getPassword()).build()));
    }

    @NotNull
    private Optional<ApiClient> createApiClientByEBackupParams(VirtualizationDeployProcessConfig virCofnig) {
        return Optional.ofNullable(virCofnig.getEbackupParams()).map(EbackupParams::getFusionComputeInfo).map(fcInfo -> FcClientService.createApiService((FcLoginInfo)FcLoginInfo.builder().url(FcRequestUtils.toFcUrl((String)fcInfo.getFloatIp())).user(fcInfo.getUserName()).password(fcInfo.getPassword()).build()));
    }

    @NotNull
    private Optional<ApiClient> createApiClientByDmeMaps(VirtualizationDeployProcessConfig virCofnig) {
        return Optional.ofNullable(virCofnig.getDmeData()).filter(maps -> maps.containsKey("vm_fc_url")).map(maps -> FcClientService.createApiService((FcLoginInfo)FcLoginInfo.builder().url(FcRequestUtils.toFcUrl((String)((String)maps.get("vm_fc_url")))).user((String)maps.get("vm_fc_user")).password((String)maps.get("vm_fc_password")).build()));
    }

    @PostMapping(value={"/validate-params"})
    public Response<Map<String, String>> deployDcsValidateParams(@RequestBody VirtualizationDeployProcessConfig processConfig) {
        return this.parametersValidator.validateDcsParams(processConfig);
    }

    @GetMapping(value={"/consistency/start-package-consistency"})
    public Response<PackageConsistencyVo> deployFcValidatePackageConsistency(@RequestParam(value="path") String path, @RequestParam(value="type") int type, @RequestParam(value="installMode", required=false) String installMode) {
        return this.packageConsistencyImpl.validatePkgConsistency(path, Integer.valueOf(type), StringUtils.defaultString((String)installMode));
    }

    @GetMapping(value={"/consistency/package-consistency-result"})
    public Response<ConsistencyResultVo> deployFcQueryPkgConsistencyResult(@RequestParam(value="uuid") String uuid) {
        return this.packageConsistencyImpl.queryPkgConsistencyResult(uuid);
    }

    @GetMapping(value={"/consistency/start-package-consistency-sync"})
    public Response<ConsistencyResultVo> deployFcSyncQueryPkgConsistencyResult(@RequestParam(value="path") String path, @RequestParam(value="type") int type) {
        return this.packageConsistencyImpl.syncValidatePkgConsistency(path, Integer.valueOf(type));
    }

    @GetMapping(value={"/fc/query-remote-running-log"})
    public Response<String> queryRemoteRunningLogs(@RequestParam(value="taskId") String taskId, @RequestParam(value="type") int logType) {
        return this.queryRunningLogsImpl.queryRemoteRunningLogs(taskId, Integer.valueOf(logType));
    }

    @GetMapping(value={"/fc/skip-cna-node"})
    public Response<Boolean> skipInstallCnaNode(@RequestParam(value="taskId") String taskId, @RequestParam(value="key") String key) {
        return this.deployFcCnaImpl.skipDeployCnaNode(taskId, key);
    }

    @PostMapping(value={"/export/params"})
    public Response<Boolean> exportDeployParameters(@RequestBody ExportParams exportParams) {
        log.info("Start to export DCS deploy parameters.");
        String exportResult = this.parametersGenerator.generateParameter(exportParams);
        if (StringUtils.isNotEmpty((CharSequence)exportResult)) {
            return ResponseUtil.failed((String)exportResult, (String)"");
        }
        log.info("Export DCS deploy parameters successfully.");
        return ResponseUtil.success();
    }

    @PostMapping(value={"/import/params"})
    public Response<ImportResult<VirtualizationDeployProcessConfig>> importDeployParameters(@RequestBody ImportParams importParams) {
        return this.parametersImporter.importParameters(importParams, false);
    }

    @PostMapping(value={"/import/new/params"})
    public Response<ImportResult<VirtualizationDeployProcessConfig>> importDeployDayuOrHicloudParameters(@RequestBody ImportParams importParams) {
        return this.parametersImporter.importParameters(importParams, true);
    }

    @GetMapping(value={"/download/params"})
    public Response<String> downloadParametersTemplate(@RequestParam(value="downloadPath") String downloadPath) {
        return this.parametersImporter.handleDownloadTemplate(downloadPath, "deploy.params.template.file");
    }

    @GetMapping(value={"/download/params/fusionCubeMigration"})
    public Response<String> downloadFusionCubeTemplate(@RequestParam(value="downloadPath") String downloadPath) {
        return this.parametersImporter.handleDownloadTemplate(downloadPath, "deploy.params.template.fusionCube.file");
    }

    @GetMapping(value={"/download/params/device"})
    public Response<String> downloadDeviceTemplate(@RequestParam(value="downloadPath") String downloadPath) {
        return this.parametersImporter.handleDownloadTemplate(downloadPath, "deploy.params.device.file");
    }

    @PostMapping(value={"/export/report"})
    public Response<Boolean> exportDeployReports(@RequestBody ExportParams exportParams) {
        log.info("Start to export DCS deploy report.");
        String reportResult = this.reportGenerator.generateReport(exportParams);
        if (StringUtils.isNotEmpty((CharSequence)reportResult)) {
            return ResponseUtil.failed((String)reportResult, (String)"");
        }
        log.info("Export DCS deploy report successfully.");
        return ResponseUtil.success((Object)true);
    }

    @GetMapping(value={"/precheck/items"})
    public Response<List<CheckItem>> getPrecheckItems(@RequestParam(value="instanceId") String instanceId) {
        return ResponseUtil.success(this.precheckService.getCheckItemsFromFile(instanceId));
    }

    @PostMapping(value={"/precheck/items"})
    public Response<List<CheckResult>> executePreCheckItems(@RequestParam(value="instanceId") String instanceId, @RequestBody List<String> itemIds) {
        log.info("Start to execute the pre-deployment check items.");
        return ResponseUtil.success(this.precheckService.executeCheck(instanceId, itemIds));
    }

    @PostMapping(value={"/precheck/items/{instanceId}"})
    public Response<Boolean> updatePrecheckItemsResult(@PathVariable String instanceId, @RequestBody List<CheckItem> checkItems) {
        log.info("Start to update the pre-deployment check items.");
        return ResponseUtil.success((Object)this.precheckService.updateCheckResult(instanceId, checkItems));
    }

    @GetMapping(value={"/support-device"})
    public Response<List<SupportDevice>> getDeployToolsSupportDevices(@RequestParam(value="version") String version) {
        return ResponseUtil.success(this.supportDeviceService.querySupportDevices(StringUtils.defaultString((String)version)));
    }

    @GetMapping(value={"/timezone"})
    public Response<JSONObject> getDeployToolsTimeZone() {
        Optional<JSONObject> opTimezones = this.timezoneService.querySupportTimezones();
        if (opTimezones.isPresent()) {
            return ResponseUtil.success((Object)opTimezones.get());
        }
        return ResponseUtil.failed((String)ResourceConfigLoader.getErrorMessage("error.timezone.not.found"), (String)"");
    }

    @GetMapping(value={"/support-component"})
    public Response<List<String>> getSupportComponent() {
        return ResponseUtil.success(ToolEnvUtils.getSupportComponents());
    }

    @GetMapping(value={"/tool-from"})
    public Response<String> getToolFrom() {
        return ResponseUtil.success((Object)ToolEnvUtils.getToolFromValue().getToolEnvValue());
    }

    @GetMapping(value={"/ui-config"})
    public Response<Map<String, String>> getUiConfigs() {
        return ResponseUtil.success(ToolConfigUtils.get("ui"));
    }
}

