/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.crypt;

import com.huawei.encryptbase.utils.AesEncryptUtils;
import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.virtualization.deploy.crypt.BusinessParamCrypter;
import java.util.Arrays;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationDeployCryptService
implements BpmCryptService {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployCryptService.class);
    private boolean isSupportCrypt;

    public boolean encryptProcessBusiness(Map<String, Object> business) {
        return this.cryptProcessBusiness(business, AesEncryptUtils::encryptByAes);
    }

    public boolean decryptProcessBusiness(Map<String, Object> business) {
        return this.cryptProcessBusiness(business, AesEncryptUtils::decryptByAes);
    }

    @Value(value="${smartkit.crypt.enable:false}")
    public void setSupportCrypt(boolean supportCrypt) {
        this.isSupportCrypt = supportCrypt;
    }

    private boolean cryptProcessBusiness(Map<String, Object> business, UnaryOperator<String> cryptor) {
        if (!this.isSupportCrypt || business == null || business.isEmpty()) {
            log.warn("not need to crypt, support : {}.", (Object)this.isSupportCrypt);
            return false;
        }
        Arrays.stream(BusinessParamCrypter.values()).filter(crypter -> business.containsKey(crypter.getParamKey())).flatMap(crypter -> crypter.getSensitiveFields().stream()).forEach(field -> CryptUtil.cryptSpecialField((Map)business, (String)field, (UnaryOperator)cryptor));
        return true;
    }
}

