/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.entity.importing;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.FusionComputeInfo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.TemplateInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupServerInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.CnaInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamBackupVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamCnaVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamDhcpVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamNodeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamSizeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamTimeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.TaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupPlaneInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupVmInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcBackupInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcBaseInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcCommonInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcHostInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcNtpTimeInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployUltraVRInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployVrmInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.campuscore.DeployCampusCoreEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.campuscore.DeployCampusCoreVmEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.hicloud.DeployHiClodParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.hicloud.DeployHiClodVmParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sdn.DeploySdnParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sdn.DeploySdnVmParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sfs.DeploySfsParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sfs.DeploySfsVmParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.vo.FcScenario;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreBaseVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreGlobalVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreLevelVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreVmVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPasswordVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudVmVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsPasswordVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsVmVo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, imports={NumberUtils.class, StringUtils.class, FcScenario.class})
public interface ImportAssembler {
    @Mapping(target="taskId", source="taskId")
    public TaskInfoVo fromVrmBoToTaskVo(DeployFcBaseInfoEntity var1, String var2);

    public InsParamDhcpVo fromVrmCommonBoToDhcpVo(DeployFcCommonInfoEntity var1);

    @Mappings(value={@Mapping(target="vlanId", expression="java(NumberUtils.toInt(hostInfoEntity.getVlanId(),0))"), @Mapping(target="clusterName", expression="java(toClusterName(hostInfoEntity))")})
    public InsParamNodeVo fromCnaBoToNodeVo(DeployFcHostInfoEntity var1);

    default public String toClusterName(DeployFcHostInfoEntity hostInfoEntity) {
        if (hostInfoEntity.getIsMaster().booleanValue() || hostInfoEntity.getIsManageNode().booleanValue()) {
            return "ManagementCluster";
        }
        return hostInfoEntity.getClusterName();
    }

    @Mappings(value={@Mapping(target="mode", source="configMode"), @Mapping(target="registrySizeGb", source="imageCapacity")})
    public InsParamSizeVo fromVrmBoToSizeVo(DeployVrmInfoEntity var1);

    public InsParamTimeVo fromVrmBoToTimeVo(DeployFcNtpTimeInfoEntity var1);

    @Mapping(target="backupCnaNames", expression="java(toCnaNameList(backupInfoEntity.getBackupCnaNames()))")
    public InsParamBackupVo fromVrmBoToBackupVo(DeployFcBackupInfoEntity var1);

    default public List<String> toCnaNameList(String cnaNames) {
        if (StringUtils.isEmpty((CharSequence)cnaNames)) {
            return Collections.emptyList();
        }
        return Arrays.asList(cnaNames.split(";"));
    }

    public InsParamVrmVo fromVrmBoToVrmVo(DeployVrmInfoEntity var1);

    @Mappings(value={@Mapping(target="masterIp", source="masterManageIp"), @Mapping(target="slaveIp", source="slaveManageIp")})
    public InsParamCnaVo fromVrmBoToVrmFcVo(DeployVrmInfoEntity var1);

    public void fromCommonBoToNodeInstallVo(DeployFcCommonInfoEntity var1, @MappingTarget CnaInstallParamsVo var2);

    @Mappings(value={@Mapping(target="masterIp", source="masterNode.hostIp"), @Mapping(target="masterRootPwd", source="commonInfoEntity.rootPwd"), @Mapping(target="masterGandalfPwd", source="commonInfoEntity.gandalfPwd"), @Mapping(target="masterRedisPwd", source="commonInfoEntity.redisPwd"), @Mapping(target="masterBmcIp", source="masterNode.bmcIp"), @Mapping(target="masterBmcUsername", source="masterNode.bmcUsername"), @Mapping(target="masterBmcPwd", source="masterNode.bmcPwd")})
    public void fromBaseAndHostBoToTaskInfoVo(DeployFcHostInfoEntity var1, DeployFcCommonInfoEntity var2, @MappingTarget TaskInfoVo var3);

    @Mappings(value={@Mapping(target="templateInfo", expression="java(fromUltraVRToTemplateInfo(ultraVRInfo))"), @Mapping(target="fusionComputeInfo", expression="java(fromUltraVRToFusionComputeInfo(ultraVRInfo))"), @Mapping(target="taskId", source="taskId")})
    public UltraVRParams fromEntityToUltraVR(DeployUltraVRInfoEntity var1, String var2);

    @Mapping(target="masterIp", source="masterManageIp")
    public void fromVrmFcBoToTaskInfoVo(DeployVrmInfoEntity var1, @MappingTarget TaskInfoVo var2);

    @Mapping(target="floatIp", source="fusionComputeIp")
    public FusionComputeInfo fromUltraVRToFusionComputeInfo(DeployUltraVRInfoEntity var1);

    public TemplateInfo fromUltraVRToTemplateInfo(DeployUltraVRInfoEntity var1);

    @Mappings(value={@Mapping(target="ebackupVmInfo", ignore=true), @Mapping(target="templateInfo", expression="java(fromEbackupToTemplateInfo(ebackupInfo))"), @Mapping(target="fusionComputeInfo", expression="java(fromEbackupToFusionComputeInfo(ebackupInfo))"), @Mapping(target="taskId", source="taskId")})
    public EbackupParams fromEntityToEbackup(DeployEbackupInfoEntity var1, String var2);

    @Mapping(target="floatIp", source="fusionComputeIp")
    public FusionComputeInfo fromEbackupToFusionComputeInfo(DeployEbackupInfoEntity var1);

    public TemplateInfo fromEbackupToTemplateInfo(DeployEbackupInfoEntity var1);

    @Mappings(value={@Mapping(target="managePlane", ignore=true), @Mapping(target="innerPlane", ignore=true), @Mapping(target="productionPlane", ignore=true), @Mapping(target="backupPlane", ignore=true), @Mapping(target="name", source="vmName"), @Mapping(target="ebackupServerInfo", expression="java(fromEntityToServerInfo(ebackupVmInfo))")})
    public EbackupVmInfo fromEntityToEbackupVm(DeployEbackupVmInfoEntity var1);

    @Mappings(value={@Mapping(target="manageIp", source="backupManageIp"), @Mapping(target="hcpPassword", source="backupHcpPassword"), @Mapping(target="rootPassword", source="backupHcpRootPassword")})
    public EbackupServerInfo fromEntityToServerInfo(DeployEbackupVmInfoEntity var1);

    public EbackupVmPlane fromEntityToVmPlane(DeployEbackupPlaneInfoEntity var1);

    @Mappings(value={@Mapping(target="general", source="param"), @Mapping(target="password", source="param"), @Mapping(target="plan", source="param"), @Mapping(target="service", source="param")})
    public HiCloudParamVo toHiCloudParam(DeployHiClodParamEntity var1, List<DeployHiClodVmParamEntity> var2);

    @Mapping(target="dataDisks", source="vmParam")
    public HiCloudVmVo toHiCloudVm(DeployHiClodVmParamEntity var1);

    default public List<Integer> toDataDisks(DeployHiClodVmParamEntity vmParam) {
        return Stream.of(vmParam.getDataDisk1(), vmParam.getDataDisk2(), vmParam.getDataDisk3(), vmParam.getDataDisk4()).map(disk -> NumberUtils.toInt((String)disk, (int)0)).filter(disk -> disk > 0).collect(Collectors.toList());
    }

    public HiCloudGeneralVo toHiCloudGeneral(DeployHiClodParamEntity var1);

    public HiCloudPasswordVo toHiCloudPwd(DeployHiClodParamEntity var1);

    public HiCloudPlanVo toHiCloudPlan(DeployHiClodParamEntity var1);

    @Mappings(value={@Mapping(target="sfsGeneralVo", source="param"), @Mapping(target="sfsPlanVo", source="param"), @Mapping(target="sfsPasswordVo", source="param"), @Mapping(target="sfsVmVo", source="vmParams")})
    public SfsParamVo toSfsParam(DeploySfsParamsEntity var1, List<DeploySfsVmParamsEntity> var2);

    public SfsVmVo toSfsVmVo(DeploySfsVmParamsEntity var1);

    public SfsGeneralVo toSfsGeneralVo(DeploySfsParamsEntity var1);

    public SfsPlanVo toSfsPlanVo(DeploySfsParamsEntity var1);

    public SfsPasswordVo toSfsPasswordVo(DeploySfsParamsEntity var1);

    @Mappings(value={@Mapping(target="campusCoreBaseVo", source="param"), @Mapping(target="campusCoreLevelVo", source="param"), @Mapping(target="campusCoreGlobalVo", source="param"), @Mapping(target="campusCoreVmVos", source="vmParams")})
    public CampusCoreParamVo toCampusCoreParam(DeployCampusCoreEntity var1, List<DeployCampusCoreVmEntity> var2);

    @Mapping(target="dataDisks", source="vmParam")
    public CampusCoreVmVo toCampusCoreVmVo(DeployCampusCoreVmEntity var1);

    default public List<Integer> toDataDisks(DeployCampusCoreVmEntity vmParam) {
        return Stream.of(vmParam.getDataDisk1(), vmParam.getDataDisk2(), vmParam.getDataDisk3()).map(disk -> NumberUtils.toInt((String)disk, (int)0)).collect(Collectors.toList());
    }

    public CampusCoreGlobalVo toCampusCoreGlobalVo(DeployCampusCoreEntity var1);

    public CampusCoreLevelVo toCampusCoreLevelVo(DeployCampusCoreEntity var1);

    public CampusCoreBaseVo toCampusCoreBaseVo(DeployCampusCoreEntity var1);

    @Mappings(value={@Mapping(target="sdnGeneralVo", source="param"), @Mapping(target="sdnPlanVo", source="param"), @Mapping(target="sdnVmVos", source="vmParams"), @Mapping(target="account", source="param")})
    public SdnParamVo toSdnParamVo(DeploySdnParamEntity var1, List<DeploySdnVmParamEntity> var2);
}

