/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.entity.precheck;

import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.step.Step;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CheckMethod {
    @NotNull
    private final String id;
    @NotNull
    private List<Step> steps;

    public CheckResult check() {
        CheckResult checkResult = this.steps.stream().map(Step::execute).reduce(CheckResult::merge).orElse(new CheckResult());
        checkResult.setId(this.id);
        return checkResult;
    }

    CheckMethod(@NotNull String id, @NotNull List<Step> steps) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (steps == null) {
            throw new NullPointerException("steps is marked non-null but is null");
        }
        this.id = id;
        this.steps = steps;
    }

    public static CheckMethodBuilder builder() {
        return new CheckMethodBuilder();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public static class CheckMethodBuilder {
        private String id;
        private List<Step> steps;

        CheckMethodBuilder() {
        }

        public CheckMethodBuilder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        public CheckMethodBuilder steps(@NotNull List<Step> steps) {
            this.steps = steps;
            return this;
        }

        public CheckMethod build() {
            return new CheckMethod(this.id, this.steps);
        }

        public String toString() {
            return "CheckMethod.CheckMethodBuilder(id=" + this.id + ", steps=" + this.steps + ")";
        }
    }
}

