/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.entity.precheck.step;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.OsCmdUtils;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckState;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.step.Step;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CmdStep
implements Step {
    @NotNull
    private final String cmd;
    @Nullable
    private final Predicate<String> strValid;
    @Nullable
    private final Predicate<Matcher> matcherValid;
    @Nullable
    private final Pattern cmdPattern;

    @Override
    public CheckResult execute() {
        String detail = OsCmdUtils.executeCmd((String)this.cmd);
        boolean isPass = this.strValid != null ? this.isStrValid(detail) : this.isMatcherValid(detail);
        return new CheckResult().setDetail(this.getDetail(detail)).setState(isPass ? CheckState.PASS : CheckState.NOT_PASS);
    }

    private boolean isMatcherValid(String detail) {
        if (this.matcherValid == null || this.cmdPattern == null) {
            return false;
        }
        Matcher matcher = this.cmdPattern.matcher(detail);
        return matcher.find() && this.matcherValid.test(matcher);
    }

    private boolean isStrValid(String detail) {
        if (this.cmdPattern == null) {
            return this.strValid.test(detail);
        }
        Matcher matcher = this.cmdPattern.matcher(detail);
        return matcher.find() && this.strValid.test(matcher.group());
    }

    private String getDetail(String detail) {
        return String.format(Locale.ROOT, "cmd:%s%s%s", this.cmd, System.lineSeparator(), detail);
    }

    CmdStep(@NotNull String cmd, @Nullable Predicate<String> strValid, @Nullable Predicate<Matcher> matcherValid, @Nullable Pattern cmdPattern) {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        this.cmd = cmd;
        this.strValid = strValid;
        this.matcherValid = matcherValid;
        this.cmdPattern = cmdPattern;
    }

    public static CmdStepBuilder builder() {
        return new CmdStepBuilder();
    }

    public static class CmdStepBuilder {
        private String cmd;
        private Predicate<String> strValid;
        private Predicate<Matcher> matcherValid;
        private Pattern cmdPattern;

        CmdStepBuilder() {
        }

        public CmdStepBuilder cmd(@NotNull String cmd) {
            this.cmd = cmd;
            return this;
        }

        public CmdStepBuilder strValid(@Nullable Predicate<String> strValid) {
            this.strValid = strValid;
            return this;
        }

        public CmdStepBuilder matcherValid(@Nullable Predicate<Matcher> matcherValid) {
            this.matcherValid = matcherValid;
            return this;
        }

        public CmdStepBuilder cmdPattern(@Nullable Pattern cmdPattern) {
            this.cmdPattern = cmdPattern;
            return this;
        }

        public CmdStep build() {
            return new CmdStep(this.cmd, this.strValid, this.matcherValid, this.cmdPattern);
        }

        public String toString() {
            return "CmdStep.CmdStepBuilder(cmd=" + this.cmd + ", strValid=" + this.strValid + ", matcherValid=" + this.matcherValid + ", cmdPattern=" + this.cmdPattern + ")";
        }
    }
}

