/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.entity.precheck.step;

import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckState;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.step.Step;
import com.huawei.yinglong.virtualization.deploy.utils.IpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.NotNull;

public class IpStep
implements Step {
    @NotNull
    private final List<String> ips;

    @Override
    public CheckResult execute() {
        boolean isPass = true;
        ArrayList<String> result = new ArrayList<String>();
        for (String ip : this.ips) {
            if (!IpUtils.isReachable(ip)) {
                isPass = false;
            }
            result.add(this.getDetail(ip, isPass));
        }
        return new CheckResult().setState(isPass ? CheckState.PASS : CheckState.NOT_PASS).setDetail(String.join((CharSequence)System.lineSeparator(), result));
    }

    private String getDetail(String ip, boolean isPass) {
        return String.format(Locale.ROOT, "ping ip [%s] %s", ip, isPass ? "success" : "fail");
    }

    IpStep(List<String> ips) {
        this.ips = ips;
    }

    public static IpStepBuilder builder() {
        return new IpStepBuilder();
    }

    public static class IpStepBuilder {
        private List<String> ips;

        IpStepBuilder() {
        }

        public IpStepBuilder ips(List<String> ips) {
            this.ips = ips;
            return this;
        }

        public IpStep build() {
            return new IpStep(this.ips);
        }

        public String toString() {
            return "IpStep.IpStepBuilder(ips=" + this.ips + ")";
        }
    }
}

