/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.ObjectValidator;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.Validatable;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.resource.ResourceBundleUtils;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPasswordVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudServiceParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudVmVo;
import com.huawei.yinglong.virtualization.deploy.utils.validate.HicloudParamsValidateUtils;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class HiCloudParamVo
implements Validatable {
    @Valid
    @NotNull
    private HiCloudGeneralVo general;
    @Valid
    @NotNull
    private HiCloudPasswordVo password;
    @Valid
    @NotNull
    private HiCloudServiceParamVo service;
    @Valid
    @NotNull
    private HiCloudPlanVo plan;
    @Valid
    @NotNull
    private List<HiCloudVmVo> vmParams;

    public HiCloudVmVo findVmByName(String vmName) {
        return this.vmParams.stream().filter(vm -> vmName.equals(vm.getHostName())).findFirst().orElse(null);
    }

    public List<String> validate(int scene, Class<?> ... groups) {
        List validResults = ObjectValidator.valid((Object)this, key -> ResourceBundleUtils.getStringFromResource((String)"error_message", (String)key), (Class[])groups);
        validResults.addAll(HicloudParamsValidateUtils.valideParams(this));
        return validResults;
    }

    public HiCloudGeneralVo getGeneral() {
        return this.general;
    }

    public HiCloudPasswordVo getPassword() {
        return this.password;
    }

    public HiCloudServiceParamVo getService() {
        return this.service;
    }

    public HiCloudPlanVo getPlan() {
        return this.plan;
    }

    public List<HiCloudVmVo> getVmParams() {
        return this.vmParams;
    }

    public void setGeneral(HiCloudGeneralVo general) {
        this.general = general;
    }

    public void setPassword(HiCloudPasswordVo password) {
        this.password = password;
    }

    public void setService(HiCloudServiceParamVo service) {
        this.service = service;
    }

    public void setPlan(HiCloudPlanVo plan) {
        this.plan = plan;
    }

    public void setVmParams(List<HiCloudVmVo> vmParams) {
        this.vmParams = vmParams;
    }
}

