/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.fusioncube;

import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.fusioncube.FusionCubeRequestApi;
import com.huawei.yinglong.virtualization.deploy.fusioncube.entity.AccountInfo;
import com.huawei.yinglong.virtualization.deploy.fusioncube.entity.CommResponse;
import com.huawei.yinglong.virtualization.deploy.fusioncube.entity.DeviceAccount;
import com.huawei.yinglong.virtualization.deploy.fusioncube.entity.LoginData;
import com.huawei.yinglong.virtualization.deploy.fusioncube.entity.LoginResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class FusionCubeReqClient {
    private static final Logger log = LoggerFactory.getLogger(FusionCubeReqClient.class);
    private final LoginData loginData = new LoginData();
    private String token;
    private final FusionCubeRequestApi requestApi;

    public FusionCubeReqClient(String ip, String username, String password) {
        this.loginData.setUsername(username).setPassword(password);
        String url = StringUtils.formatTxt((String)"https://%s:443", (Object[])new Object[]{ip});
        this.requestApi = (FusionCubeRequestApi)HttpRequestApiFactory.createRequestApi((String)url, FusionCubeRequestApi.class);
    }

    public Optional<AccountInfo> queryFusionComputeByFcv() {
        try {
            if (!this.login()) {
                log.error("login in query failed.");
                Optional<AccountInfo> optional = Optional.empty();
                return optional;
            }
            Optional<AccountInfo> accountInfo = this.queryFusionComputeInfo();
            log.info("query fusion compute info by fcv result : {}.", accountInfo);
            if (accountInfo.isPresent() && accountInfo.get().checkValid()) {
                log.info("query fusion compute info success.");
                Optional<AccountInfo> optional = accountInfo;
                return optional;
            }
            Optional<AccountInfo> optional = Optional.empty();
            return optional;
        }
        finally {
            log.info("logout in query result : {}.", (Object)this.logout());
        }
    }

    public boolean checkFusionComputeValid() {
        try {
            if (!this.login()) {
                log.error("login in check failed.");
                boolean bl = false;
                return bl;
            }
            Optional<AccountInfo> accountInfo = this.queryFusionComputeInfo();
            log.info("query fusion compute info result : {}.", accountInfo);
            boolean bl = accountInfo.isPresent() && accountInfo.get().checkValid();
            return bl;
        }
        finally {
            log.info("logout in check result : {}.", (Object)this.logout());
        }
    }

    private boolean login() {
        try {
            Response response = this.requestApi.login(this.loginData).execute();
            Optional loginResult = this.parseResponse(response);
            if (loginResult.isPresent()) {
                this.token = ((LoginResult)loginResult.get()).getToken();
                return StringUtils.isNotEmpty((CharSequence)this.token);
            }
        }
        catch (IOException e) {
            log.error("login failed.", (Throwable)e);
        }
        return false;
    }

    private Optional<AccountInfo> queryFusionComputeInfo() {
        try {
            Response response = this.requestApi.queryDeviceAccount(this.buildHeaders()).execute();
            Optional deviceAccount = this.parseResponse(response);
            if (deviceAccount.isPresent()) {
                return Optional.ofNullable(((DeviceAccount)deviceAccount.get()).getFusionCompute());
            }
        }
        catch (IOException e) {
            log.error("query fusion compute failed.", (Throwable)e);
        }
        return Optional.empty();
    }

    private boolean logout() {
        try {
            if (StringUtils.isEmpty((CharSequence)this.token)) {
                log.warn("token is empty, not need to logout.");
                return true;
            }
            return this.isResponseSuccessful(this.requestApi.logout(this.buildHeaders()).execute());
        }
        catch (IOException e) {
            log.error("logout failed.", (Throwable)e);
            return false;
        }
    }

    private <T> Optional<T> parseResponse(Response<CommResponse<T>> response) {
        if (!response.isSuccessful()) {
            return Optional.empty();
        }
        CommResponse commResponse = (CommResponse)response.body();
        if (Objects.nonNull(commResponse) && commResponse.isSuccessfully()) {
            return Optional.ofNullable(commResponse.getData());
        }
        return Optional.empty();
    }

    private <T> boolean isResponseSuccessful(Response<CommResponse<T>> response) {
        if (!response.isSuccessful()) {
            return false;
        }
        CommResponse commResponse = (CommResponse)response.body();
        return Objects.nonNull(commResponse) && commResponse.isSuccessfully();
    }

    private Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", this.token);
        return headers;
    }
}

