/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.client.DeployCampusCoreClient;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.context.DeployCampusCoreContext;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusServiceScenario;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CampusCoreDeployMessageEventListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(CampusCoreDeployMessageEventListener.class);
    private final DeployCampusCoreClient deployCampusCoreClient;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        OperateCmd operateCmd = (OperateCmd)ObjectMapperUtils.transKey((Map)delegateExecution.getVariables(), OperateCmd.class, (String)"operateCmd", null);
        if (Objects.isNull(operateCmd)) {
            log.error("retry param invalid.");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        if (StringUtils.isEmpty((CharSequence)operateCmd.getItemId())) {
            log.error("taskId not exist");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        log.info("current eCampusCore cmd type is {}", (Object)operateCmd.getOperateType());
        if (OperateCmdEnum.RETRY.getOperateCmd().equals(operateCmd.getOperateType()) || OperateCmdEnum.RESUME.getOperateCmd().equals(operateCmd.getOperateType())) {
            DeployCampusCoreContext.getInstance().setCampusServiceScenario(CampusServiceScenario.RETRY);
            log.info("start retry eCampusCore deploy task, taskId: {}.", (Object)operateCmd.getItemId());
            this.deployCampusCoreClient.retrySubTask(operateCmd.getItemId());
            log.info("finish retry eCampusCore deploy task, taskId: {}.", (Object)operateCmd.getItemId());
        }
        if (OperateCmdEnum.SKIP.getOperateCmd().equals(operateCmd.getOperateType())) {
            DeployCampusCoreContext.getInstance().setCampusServiceScenario(CampusServiceScenario.SKIP);
            this.deployCampusCoreClient.retrySubTask(operateCmd.getItemId());
        }
    }

    public CampusCoreDeployMessageEventListener(DeployCampusCoreClient deployCampusCoreClient) {
        this.deployCampusCoreClient = deployCampusCoreClient;
    }
}

