/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.client.DayuDeployClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.DayuServiceTaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuDeployParamsConvert;
import com.huawei.yinglong.virtualization.deploy.listener.DayuListenerUtils;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DayuDeployMessageEventListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(DayuDeployMessageEventListener.class);
    private final DayuDeployClient dayuDeployClient;
    private final BpmCryptService cryptService;
    private final DayuDeployParamsConvert dayuDeployParamsConvert;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        OperateCmd operateCmd = (OperateCmd)ObjectMapperUtils.transKey((Map)delegateExecution.getVariables(), OperateCmd.class, (String)"operateCmd", null);
        if (operateCmd == null) {
            log.error("retry param invalid .");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        log.info("current dayu cmd type is {}", (Object)operateCmd.getOperateType());
        if (OperateCmdEnum.STOP.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start stop dayu service deploy task");
            this.dayuDeployClient.stopDayuServiceDeploy();
        }
        if (OperateCmdEnum.RETRY.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType()) || OperateCmdEnum.RESUME.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            if (DayuServiceTaskStatus.ROLLBACK_SUCCESS.name().equals(DeployDayuContext.getInstance().getDeployServiceState())) {
                DayuListenerUtils.tryToUpdateParams(delegateExecution, this.dayuDeployClient, this.cryptService, this.dayuDeployParamsConvert);
            }
            log.info("start retry dayu service script deploy task");
            this.dayuDeployClient.retryDayuServiceDeploy(operateCmd.getItemId());
        }
        if (OperateCmdEnum.ROLLBACK.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start rollback dayu service deploy task");
            this.dayuDeployClient.rollbackDayuServiceDeploy();
        }
    }

    public DayuDeployMessageEventListener(DayuDeployClient dayuDeployClient, BpmCryptService cryptService, DayuDeployParamsConvert dayuDeployParamsConvert) {
        this.dayuDeployClient = dayuDeployClient;
        this.cryptService = cryptService;
        this.dayuDeployParamsConvert = dayuDeployParamsConvert;
    }
}

