/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.impl.DeployEbackupFitImpl;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EBackupDeployMessageEventListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(EBackupDeployMessageEventListener.class);
    private final DeployEbackupFitImpl deployEbackupImpl;
    private final BpmCryptService cryptService;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        OperateCmd operateCmd = (OperateCmd)ObjectMapperUtils.transKey((Map)delegateExecution.getVariables(), OperateCmd.class, (String)"operateCmd", null);
        if (Objects.isNull(operateCmd)) {
            log.error("retry or skip eBackup param invalid .");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        log.info("current eBackup cmd type is {}", (Object)operateCmd.getOperateType());
        this.tryToUpdateParams(delegateExecution);
        if (OperateCmdEnum.RETRY.getOperateCmd().equals(operateCmd.getOperateType()) || OperateCmdEnum.RESUME.getOperateCmd().equals(operateCmd.getOperateType())) {
            this.deployEbackupImpl.retryItem(operateCmd.getItemId());
            return;
        }
        if (OperateCmdEnum.SKIP.getOperateCmd().equals(operateCmd.getOperateType())) {
            this.deployEbackupImpl.skipItem(operateCmd.getItemId());
        }
    }

    private void tryToUpdateParams(DelegateExecution delegateExecution) {
        Optional<VirtualizationDeployProcessConfig> opProcessConfig = Optional.ofNullable(delegateExecution.getVariable("context")).filter(context -> context instanceof ProcessConfig).map(ProcessConfig.class::cast).map(processConfig -> CryptUtil.decryptDirectBusiness((BpmCryptService)this.cryptService, (ProcessConfig)processConfig)).map(business -> (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)business, VirtualizationDeployProcessConfig.class, null));
        log.info("try to update eBackup params, isPresent : {}.", (Object)opProcessConfig.isPresent());
        if (opProcessConfig.isPresent() && opProcessConfig.get().getEbackupParams() != null) {
            this.deployEbackupImpl.updateEbackupParams(opProcessConfig.get().getEbackupParams());
            log.info("finish to update eBackup params.");
        }
    }

    public EBackupDeployMessageEventListener(DeployEbackupFitImpl deployEbackupImpl, BpmCryptService cryptService) {
        this.deployEbackupImpl = deployEbackupImpl;
        this.cryptService = cryptService;
    }
}

