/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.DeployFcCnaImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.DeployFcVrmImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.UpdateDeployRetryTaskParamImpl;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import com.huawei.yinglong.virtualization.deploy.utils.OperateCmdUtils;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FcDeployMessageEventListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(FcDeployMessageEventListener.class);
    private final DeployFcCnaImpl deployFcCnaImpl;
    private final DeployFcVrmImpl deployFcVrmImpl;
    private final UpdateDeployRetryTaskParamImpl updateDeployRetryTaskParamImpl;
    private final BpmCryptService cryptService;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        OperateCmd operateCmd = (OperateCmd)ObjectMapperUtils.transKey((Map)delegateExecution.getVariables(), OperateCmd.class, (String)"operateCmd", null);
        if (operateCmd == null) {
            log.error("retry param invalid .");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        log.info("current fc cmd type is {}", (Object)operateCmd.getOperateType());
        String taskId = OperateCmdUtils.getExtraMapStringValueByKey(operateCmd.getExtras(), "taskId", "");
        this.tryToUpdateParams(taskId, delegateExecution);
        if (OperateCmdEnum.SKIP.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start skip cna deploy task");
            this.deployFcCnaImpl.skipDeployCnaNode(taskId, operateCmd.getItemId());
        } else if (OperateCmdEnum.RETRY.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start retry vrm deploy task");
            this.deployFcVrmImpl.retryVrmDeployService(taskId);
        }
    }

    private void tryToUpdateParams(String taskId, DelegateExecution delegateExecution) {
        Optional.ofNullable(delegateExecution.getVariable("context")).filter(context -> context instanceof ProcessConfig).map(ProcessConfig.class::cast).map(processConfig -> CryptUtil.decryptDirectBusiness((BpmCryptService)this.cryptService, (ProcessConfig)processConfig)).map(business -> (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)business, VirtualizationDeployProcessConfig.class, null)).ifPresent(processConfig -> this.updateDeployParams(taskId, (VirtualizationDeployProcessConfig)processConfig));
    }

    private void updateDeployParams(String taskId, VirtualizationDeployProcessConfig processConfig) {
        log.info("try to update fc params, isPresent : {}.", (Object)processConfig);
        DeployFcResultUtils.getFcInstallParamsVoFromProcessConfig(taskId, processConfig).ifPresent(fcInstallParamsVo -> {
            DeployFcResultUtils.updateFcVrmSizeScene(processConfig, fcInstallParamsVo);
            this.updateDeployRetryTaskParamImpl.updateDeployRetryTaskParam(fcInstallParamsVo);
            log.info("finish to update fc params.");
        });
    }

    public FcDeployMessageEventListener(DeployFcCnaImpl deployFcCnaImpl, DeployFcVrmImpl deployFcVrmImpl, UpdateDeployRetryTaskParamImpl updateDeployRetryTaskParamImpl, BpmCryptService cryptService) {
        this.deployFcCnaImpl = deployFcCnaImpl;
        this.deployFcVrmImpl = deployFcVrmImpl;
        this.updateDeployRetryTaskParamImpl = updateDeployRetryTaskParamImpl;
        this.cryptService = cryptService;
    }
}

