/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.client.DeployHiCloudClient;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiloudListenerUtils {
    private static final Logger log = LoggerFactory.getLogger(HiloudListenerUtils.class);

    public static void retryHicloudTask(OperateCmd operateCmd, DeployHiCloudClient deployHiCloudClient) {
        if (operateCmd == null) {
            log.error("retry param invalid .");
            throw new ActiveDelegateException(-1, "request params invalidate", "");
        }
        if (StringUtils.isEmpty((CharSequence)operateCmd.getItemId())) {
            log.error("taskId not exist");
            throw new ActiveDelegateException(-1, "request params invalidate", "");
        }
        log.info("current hicloud cmd type is {}", (Object)operateCmd.getOperateType());
        if (OperateCmdEnum.RETRY.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start retry hicloud deploy task");
            deployHiCloudClient.retrySubTask(operateCmd.getItemId());
            log.info("finish retry hicloud deploy task");
        }
    }

    private HiloudListenerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

