/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IntegrateStartProcessListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(IntegrateStartProcessListener.class);
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public void notify(DelegateExecution execution) throws Exception {
        if (this.isDeleteTask(execution)) {
            log.info("delete task, it not need to execute task init.");
            return;
        }
        String processInstanceId = execution.getProcessInstanceId();
        IntegrateDmeProcessConfig processConfig = (IntegrateDmeProcessConfig)this.bpmContextService.getContext(processInstanceId, IntegrateDmeProcessConfig.class);
        List<String> installMode = processConfig.getInstallMode();
        HashMap<String, Boolean> activityCondition = new HashMap<String, Boolean>();
        this.handleUltraVrIntegrateActivityCondition(installMode, activityCondition);
        this.handleHiCloudIntegrateActivityCondition(installMode, activityCondition);
        this.handleSfsIntegrateActivityCondition(installMode, activityCondition);
        this.handleCampusIntegrateActivityCondition(installMode, activityCondition);
        this.runtimeService.setVariable(processInstanceId, "conditionVar", activityCondition);
    }

    private void handleCampusIntegrateActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowCampus = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.CAMPUS.getInstallMode());
        activityCondition.put("campusCoreIntegratement", isShowCampus);
        activityCondition.put("campusCoreIntegrate", isShowCampus);
        activityCondition.put("startCampusCoreIntegrate", isShowCampus);
        activityCondition.put("queryCampusCoreIntegrateDetail", isShowCampus);
    }

    private void handleSfsIntegrateActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowSfs = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.SFS.getInstallMode());
        activityCondition.put("sfsIntegratement", isShowSfs);
        activityCondition.put("sfsIntegrate", isShowSfs);
        activityCondition.put("startSfsIntegrate", isShowSfs);
        activityCondition.put("querySfsIntegrateDetail", isShowSfs);
    }

    private void handleHiCloudIntegrateActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowHiCloud = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.HICLOUD.getInstallMode());
        activityCondition.put("hicloudIntegratement", isShowHiCloud);
        activityCondition.put("hicloudIntegrate", isShowHiCloud);
        activityCondition.put("startHiCloudIntegrate", isShowHiCloud);
        activityCondition.put("queryHiCloudIntegrateDetail", isShowHiCloud);
    }

    private void handleUltraVrIntegrateActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowUltraVr = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.ULTRAVR.getInstallMode());
        activityCondition.put("ultraVRIntegratement", isShowUltraVr);
        activityCondition.put("ultraVRIntegrate", isShowUltraVr);
        activityCondition.put("startUltraVRIntegrate", isShowUltraVr);
        activityCondition.put("queryUltraVRIntegrateDetail", isShowUltraVr);
    }

    private boolean isDeleteTask(DelegateExecution execution) {
        return execution instanceof ExecutionEntity && ((ExecutionEntity)execution).isDeleteRoot();
    }

    public IntegrateStartProcessListener(RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }
}

