/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuBaseParams;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuParamsVo;
import com.huawei.yinglong.virtualization.deploy.utils.VmParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationStartProcessListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationStartProcessListener.class);
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    private static boolean judgeDataInsightDeployType(VirtualizationDeployProcessConfig processConfig, boolean isShowDayu) {
        return isShowDayu && "tool".equals(Optional.ofNullable(processConfig.getDayuParamsVo()).map(DayuParamsVo::getDayuBaseParams).map(DayuBaseParams::getVmDeployType).orElse(""));
    }

    public void notify(DelegateExecution execution) throws Exception {
        if (this.isDeleteTask(execution)) {
            log.info("delete task, not need to execute task init.");
            return;
        }
        String processInstanceId = execution.getProcessInstanceId();
        VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)this.bpmContextService.getContext(processInstanceId, VirtualizationDeployProcessConfig.class);
        List<String> installMode = processConfig.getInstallMode();
        HashMap<String, Boolean> activityCondition = new HashMap<String, Boolean>();
        this.handleFusionComputeActivityCondition(installMode, activityCondition);
        this.handleUltraVRActivityCondition(installMode, activityCondition);
        this.handleEbackupActivityCondition(installMode, activityCondition);
        this.handleDmeActivityCondition(processConfig, activityCondition);
        this.handleDayuActivityCondition(installMode, activityCondition, processConfig);
        this.handleHiCloudActivityCondition(installMode, activityCondition);
        this.handleSfsActivityCondition(installMode, activityCondition);
        this.handleSdnActivityCondition(installMode, activityCondition);
        this.handleCampusCoreActivityCondition(installMode, activityCondition);
        this.handleFusionCubeActivityCondition(installMode, activityCondition);
        this.runtimeService.setVariable(processInstanceId, "conditionVar", activityCondition);
    }

    void handleCampusCoreActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowCampusCore = InstallModeEnum.containCampusCoreDeployScene(installMode);
        activityCondition.put("campusCoreDeploy", isShowCampusCore);
        activityCondition.put("campusCoreVmDeploy", isShowCampusCore);
        activityCondition.put("startCampusCoreVmDeploy", isShowCampusCore);
        activityCondition.put("queryCampusCoreVmProgress", isShowCampusCore);
        activityCondition.put("campusCoreServiceDeploy", isShowCampusCore);
        activityCondition.put("startCampusCoreDeploy", isShowCampusCore);
        activityCondition.put("queryCampusCoreProgress", isShowCampusCore);
    }

    void handleSfsActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowSfs = InstallModeEnum.containSfsDeployScene(installMode);
        activityCondition.put("sfsDeployment", isShowSfs);
        activityCondition.put("sfsDeploy", isShowSfs);
        activityCondition.put("startSfsDeploy", isShowSfs);
        activityCondition.put("querySfsDeployDetail", isShowSfs);
    }

    void handleSdnActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowSfs = InstallModeEnum.containSdnDeployScene(installMode);
        activityCondition.put("sdnDeployment", isShowSfs);
        activityCondition.put("sdnDeploy", isShowSfs);
        activityCondition.put("startSdnDeploy", isShowSfs);
        activityCondition.put("querySdnDeployDetail", isShowSfs);
    }

    void handleFusionCubeActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShow = InstallModeEnum.containFusionCube82xDeployScene(installMode);
        activityCondition.put("fusionCubeMigrationDeployment", isShow);
        activityCondition.put("fusionCubeMigrationDeploy", isShow);
        activityCondition.put("startFusionCubeDeploy", isShow);
        activityCondition.put("queryDeployFusionCubeProgress", isShow);
    }

    private void handleHiCloudActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowHiCloud = InstallModeEnum.containHiCloudDeployScene(installMode);
        activityCondition.put("hiCloudDeploy", isShowHiCloud);
        activityCondition.put("hiCloudVmDeploy", isShowHiCloud);
        activityCondition.put("startHiCloudVmDeploy", isShowHiCloud);
        activityCondition.put("queryHiCloudVmProgress", isShowHiCloud);
        activityCondition.put("hiCloudServiceDeploy", isShowHiCloud);
        activityCondition.put("startHiCloudDeploy", isShowHiCloud);
        activityCondition.put("queryHiCloudProgress", isShowHiCloud);
    }

    void handleDayuActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition, VirtualizationDeployProcessConfig processConfig) {
        boolean isShowDayu = InstallModeEnum.containDayuDeployScene(installMode);
        activityCondition.put("dayuDeploy", isShowDayu);
        boolean isDeployDayuVm = VirtualizationStartProcessListener.judgeDataInsightDeployType(processConfig, isShowDayu);
        activityCondition.put("dayuVmDeploy", isDeployDayuVm);
        activityCondition.put("startDayuVmDeploy", isDeployDayuVm);
        activityCondition.put("queryDayuVmDetail", isDeployDayuVm);
        activityCondition.put("dayuServiceDeploy", isShowDayu);
        activityCondition.put("startDayuDeploy", isShowDayu);
        activityCondition.put("queryDayuProgress", isShowDayu);
    }

    private void handleDmeActivityCondition(VirtualizationDeployProcessConfig processConfig, Map<String, Boolean> activityCondition) {
        boolean isShowDme = InstallModeEnum.containDmeDeployScene(processConfig.getInstallMode());
        activityCondition.put("dmeDeploy", isShowDme);
        activityCondition.put("dmeDataDeploy", isShowDme);
        activityCondition.put("startDmeDeploy", isShowDme);
        activityCondition.put("queryDmeDeployDetail", isShowDme);
        boolean isShowDmeVm = VmParamUtils.isAutoCreateVm(processConfig.getDmeData());
        activityCondition.put("dmeVmDeploy", isShowDmeVm);
        activityCondition.put("startDmeVmDeploy", isShowDmeVm);
        activityCondition.put("queryDmeVmDeployDetail", isShowDmeVm);
    }

    private void handleEbackupActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowEBackup = InstallModeEnum.containEbackupDeployScene(installMode);
        activityCondition.put("eBackupDeployment", isShowEBackup);
        activityCondition.put("eBackupDeploy", isShowEBackup);
        activityCondition.put("startEBackupDeploy", isShowEBackup);
        activityCondition.put("queryEBackupDeployDetail", isShowEBackup);
    }

    private void handleUltraVRActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowUltraVR = InstallModeEnum.containUltraVRdeployScene(installMode);
        activityCondition.put("ultraVRDeployment", isShowUltraVR);
        activityCondition.put("ultraVRDeploy", isShowUltraVR);
        activityCondition.put("startUltraVRDeploy", isShowUltraVR);
        activityCondition.put("queryUltraVRDeployDetail", isShowUltraVR);
    }

    void handleFusionComputeActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowFcVrm = InstallModeEnum.containFcVrmDeployScene(installMode);
        boolean isShowFcCna = InstallModeEnum.containFcCnaDeployScene(installMode);
        activityCondition.put("fcDeploy#multiInstanceBody", isShowFcVrm || isShowFcCna);
        activityCondition.put("firstNodeDeploy", isShowFcVrm || isShowFcCna);
        activityCondition.put("startHostDeploy", isShowFcCna);
        activityCondition.put("queryHostDeployDetail", isShowFcCna);
        activityCondition.put("startDeployInstaller", isShowFcVrm || isShowFcCna);
        activityCondition.put("queryDeployInstallerProgress", isShowFcVrm || isShowFcCna);
        activityCondition.put("fcEnvClean", isShowFcVrm || isShowFcCna);
        activityCondition.put("startFcEnvClean", isShowFcVrm || isShowFcCna);
        activityCondition.put("queryFcCleanEvnDetail", isShowFcVrm || isShowFcCna);
        activityCondition.put("cnaDeploy", isShowFcCna);
        activityCondition.put("startCnaDeploy", isShowFcCna);
        activityCondition.put("queryCnaDeployDetail", isShowFcCna);
        activityCondition.put("vrmDeploy", isShowFcVrm);
        activityCondition.put("startVrmDeploy", isShowFcVrm);
        activityCondition.put("queryVrmDeployDetail", isShowFcVrm);
    }

    private boolean isDeleteTask(DelegateExecution execution) {
        return execution instanceof ExecutionEntity && ((ExecutionEntity)execution).isDeleteRoot();
    }

    public VirtualizationStartProcessListener(RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }
}

