/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener;

import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmDeployFitImpl;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.VmParamUtils;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VmDeployMessageEventListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(VmDeployMessageEventListener.class);
    private final VmDeployFitImpl vmDeployImpl;
    private final BpmCryptService cryptService;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        OperateCmd operateCmd = (OperateCmd)ObjectMapperUtils.transKey((Map)delegateExecution.getVariables(), OperateCmd.class, (String)"operateCmd", null);
        if (operateCmd == null) {
            log.error("retry or skip vm param invalid .");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        log.info("current vm cmd type is {}", (Object)operateCmd.getOperateType());
        this.tryToUpdateParams(delegateExecution);
        if (OperateCmdEnum.RETRY.getOperateCmd().equals(operateCmd.getOperateType())) {
            this.vmDeployImpl.retryItem(operateCmd.getItemId());
            return;
        }
        if (OperateCmdEnum.SKIP.getOperateCmd().equals(operateCmd.getOperateType())) {
            this.vmDeployImpl.skipItem(operateCmd.getItemId());
        }
    }

    private void tryToUpdateParams(DelegateExecution delegateExecution) {
        Optional<VirtualizationDeployProcessConfig> opProcessConfig = Optional.ofNullable(delegateExecution.getVariable("context")).filter(context -> context instanceof ProcessConfig).map(ProcessConfig.class::cast).map(processConfig -> CryptUtil.decryptDirectBusiness((BpmCryptService)this.cryptService, (ProcessConfig)processConfig)).map(business -> (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)business, VirtualizationDeployProcessConfig.class, null));
        log.info("try to update vm params, isPresent : {}.", (Object)opProcessConfig.isPresent());
        if (opProcessConfig.isPresent() && opProcessConfig.get().getDmeData() != null) {
            this.vmDeployImpl.updateParam(VmParamUtils.createVmParam(opProcessConfig.get().getDmeData()));
            log.info("finish to update vm params.");
        }
    }

    public VmDeployMessageEventListener(VmDeployFitImpl vmDeployImpl, BpmCryptService cryptService) {
        this.vmDeployImpl = vmDeployImpl;
        this.cryptService = cryptService;
    }
}

