/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener.a3000;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class A3000StartProcessListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(A3000StartProcessListener.class);
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public void notify(DelegateExecution execution) throws Exception {
        if (this.isDeleteTask(execution)) {
            log.info("delete task, it not need to execute task init.");
            return;
        }
        String processInstanceId = execution.getProcessInstanceId();
        A3000DeployProcessConfig processConfig = (A3000DeployProcessConfig)this.bpmContextService.getContext(processInstanceId, A3000DeployProcessConfig.class);
        List<String> installMode = processConfig.getInstallMode();
        HashMap<String, Boolean> activityCondition = new HashMap<String, Boolean>();
        this.handleOSInstallActivityCondition(installMode, activityCondition);
        this.handleStorageConfigActivityCondition(installMode, activityCondition);
        this.handleSoftwareDeployActivityCondition(installMode, activityCondition);
        this.handleResourceManageActivityCondition(installMode, activityCondition);
        this.runtimeService.setVariable(processInstanceId, "conditionVar", activityCondition);
    }

    private void handleOSInstallActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowOsInstall = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.A3000_OS.getInstallMode());
        activityCondition.put("osInstallParent", isShowOsInstall);
        activityCondition.put("osInstall", isShowOsInstall);
        activityCondition.put("startOsInstall", isShowOsInstall);
        activityCondition.put("queryOsInstall", isShowOsInstall);
    }

    private void handleStorageConfigActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowStorageConfig = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.A3000_STORAGE.getInstallMode());
        activityCondition.put("storageConfigParent", isShowStorageConfig);
        activityCondition.put("storageConfig", isShowStorageConfig);
        activityCondition.put("startStorageConfig", isShowStorageConfig);
        activityCondition.put("queryStorageConfig", isShowStorageConfig);
    }

    private void handleSoftwareDeployActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowSoftware = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.A3000_SOFTWARE.getInstallMode());
        activityCondition.put("eContainerDeploy", isShowSoftware);
        activityCondition.put("startEContainerDeploy", isShowSoftware);
        activityCondition.put("queryEContainerDeploy", isShowSoftware);
        boolean isShowDriverPlugin = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.A3000_DRIVER_PLUGIN.getInstallMode());
        activityCondition.put("driverPluginInstall", isShowDriverPlugin);
        activityCondition.put("startDriverPluginInstall", isShowDriverPlugin);
        activityCondition.put("queryDriverPluginInstall", isShowDriverPlugin);
        activityCondition.put("softwareDeployParent", isShowSoftware || isShowDriverPlugin);
    }

    private void handleResourceManageActivityCondition(List<String> installMode, Map<String, Boolean> activityCondition) {
        boolean isShowResourceManage = CollectionUtils.emptyIfNull(installMode).contains(InstallModeEnum.A3000_RESOURCE_MANAGE.getInstallMode());
        activityCondition.put("resourceManageParent", isShowResourceManage);
        activityCondition.put("metavisionManage", isShowResourceManage);
        activityCondition.put("startMetavisionManage", isShowResourceManage);
        activityCondition.put("queryMetavisionManage", isShowResourceManage);
    }

    private boolean isDeleteTask(DelegateExecution execution) {
        return execution instanceof ExecutionEntity && ((ExecutionEntity)execution).isDeleteRoot();
    }

    public A3000StartProcessListener(RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }
}

