/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.listener.sdn;

import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.client.DeploySdnClient;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.context.SdnContext;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.SdnConverter;
import com.huawei.yinglong.virtualization.deploy.constant.OperateCmdEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SdnDeployListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(SdnDeployListener.class);
    private final DeploySdnClient deploySdnClient;
    private final SdnConverter sdnConverter;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        OperateCmd operateCmd = (OperateCmd)ObjectMapperUtils.transKey((Map)delegateExecution.getVariables(), OperateCmd.class, (String)"operateCmd", null);
        if (operateCmd == null) {
            log.error("retry param invalid .");
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        log.info("current sdn cmd type is {}", (Object)operateCmd.getOperateType());
        this.tryToUpdateParams(delegateExecution);
        if (OperateCmdEnum.RETRY.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start retry sdn vm deploy task");
            this.deploySdnClient.retrySubTask(operateCmd.getItemId());
        }
        if (OperateCmdEnum.SKIP.getOperateCmd().equalsIgnoreCase(operateCmd.getOperateType())) {
            log.info("start skip sdn vm deploy task");
            this.deploySdnClient.skipTask(operateCmd.getItemId());
        }
    }

    private void tryToUpdateParams(DelegateExecution delegateExecution) {
        Optional<VirtualizationDeployProcessConfig> deployProcessConfig = Optional.ofNullable(delegateExecution.getVariable("context")).filter(context -> context instanceof ProcessConfig).map(ProcessConfig.class::cast).map(processConfig -> (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)processConfig.getBusiness(), VirtualizationDeployProcessConfig.class, null));
        log.info("try to update sdn params, isPresent : {}.", (Object)deployProcessConfig.isPresent());
        if (deployProcessConfig.isPresent() && deployProcessConfig.get().getSdnParamVo() != null) {
            SdnContext.getInstance().setSdnParam(this.sdnConverter.toSdnParam(deployProcessConfig.get().getSdnParamVo(), "sdnVm:".concat(delegateExecution.getProcessInstanceId())));
            log.info("finish to update sdn params.");
        }
    }

    public SdnDeployListener(DeploySdnClient deploySdnClient, SdnConverter sdnConverter) {
        this.deploySdnClient = deploySdnClient;
        this.sdnConverter = sdnConverter;
    }
}

