/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyCheckItem;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyFilterType;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyManager;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyType;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class A3000DeployParamsChecker {
    private static final Logger log = LoggerFactory.getLogger(A3000DeployParamsChecker.class);
    private static final List<Long> SERVER_MASTER_SIZE = Arrays.asList(1L, 2L, 3L, 5L);

    public List<String> validUnionParams(A3000DeployProcessConfig processConfig) {
        LinkedList<String> validResults = new LinkedList<String>();
        if (!ToolEnvUtils.isA3000Expansion()) {
            this.validServerMasterNodeSize(processConfig).ifPresent(validResults::add);
        }
        validResults.addAll(this.validNpuSoftwareExisted(processConfig));
        return validResults;
    }

    private Optional<String> validServerMasterNodeSize(A3000DeployProcessConfig processConfig) {
        long masterSize = CollectionUtils.emptyIfNull(processConfig.getServerInfos()).stream().filter(server -> Objects.equals("Master", server.getNodeType())).count();
        if (!SERVER_MASTER_SIZE.contains(masterSize)) {
            return Optional.of(ResourceConfigLoader.getStringFromExportMsg("verify.params.union.master.size.failed"));
        }
        return Optional.empty();
    }

    private List<String> validNpuSoftwareExisted(A3000DeployProcessConfig processConfig) {
        if (!this.hasConfigNpuDriver(processConfig) || !CollectionUtils.emptyIfNull(processConfig.getInstallMode()).contains(InstallModeEnum.A3000_DRIVER_PLUGIN.getInstallMode())) {
            log.info("current install mode : {}.", processConfig.getInstallMode());
            return Collections.emptyList();
        }
        try {
            List checkItems = ConsistencyManager.getManager().queryCheckItems(processConfig.getSoftwarePath(), false, ConsistencyFilterType.A3000, ConsistencyType.NONE, String.join((CharSequence)",", processConfig.getInstallMode()));
            if (!this.checkHasAllNpuFiles(checkItems)) {
                return Collections.singletonList(ResourceConfigLoader.getStringFromExportMsg("verify.params.union.npu.file.not.exist"));
            }
        }
        catch (BasicException e) {
            return Collections.singletonList(ResourceConfigLoader.getStringFromExportMsgWithParams("verify.params.union.query.file.failed", e.getErrorMessage()));
        }
        return Collections.emptyList();
    }

    private boolean checkHasAllNpuFiles(List<ConsistencyCheckItem> checkItems) {
        return Stream.of(773, 774, 775).allMatch(fileType -> checkItems.stream().anyMatch(checkItem -> checkItem.getType() == fileType.intValue()));
    }

    private boolean hasConfigNpuDriver(A3000DeployProcessConfig processConfig) {
        return CollectionUtils.emptyIfNull(processConfig.getServerInfos()).stream().anyMatch(serverInfo -> "Ascend910B".equals(serverInfo.getNpuDriverType()) || "Ascend310P".equals(serverInfo.getNpuDriverType()));
    }
}

