/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.smartkit.baseserver.report.business.excel.ReportExcelData;
import com.huawei.smartkit.baseserver.report.business.excel.ReportMergeRegion;
import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import com.huawei.smartkit.baseserver.report.business.excel.ReportSheet;
import com.huawei.smartkit.baseserver.report.service.ReportData;
import com.huawei.smartkit.baseserver.report.service.ReportGenerator;
import com.huawei.smartkit.baseserver.report.service.ReportType;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessActivityQueryDto;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.constant.ReportCellStypeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.ExportReportDetailParams;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportParams;
import com.huawei.yinglong.virtualization.deploy.service.DeployReportHeaderGenerator;
import com.huawei.yinglong.virtualization.deploy.utils.ExportReportUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class A3000DeployReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(A3000DeployReportGenerator.class);
    private final BpmEngineService bpmEngineService;
    private final ReportGenerator reportGenerator;
    private final DeployReportHeaderGenerator reportHeaderGenerator;
    private Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps;
    private ProcessInstanceDto processInstanceDto;
    private A3000DeployProcessConfig processConfig;
    private List<ProcessActivity> processActivities;
    private ProcessStatus statusOs;
    private ProcessStatus statusStorage;
    private ProcessStatus statusEcontainer;
    private ProcessStatus statusDriverPlugin;
    private ProcessStatus statusResource;

    public String generateReport(ExportParams exportParams) {
        Optional<String> opReportPath = ExportReportUtils.canonicalReportPath(exportParams.getExportPath());
        if (!opReportPath.isPresent()) {
            log.error("a3000 report path get failed.");
            return ExportReportUtils.getString("report.error.path.invalid");
        }
        String initDataResult = this.initProcessActivityAllDatas(exportParams);
        if (StringUtils.isNotEmpty((CharSequence)initDataResult)) {
            log.error("a3000 init process activity all data failed, result={}, id={}.", (Object)initDataResult, (Object)exportParams.getTaskId());
            return initDataResult;
        }
        String reportFileName = ExportReportUtils.generateReportFileName("A3000", this.processInstanceDto.getName());
        if (!this.reportGenerator.generateReport(ReportData.builder().reportType(ReportType.EXCEL_XLSX).reportPath(opReportPath.get()).pageDatas(Collections.singletonList(((ReportExcelData.ReportExcelDataBuilder)((ReportExcelData.ReportExcelDataBuilder)ReportExcelData.builder().id(1)).pageName(reportFileName)).sheets(this.createReportSheet()).build())).build())) {
            return ExportReportUtils.getString("report.error.generate.failed");
        }
        ExportReportUtils.backupReportToToolBox(exportParams, reportFileName);
        return "";
    }

    private List<ReportSheet> createReportSheet() {
        LinkedList<ReportSheet> reportSheets = new LinkedList<ReportSheet>();
        this.addReportSheet(reportSheets, this.createSummarySheet());
        this.addReportSheet(reportSheets, this.createOsInstallDetailSheet());
        this.addReportSheet(reportSheets, this.createStorageConfigDetailSheet());
        this.addReportSheet(reportSheets, this.createEcontainerDeployDetailSheet());
        this.addReportSheet(reportSheets, this.createDriverPluginDetailSheet());
        this.addReportSheet(reportSheets, this.createResourceManageDetailSheet());
        return reportSheets;
    }

    private Optional<ReportSheet> createOsInstallDetailSheet() {
        if (!ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_OS)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.a3000.os.task.name", this.statusOs, Collections.singletonList("osInstall"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        this.generateOsInstallTaskDetails(reportRows, row, mergeRegions);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.a3000.os.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private void generateOsInstallTaskDetails(List<ReportRow> reportRows, AtomicInteger fcRow, List<ReportMergeRegion> mergeRegions) {
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, fcRow));
        mergeRegions.addAll(ExportReportUtils.generateTaskDetailItems(ExportReportDetailParams.builder().processActivityMap(this.processActivityMaps).reportRows(reportRows).row(fcRow).deployId("osInstall").name("report.a3000.os.task.name").stypeEnum(ReportCellStypeEnum.DME_VM).build()));
    }

    private Optional<ReportSheet> createStorageConfigDetailSheet() {
        if (!ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_STORAGE)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.a3000.storage.task.name", this.statusStorage, Collections.singletonList("storageConfig"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, row));
        List<DeployTaskDetailVo> deployDetailItems = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "storageConfig");
        if (CollectionUtils.isNotEmpty(deployDetailItems)) {
            mergeRegions.addAll(ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, row, deployDetailItems, ExportReportUtils.generateOnlyOneLevelMergeCell("report.a3000.storage.task.name", ReportCellStypeEnum.OTHER_CNA)));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.a3000.storage.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private Optional<ReportSheet> createEcontainerDeployDetailSheet() {
        if (!ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_SOFTWARE)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.a3000.econtainer.task.name", this.statusEcontainer, Collections.singletonList("eContainerDeploy"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        this.generateEcontainerTaskDetails(reportRows, row, mergeRegions);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.a3000.econtainer.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private void generateEcontainerTaskDetails(List<ReportRow> reportRows, AtomicInteger fcRow, List<ReportMergeRegion> mergeRegions) {
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, fcRow));
        mergeRegions.addAll(ExportReportUtils.generateTaskDetailItems(ExportReportDetailParams.builder().processActivityMap(this.processActivityMaps).reportRows(reportRows).row(fcRow).deployId("eContainerDeploy").name("report.a3000.econtainer.task.name").stypeEnum(ReportCellStypeEnum.DME_DATA).build()));
    }

    private Optional<ReportSheet> createDriverPluginDetailSheet() {
        if (!ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_DRIVER_PLUGIN)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.a3000.driver.plugin.task.name", this.statusDriverPlugin, Collections.singletonList("driverPluginInstall"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, row));
        List<DeployTaskDetailVo> deployDetailItems = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "driverPluginInstall");
        if (CollectionUtils.isNotEmpty(deployDetailItems)) {
            mergeRegions.addAll(ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, row, deployDetailItems, ExportReportUtils.generateOnlyOneLevelMergeCell("report.a3000.driver.plugin.task.name", ReportCellStypeEnum.CLEAN_ENV)));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.a3000.driver.plugin.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private Optional<ReportSheet> createResourceManageDetailSheet() {
        if (!ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_RESOURCE_MANAGE)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.a3000.resource.task.name", this.statusResource, Collections.singletonList("metavisionManage"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, row));
        List<DeployTaskDetailVo> deployDetailItems = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "metavisionManage");
        if (CollectionUtils.isNotEmpty(deployDetailItems)) {
            mergeRegions.addAll(ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, row, deployDetailItems, ExportReportUtils.generateOnlyOneLevelMergeCell("report.a3000.resource.task.name", ReportCellStypeEnum.DME_VM)));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.a3000.resource.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private Optional<ReportSheet> createSummarySheet() {
        AtomicInteger summaryRow = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateSummaryTaskBasicInfo(this.processInstanceDto, summaryRow);
        if (ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_OS)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryBasicInfo(summaryRow, "report.a3000.os.task.name", "osInstall"));
        }
        if (ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_STORAGE)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryBasicInfo(summaryRow, "report.a3000.storage.task.name", "storageConfig"));
        }
        if (ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_SOFTWARE)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryBasicInfo(summaryRow, "report.a3000.econtainer.task.name", "eContainerDeploy"));
        }
        if (ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_DRIVER_PLUGIN)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryBasicInfo(summaryRow, "report.a3000.driver.plugin.task.name", "driverPluginInstall"));
        }
        if (ExportReportUtils.hasDeployA3000Module(this.processConfig, InstallModeEnum.A3000_RESOURCE_MANAGE)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryBasicInfo(summaryRow, "report.a3000.resource.task.name", "metavisionManage"));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.summary")).shouldAutoSizeColumn(true).rows(reportRows).build());
    }

    private List<ReportRow> generateSummaryBasicInfo(AtomicInteger summaryRow, String resNameId, String deployId) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> summaryUltraVRBasicHeaders = this.reportHeaderGenerator.getSummaryA3000CommonHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString(resNameId), summaryUltraVRBasicHeaders.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, summaryUltraVRBasicHeaders));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, deployId, resNameId)));
        return reportRows;
    }

    private List<ReportRow> generateSummaryTaskBasicInfo(ProcessInstanceDto processInstanceDto, AtomicInteger summaryRow) {
        List<ReportRow> reportRows = ExportReportUtils.generateSummaryTaskBasicInfo(processInstanceDto, summaryRow);
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.a3000.os.status"), ExportReportUtils.formatStatus(this.statusOs)));
        if (ToolEnvUtils.isA3000Expansion()) {
            return reportRows;
        }
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.a3000.storage.status"), ExportReportUtils.formatStatus(this.statusStorage)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.a3000.econtainer.status"), ExportReportUtils.formatStatus(this.statusEcontainer)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.a3000.driver.plugin.status"), ExportReportUtils.formatStatus(this.statusDriverPlugin)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.a3000.resource.status"), ExportReportUtils.formatStatus(this.statusResource)));
        return reportRows;
    }

    private void addReportSheet(List<ReportSheet> reportSheets, Optional<ReportSheet> optionalReportSheet) {
        optionalReportSheet.ifPresent(reportSheets::add);
    }

    private void initReportSheetGenerators() {
        this.statusOs = ExportReportUtils.findDeployStatus(this.processActivities, "osInstallParent");
        this.statusStorage = ExportReportUtils.findDeployStatus(this.processActivities, "storageConfigParent");
        this.statusEcontainer = ExportReportUtils.findDeployStatus(this.processActivities, "eContainerDeploy");
        this.statusDriverPlugin = ExportReportUtils.findDeployStatus(this.processActivities, "driverPluginInstall");
        this.statusResource = ExportReportUtils.findDeployStatus(this.processActivities, "resourceManageParent");
        log.info("find deploy status, OS is {}, Storage is {}, eContainer is {}, DriverPlugin is {}, ResourceManage is {}.", new Object[]{this.statusOs, this.statusStorage, this.statusEcontainer, this.statusDriverPlugin, this.statusResource});
        this.processActivityMaps = ExportReportUtils.filterProcessActivityMaps(this.bpmEngineService, this.processActivities);
    }

    String initProcessActivityAllDatas(ExportParams exportParams) {
        this.processInstanceDto = this.bpmEngineService.queryProcessInstance(exportParams.getTaskId());
        if (!ExportReportUtils.checkProcessInstanceValid(this.processInstanceDto)) {
            log.error("check process instance invalid.");
            return ExportReportUtils.getString("report.error.task.data.invalid");
        }
        ProcessConfig instanceProcessConfig = (ProcessConfig)ObjectMapperUtils.transObject((Object)this.processInstanceDto.getProcessConfig(), ProcessConfig.class, (Object)new ProcessConfig());
        this.processConfig = (A3000DeployProcessConfig)ObjectMapperUtils.transObject((Object)instanceProcessConfig.getBusiness(), A3000DeployProcessConfig.class, (Object)new A3000DeployProcessConfig());
        if (Objects.isNull(this.processConfig) || CollectionUtils.isEmpty(this.processConfig.getInstallMode())) {
            log.error("get a3000 task params failed.");
            return ExportReportUtils.getString("report.error.task.param.invalid");
        }
        ProcessActivityQueryDto queryDto = new ProcessActivityQueryDto();
        queryDto.setInstanceId(exportParams.getTaskId());
        this.processActivities = this.bpmEngineService.queryActivityDetail(queryDto);
        if (CollectionUtils.isEmpty(this.processActivities)) {
            log.error("a3000 process activities is empty.");
            return ExportReportUtils.getString("report.error.task.step.invalid");
        }
        this.initReportSheetGenerators();
        return "";
    }

    public A3000DeployReportGenerator(BpmEngineService bpmEngineService, ReportGenerator reportGenerator, DeployReportHeaderGenerator reportHeaderGenerator) {
        this.bpmEngineService = bpmEngineService;
        this.reportGenerator = reportGenerator;
        this.reportHeaderGenerator = reportHeaderGenerator;
    }
}

