/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.CnaInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamNodeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.virtualization.deploy.constant.CheckItemConstant;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckMethod;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckState;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.step.CmdStep;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.step.IpStep;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.step.Step;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class CheckMethodProvider {
    private static final Pattern OS_PATTERN = Pattern.compile("Caption.*:(.*)");
    private static final Pattern CPU_PATTERN = Pattern.compile("MaxClockSpeed.*:(.*)[\\s\\S]*NumberOfCores.*:(.*)");
    private static final Pattern MEMORY_PATTERN = Pattern.compile("FreePhysicalMemory.*:(.*)");
    private static final Pattern VIDEO_PATTERN = Pattern.compile("VideoModeDescription.*:(.*)x(.*)x(.*)");

    public static Map<String, CheckMethod> getCommonCheckMethod() {
        return Stream.of(CheckMethodProvider.buildOsCheckMethod(), CheckMethodProvider.buildCpuCheckMethod(), CheckMethodProvider.buildMemoryCheckMethod(), CheckMethodProvider.buildDiskCheckMethod(), CheckMethodProvider.buildResolutionCheckMethod()).collect(Collectors.toMap(CheckMethod::getId, Function.identity()));
    }

    public static Map<String, CheckMethod> getRuntimeCheckMethod(VirtualizationDeployProcessConfig config) {
        return Stream.of(CheckMethodProvider.buildIpCheckMethod(config), CheckMethodProvider.buildCnaCountCheckMethod(config)).collect(Collectors.toMap(CheckMethod::getId, Function.identity()));
    }

    private static CheckMethod buildOsCheckMethod() {
        return CheckMethod.builder().id("hardware_install_os").steps(CheckMethodProvider.buildOsCheckSteps()).build();
    }

    private static List<Step> buildOsCheckSteps() {
        ArrayList<Step> stepList = new ArrayList<Step>();
        stepList.add(CmdStep.builder().cmd("powershell chcp 65001;powershell Get-WMIObject win32_operatingsystem Caption").cmdPattern(OS_PATTERN).strValid(str -> CheckItemConstant.SUPPORT_OS_VERSION.stream().anyMatch(str::contains)).build());
        stepList.add(CmdStep.builder().cmd("powershell [System.Environment]::Is64BitOperatingSystem").strValid(str -> str.contains("True")).build());
        return stepList;
    }

    private static CheckMethod buildCpuCheckMethod() {
        return CheckMethod.builder().id("hardware_install_cpu").steps(Collections.singletonList(CmdStep.builder().cmd("powershell Get-WmiObject win32_processor NumberOfCores,MaxClockSpeed").cmdPattern(CPU_PATTERN).matcherValid(CheckMethodProvider::validCpu).build())).build();
    }

    private static boolean validCpu(Matcher matcher) {
        long maxClockSpeed = NumberUtils.toInt((String)matcher.group(1).trim());
        int numberOfCores = NumberUtils.toInt((String)matcher.group(2).trim());
        return maxClockSpeed >= 2400L && numberOfCores >= 2;
    }

    private static CheckMethod buildMemoryCheckMethod() {
        return CheckMethod.builder().id("hardware_install_memory").steps(Collections.singletonList(CmdStep.builder().cmd("powershell Get-WmiObject win32_OperatingSystem FreePhysicalMemory").cmdPattern(MEMORY_PATTERN).matcherValid(matcher -> NumberUtils.toLong((String)matcher.group(1).trim()) >= 0x200000L).build())).build();
    }

    private static CheckMethod buildCnaCountCheckMethod(VirtualizationDeployProcessConfig config) {
        return CheckMethod.builder().id("specification_env_specification").steps(Collections.singletonList(CheckMethodProvider.cnaNodeCountStep(config))).build();
    }

    private static CheckMethod buildDiskCheckMethod() {
        return CheckMethod.builder().id("hardware_install_disk").steps(Collections.singletonList(CmdStep.builder().cmd("powershell Get-WmiObject -class Win32_LogicalDisk").strValid(str -> new File(System.getProperty("user.dir")).getFreeSpace() >= 0xC80000000L).build())).build();
    }

    private static CheckMethod buildResolutionCheckMethod() {
        return CheckMethod.builder().id("hardware_install_resolution").steps(Collections.singletonList(CmdStep.builder().cmd("powershell chcp 65001;powershell Get-WmiObject -class Win32_VideoController VideoModeDescription").cmdPattern(VIDEO_PATTERN).matcherValid(CheckMethodProvider::validResolution).build())).build();
    }

    private static boolean validResolution(Matcher matcher) {
        int width = NumberUtils.toInt((String)matcher.group(1).trim());
        int height = NumberUtils.toInt((String)matcher.group(2).trim());
        return width >= 1280 && height >= 1024;
    }

    private static Step cnaNodeCountStep(VirtualizationDeployProcessConfig config) {
        return () -> {
            int size = Optional.ofNullable(config.getDeployFc()).filter(CollectionUtils::isNotEmpty).map(fcs -> (FcInstallParamsVo)fcs.get(0)).map(FcInstallParamsVo::getCna).map(CnaInstallParamsVo::getNodes).map(List::size).orElse(0);
            boolean isPass = size > 0 && size <= 100;
            return new CheckResult().setId("specification_env_specification").setState(isPass ? CheckState.PASS : CheckState.NOT_PASS).setDetail(String.format(Locale.ROOT, "node size is %d", size));
        };
    }

    private static CheckMethod buildIpCheckMethod(VirtualizationDeployProcessConfig config) {
        return CheckMethod.builder().id("net_install_net").steps(Collections.singletonList(IpStep.builder().ips(CheckMethodProvider.getGatewayIps(config)).build())).build();
    }

    private static List<String> getGatewayIps(VirtualizationDeployProcessConfig config) {
        ArrayList ipList = new ArrayList();
        Optional.ofNullable(config.getDeployFc()).filter(CollectionUtils::isNotEmpty).map(fc -> (FcInstallParamsVo)fc.get(0)).map(FcInstallParamsVo::getCna).map(CnaInstallParamsVo::getNodes).filter(CollectionUtils::isNotEmpty).map(nodes -> (InsParamNodeVo)nodes.get(0)).map(InsParamNodeVo::getGateway).ifPresent(ipList::add);
        Optional.ofNullable(config.getDeployFc()).filter(CollectionUtils::isNotEmpty).map(fc -> (FcInstallParamsVo)fc.get(0)).map(FcInstallParamsVo::getVrm).map(VrmInstallParamsVo::getVrm).map(InsParamVrmVo::getGateway).ifPresent(ipList::add);
        Optional.ofNullable(config.getUltraVRParams()).map(UltraVRParams::getGateway).ifPresent(ipList::add);
        Optional.ofNullable(config.getEbackupParams()).map(EbackupParams::getEbackupVmInfo).filter(CollectionUtils::isNotEmpty).map(vms -> (EbackupVmInfo)vms.get(0)).map(EbackupVmInfo::getManagePlane).map(EbackupVmPlane::getGateway).ifPresent(ipList::add);
        Optional.ofNullable(config.getDmeData()).map(dmeParams -> (String)dmeParams.get("vm_gateway")).ifPresent(ipList::add);
        return ipList.stream().filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
    }

    private CheckMethodProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

