/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82VmParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubeBaseParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubeNetworkParams;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCubePasswordParams;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportAssembler;
import com.huawei.yinglong.virtualization.deploy.entity.export.campuscore.DeployCampusCoreEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.campuscore.DeployCampusCoreVmEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.fusioncube.FusionCube82xEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.fusioncube.FusionCube82xVmEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sdn.DeploySdnParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sdn.DeploySdnVmParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sfs.DeploySfsParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.sfs.DeploySfsVmParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportAssembler;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sdn.SdnParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsParamVo;
import com.huawei.yinglong.virtualization.deploy.service.TimezoneService;
import com.huawei.yinglong.virtualization.deploy.utils.ExportParametersParseUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersParseUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CommonReportService {
    private static final Logger log = LoggerFactory.getLogger(CommonReportService.class);
    private final ImportAssembler importAssembler;
    private final ExportAssembler exportAssembler;
    private final TimezoneService timezoneService;

    public void transferSfsData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containSfsDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeploySfsParamsEntity deploySfsParamsEntity = new DeploySfsParamsEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getSfsExportInfos(), deploySfsParamsEntity);
        this.validateSfsTemplatePath(deploySfsParamsEntity);
        List<DeploySfsVmParamsEntity> sfsVmParamsEntities = exportData.getSfsVmExportInfos().stream().map(this::buildDeploySfsVmsParamsEntity).collect(Collectors.toList());
        processConfig.setSfsParamVo(this.importAssembler.toSfsParam(deploySfsParamsEntity, sfsVmParamsEntities));
    }

    public void transferSdnData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containSdnDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeploySdnParamEntity deploySdnParamEntity = new DeploySdnParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getSdnExportInfos(), deploySdnParamEntity);
        if (StringUtils.isEmpty((CharSequence)deploySdnParamEntity.getPackagePath()) || !new File(deploySdnParamEntity.getPackagePath()).isDirectory()) {
            deploySdnParamEntity.setPackagePath("");
        }
        List<DeploySdnVmParamEntity> deploySdnVmParamEntities = exportData.getSdnVmExportInfos().stream().map(this::buildSdnVmsParams).collect(Collectors.toList());
        processConfig.setSdnParamVo(this.importAssembler.toSdnParamVo(deploySdnParamEntity, deploySdnVmParamEntities));
    }

    private DeploySdnVmParamEntity buildSdnVmsParams(Map<String, String> vmParam) {
        DeploySdnVmParamEntity deploySdnVmParamEntity = new DeploySdnVmParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(vmParam, deploySdnVmParamEntity);
        return deploySdnVmParamEntity;
    }

    public void transferCampusCoreData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig, TimezoneService timezoneService) {
        if (!InstallModeEnum.containCampusCoreDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeployCampusCoreEntity deployCampusCoreEntity = new DeployCampusCoreEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getCampusCoreExportInfos(), deployCampusCoreEntity);
        this.validateCampusCoreTemplatePath(deployCampusCoreEntity);
        Optional.of(deployCampusCoreEntity).ifPresent(campusCoreEntity -> campusCoreEntity.setTimeZoneRegion(timezoneService.parseRegionKey(campusCoreEntity.getTimeZoneRegion())));
        Optional.of(deployCampusCoreEntity).ifPresent(campusCoreEntity -> campusCoreEntity.setTimeZoneArea(timezoneService.parseAreaKey(deployCampusCoreEntity.getTimeZoneRegion(), deployCampusCoreEntity.getTimeZoneArea())));
        List<DeployCampusCoreVmEntity> campusCoreVmEntities = exportData.getCampusCoreVmExportInfos().stream().map(this::buildDeployCampusCoreVmsParamsEntity).collect(Collectors.toList());
        processConfig.setCampusCoreParamVo(this.importAssembler.toCampusCoreParam(deployCampusCoreEntity, campusCoreVmEntities));
    }

    private DeployCampusCoreVmEntity buildDeployCampusCoreVmsParamsEntity(Map<String, String> vmParam) {
        DeployCampusCoreVmEntity deployCampusCoreVmEntity = new DeployCampusCoreVmEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(vmParam, deployCampusCoreVmEntity);
        return deployCampusCoreVmEntity;
    }

    private void validateCampusCoreTemplatePath(DeployCampusCoreEntity deployCampusCoreEntity) {
        if (StringUtils.isEmpty((CharSequence)deployCampusCoreEntity.getSoftwarePath()) || !new File(deployCampusCoreEntity.getSoftwarePath()).isDirectory()) {
            deployCampusCoreEntity.setSoftwarePath("");
        }
    }

    public List<Map<String, String>> generateSfsVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasSfsParam(processConfig)) {
            return Collections.emptyList();
        }
        return processConfig.getSfsParamVo().getSfsVmVo().stream().map(this.exportAssembler::toExportSfsVmParam).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    public Map<String, String> generateSfsParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasSfsParam(processConfig)) {
            return Collections.emptyMap();
        }
        SfsParamVo sfsParamVo = processConfig.getSfsParamVo();
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(this.exportAssembler.toExportSfsParam(sfsParamVo.getSfsGeneralVo(), sfsParamVo.getSfsPlanVo(), sfsParamVo.getSfsPasswordVo()));
    }

    private boolean hasSfsParam(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containSfsDeployScene(processConfig.getInstallMode())) {
            return false;
        }
        if (Objects.isNull(processConfig.getSfsParamVo())) {
            log.error("current SFS params is null");
            return false;
        }
        return true;
    }

    private void validateSfsTemplatePath(DeploySfsParamsEntity deploySfsParamsEntity) {
        if (StringUtils.isEmpty((CharSequence)deploySfsParamsEntity.getTemplatePath()) || !new File(deploySfsParamsEntity.getTemplatePath()).isDirectory()) {
            deploySfsParamsEntity.setTemplatePath("");
        }
    }

    private DeploySfsVmParamsEntity buildDeploySfsVmsParamsEntity(Map<String, String> vmParam) {
        DeploySfsVmParamsEntity deploySfsVmParamsEntity = new DeploySfsVmParamsEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(vmParam, deploySfsVmParamsEntity);
        return deploySfsVmParamsEntity;
    }

    public Map<String, String> generateSdnParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasSdnParam(processConfig)) {
            return Collections.emptyMap();
        }
        SdnParamVo sdnParamVo = processConfig.getSdnParamVo();
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(this.exportAssembler.toExportSdnParam(sdnParamVo.getSdnGeneralVo(), sdnParamVo.getSdnPlanVo(), sdnParamVo.getAccount()));
    }

    private boolean hasSdnParam(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containSdnDeployScene(processConfig.getInstallMode())) {
            return false;
        }
        if (Objects.isNull(processConfig.getSdnParamVo())) {
            log.error("current SDN params is null");
            return false;
        }
        return true;
    }

    public List<Map<String, String>> generateSdnVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasSdnParam(processConfig)) {
            return Collections.emptyList();
        }
        return processConfig.getSdnParamVo().getSdnVmVos().stream().map(this.exportAssembler::toExportSdnVmParam).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    public Map<String, String> generateCampusParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasCampusParam(processConfig)) {
            return Collections.emptyMap();
        }
        CampusCoreParamVo campusCoreParamVo = processConfig.getCampusCoreParamVo();
        DeployCampusCoreEntity deployCampusCoreEntity = this.exportAssembler.toExportCampusCoreParam(campusCoreParamVo.getCampusCoreBaseVo(), campusCoreParamVo.getCampusCoreLevelVo(), campusCoreParamVo.getCampusCoreGlobalVo());
        String timeZoneRegion = campusCoreParamVo.getCampusCoreGlobalVo().getTimeZoneRegion();
        deployCampusCoreEntity.setTimeZoneRegion(this.timezoneService.getRegionName(timeZoneRegion));
        String timeZoneArea = campusCoreParamVo.getCampusCoreGlobalVo().getTimeZoneArea();
        deployCampusCoreEntity.setTimeZoneArea(this.timezoneService.getAreaName(timeZoneRegion, timeZoneArea));
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(deployCampusCoreEntity);
    }

    private boolean hasCampusParam(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containCampusDeployScene(processConfig.getInstallMode())) {
            return false;
        }
        if (Objects.isNull(processConfig.getCampusCoreParamVo())) {
            log.error("current eCampusCore params is null");
            return false;
        }
        return true;
    }

    public List<Map<String, String>> generateCampusVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasCampusParam(processConfig)) {
            return Collections.emptyList();
        }
        return processConfig.getCampusCoreParamVo().getCampusCoreVmVos().stream().map(this.exportAssembler::toExportCampusCoreVmParam).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    public void transferFusionCubeData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFusionCube82xDeployScene(processConfig.getInstallMode())) {
            return;
        }
        FusionCube82xEntity fusionCube82xEntity = new FusionCube82xEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getFusionCube82xInfos(), fusionCube82xEntity);
        List<FusionCube82xVmEntity> fusionCube82xVmEntities = exportData.getFusionCube82xVmInfos().stream().map(this::buildDeployFusionCube82xVmsParamsEntity).collect(Collectors.toList());
        FusionCube82Params fusionCube82Params = this.buildFusionCubeParams(fusionCube82xEntity, fusionCube82xVmEntities);
        processConfig.setFusionCube82Params(fusionCube82Params);
    }

    private FusionCube82Params buildFusionCubeParams(FusionCube82xEntity fusionCube82xEntity, List<FusionCube82xVmEntity> fusionCube82xVmEntities) {
        return FusionCube82Params.builder().fusionCubeBaseParams(FusionCubeBaseParams.builder().fcIp(fusionCube82xEntity.getFcIp()).gateway(fusionCube82xEntity.getGateway()).fcPwd(fusionCube82xEntity.getFcPwd()).fcUser(fusionCube82xEntity.getFcUser()).filePath(fusionCube82xEntity.getFilePath()).portGroup(fusionCube82xEntity.getPortGroup()).mask(fusionCube82xEntity.getMask()).build()).fusionCubePasswordParams(FusionCubePasswordParams.builder().hcp(fusionCube82xEntity.getHcp()).msuser(fusionCube82xEntity.getMsuser()).root(fusionCube82xEntity.getRoot()).build()).fusionCubeNetworkParams(FusionCubeNetworkParams.builder().managementSegment(fusionCube82xEntity.getManagementSegment()).ebackupManagementSegment(fusionCube82xEntity.getEbackupManagementSegment()).storageSegment(fusionCube82xEntity.getStorageSegment()).ebackupStorageSegment(fusionCube82xEntity.getEbackupStorageSegment()).ebackupFloatIpA(fusionCube82xEntity.getEbackupFloatIpA()).ebackupFloatIpB(fusionCube82xEntity.getEbackupFloatIpB()).build()).fusionCube82VmParamsList(this.buildVmparams(fusionCube82xVmEntities)).build();
    }

    private List<FusionCube82VmParams> buildVmparams(List<FusionCube82xVmEntity> fusionCube82xVmEntities) {
        return fusionCube82xVmEntities.stream().map(this::buildFusionCubeVmParam).collect(Collectors.toList());
    }

    private FusionCube82VmParams buildFusionCubeVmParam(FusionCube82xVmEntity fusionCube82xVmEntity) {
        return FusionCube82VmParams.builder().vmName(fusionCube82xVmEntity.getVmName()).managementIp(fusionCube82xVmEntity.getManagementIp()).productionStorageIp(fusionCube82xVmEntity.getProductionStorageIp()).backupStorageIp(fusionCube82xVmEntity.getBackupStorageIp()).productionStoragePortGroup(fusionCube82xVmEntity.getProductionStoragePortGroup()).backupStoragePortGroup(fusionCube82xVmEntity.getBackupStoragePortGroup()).productionStorageMask(fusionCube82xVmEntity.getProductionStorageMask()).backupStoragePortMask(fusionCube82xVmEntity.getBackupStoragePortMask()).cna(fusionCube82xVmEntity.getCna()).storageName(fusionCube82xVmEntity.getStorageName()).cpu(fusionCube82xVmEntity.getCpu()).memory(fusionCube82xVmEntity.getMemory()).systemDisk(fusionCube82xVmEntity.getSystemDisk()).dataDisk(fusionCube82xVmEntity.getDataDisk()).build();
    }

    private FusionCube82xVmEntity buildDeployFusionCube82xVmsParamsEntity(Map<String, String> vmParam) {
        FusionCube82xVmEntity fusionCube82xVmEntity = new FusionCube82xVmEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(vmParam, fusionCube82xVmEntity);
        return fusionCube82xVmEntity;
    }

    public Map<String, String> generateMigrationParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasMigrationParam(processConfig)) {
            return Collections.emptyMap();
        }
        FusionCube82Params migrationParams = processConfig.getFusionCube82Params();
        FusionCube82xEntity fusionCube82xEntity = this.exportAssembler.toExportMigrationParam(migrationParams.getFusionCubeBaseParams(), migrationParams.getFusionCubePasswordParams(), migrationParams.getFusionCubeNetworkParams());
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(fusionCube82xEntity);
    }

    private boolean hasMigrationParam(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFusionCube82xDeployScene(processConfig.getInstallMode())) {
            return false;
        }
        if (Objects.isNull(processConfig.getFusionCube82Params())) {
            log.error("current warm migration params is null");
            return false;
        }
        return true;
    }

    public List<Map<String, String>> generateMigrationsVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasMigrationParam(processConfig)) {
            return Collections.emptyList();
        }
        return processConfig.getFusionCube82Params().getFusionCube82VmParamsList().stream().map(this.exportAssembler::toExportMigrationVmParam).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    public CommonReportService(ImportAssembler importAssembler, ExportAssembler exportAssembler, TimezoneService timezoneService) {
        this.importAssembler = importAssembler;
        this.exportAssembler = exportAssembler;
        this.timezoneService = timezoneService;
    }
}

