/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import com.huawei.smartkit.baseserver.report.business.excel.ReportSheet;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.virtualization.deploy.constant.EbackupVmRole;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.constant.ReportCellStypeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckItem;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetBaseGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployPrecheckService;
import com.huawei.yinglong.virtualization.deploy.utils.ExportReportUtils;
import com.huawei.yinglong.virtualization.deploy.utils.PublicIpAddressUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportSheetCommonGenerator
extends ReportSheetBaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportSheetCommonGenerator.class);
    private static final String PASSWORD_PRIVACY = "********";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String TENANT_USERNAME = "bss_admin";
    private static final String VRM_THREE_USERNAME = "sysadmin";
    private static final String HICLOUD_MANAGE_PLAN_USERNAME = "op_svc_cfe";
    private static final String SFS_MANAGE_PLAN_USERNAME = "sfs_dj_admin";
    @Autowired
    private VirtualizationDeployPrecheckService preCheckService;

    public Optional<ReportSheet> createPreCheckSheet(String instanceId) {
        List<CheckItem> preCheckItems = this.preCheckService.getCheckItemsFromFile(instanceId);
        Map<String, CheckResult> preCheckResult = this.processConfig.getPreCheckResult();
        if (CollectionUtils.isEmpty(preCheckItems) || Objects.isNull(preCheckResult) || preCheckResult.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.precheck")).shouldAutoSizeColumn(true).rows(this.generatePreCheckRows(preCheckItems, preCheckResult)).build());
    }

    public Optional<ReportSheet> createPortalSheet() {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        AtomicInteger portalRow = new AtomicInteger(1);
        reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.TITLE, this.reportHeaderGenerator.getPortalHeaders()));
        this.generateFusionComputePortalValues(portalRow, reportRows);
        this.generateUltraVRPortalValues(portalRow, reportRows);
        this.generateEbackupPortalValues(portalRow, reportRows);
        this.generateDmeDataPortalValues(portalRow, reportRows);
        this.generateEDataInsightDataPortalValues(portalRow, reportRows);
        this.generateHiCloudDataPortalValues(portalRow, reportRows);
        this.generateSfsDataPortalValues(portalRow, reportRows);
        this.generateCampusDataPortalValues(portalRow, reportRows);
        if (reportRows.size() <= 1) {
            return Optional.empty();
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.portal")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private void generateCampusDataPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (!this.isProcessSucceed(this.deployCampusStatus)) {
            return;
        }
        String manageFloatIp = this.processConfig.getCampusCoreParamVo().getCampusCoreBaseVo().getManageFloatIp();
        List<String> sfsPlanValues = Arrays.asList(ExportReportUtils.getString("report.portal.campus.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.campus.ip"), manageFloatIp), DEFAULT_USERNAME, PASSWORD_PRIVACY);
        reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, sfsPlanValues));
    }

    private void generateSfsDataPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (!this.isProcessSucceed(this.deploySfsStatus)) {
            return;
        }
        String manageFloatIp = this.processConfig.getSfsParamVo().getSfsPlanVo().getFloatIp();
        List<String> sfsPlanValues = Arrays.asList(ExportReportUtils.getString("report.portal.sfs.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.manage.ip"), manageFloatIp), SFS_MANAGE_PLAN_USERNAME, PASSWORD_PRIVACY);
        reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, sfsPlanValues));
    }

    private void generateHiCloudDataPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (!this.isProcessSucceed(this.deployHiCloudStatus)) {
            return;
        }
        String managePlanIp = this.processConfig.getHiCloudParamVo().getPlan().getFloatIp();
        String dataPlanIp = this.processConfig.getHiCloudParamVo().getPlan().getKeepalivedVip2();
        this.createHiCloudManagePlanPortalRow(portalRow, reportRows, managePlanIp, "report.portal.hicloud.manage.plan", PublicIpAddressUtils.getValue("report.portal.cloud.ip"));
        this.createPortalRow(portalRow, reportRows, dataPlanIp, "report.portal.hicloud.data.plan", PublicIpAddressUtils.getValue("report.portal.hicloud.ip"));
    }

    private void createHiCloudManagePlanPortalRow(AtomicInteger portalRow, List<ReportRow> reportRows, String floatIp, String name, String url) {
        List<String> hiCloudManagePlanValues = Arrays.asList(ExportReportUtils.getString(name), MessageFormat.format(url, floatIp), HICLOUD_MANAGE_PLAN_USERNAME, PASSWORD_PRIVACY);
        reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, hiCloudManagePlanValues));
    }

    private void generateEDataInsightDataPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (!this.isProcessSucceed(this.deployEDataInsightStatus)) {
            return;
        }
        String floatIp = this.processConfig.getDayuParamsVo().getDayuBaseParams().getFloatingIp();
        this.createPortalRow(portalRow, reportRows, floatIp, "report.portal.dayu.name", PublicIpAddressUtils.getValue("report.portal.name.ip"));
        this.createPortalRow(portalRow, reportRows, floatIp, "report.portal.dayu.cloud.name", PublicIpAddressUtils.getValue("report.portal.cloud.ip"));
    }

    private void createPortalRow(AtomicInteger portalRow, List<ReportRow> reportRows, String floatIp, String name, String url) {
        List<String> dayuCloudSopValues = Arrays.asList(ExportReportUtils.getString(name), MessageFormat.format(url, floatIp), DEFAULT_USERNAME, PASSWORD_PRIVACY);
        reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, dayuCloudSopValues));
    }

    private List<ReportRow> generatePreCheckRows(List<CheckItem> preCheckItems, Map<String, CheckResult> preCheckResult) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> preCheckTitles = this.reportHeaderGenerator.getPreCheckHeaders();
        AtomicInteger preCheckRow = new AtomicInteger(1);
        String title = ExportReportUtils.getString("report.sheet.name.precheck");
        reportRows.add(ExportReportUtils.createTitleCell(preCheckRow.getAndIncrement(), title, preCheckTitles.size()));
        reportRows.add(ExportReportUtils.createListRows(preCheckRow.getAndIncrement(), ReportCellStypeEnum.HEADER, preCheckTitles));
        reportRows.addAll(preCheckItems.stream().filter(checkItem -> preCheckResult.containsKey(checkItem.getId())).map(checkItem -> this.parseCheckItems((CheckItem)checkItem, (CheckResult)preCheckResult.get(checkItem.getId()))).map(checkItems -> ExportReportUtils.createListRows(preCheckRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, checkItems)).collect(Collectors.toList()));
        return reportRows;
    }

    private List<String> parseCheckItems(CheckItem checkItem, CheckResult checkResult) {
        String checkResultText = ExportReportUtils.getString(String.format(Locale.ROOT, "report.precheck.check.%s", checkResult.getState().name().toLowerCase(Locale.ROOT)));
        return Arrays.asList(checkItem.getCategory(), checkItem.getEnvironment(), checkItem.getCheckItemName(), checkItem.getRequirement(), checkItem.getCheckMethod(), checkResultText, checkItem.getRemarks());
    }

    private void generateFusionComputePortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (this.isProcessSucceed(this.deployFcStatus) && InstallModeEnum.containFcVrmDeployScene(this.processConfig.getInstallMode())) {
            FcInstallParamsVo fcInstallParamsVo = this.processConfig.getDeployFc().get(0);
            VrmInstallParamsVo vrmInstallParamsVo = fcInstallParamsVo.getVrm();
            if (Objects.isNull(vrmInstallParamsVo)) {
                log.warn("not find vrm param.");
                return;
            }
            InsParamVrmVo vrmVo = vrmInstallParamsVo.getVrm();
            String manageIp = Objects.equals(vrmVo.getMode(), "double") ? vrmVo.getFloatIp() : vrmVo.getMasterIp();
            String userName = Objects.equals(vrmVo.getUserMode(), "three") ? VRM_THREE_USERNAME : DEFAULT_USERNAME;
            List<String> fcPortalValues = Arrays.asList(ExportReportUtils.getString("report.portal.fc.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.fc.ip"), manageIp), userName, PASSWORD_PRIVACY);
            reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, fcPortalValues));
        }
    }

    private void generateUltraVRPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (this.isProcessSucceed(this.deployUltraVRStatus)) {
            UltraVRParams ultraVRParams = this.processConfig.getUltraVRParams();
            if (Objects.isNull(ultraVRParams)) {
                log.warn("not find ultraVR param.");
                return;
            }
            List<String> fcPortalValues = Arrays.asList(ExportReportUtils.getString("report.portal.ultravr.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.ultravr.ip"), ultraVRParams.getIp()), DEFAULT_USERNAME, PASSWORD_PRIVACY);
            reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, fcPortalValues));
        }
    }

    private void generateEbackupPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (this.isProcessSucceed(this.deployEbackupStatus)) {
            EbackupParams ebackupParams = this.processConfig.getEbackupParams();
            if (Objects.isNull(ebackupParams)) {
                log.warn("not find eBackup param.");
                return;
            }
            String manageIp = ebackupParams.getEbackupVmInfo().stream().filter(vmInfo -> EbackupVmRole.of(vmInfo.getRole()) == EbackupVmRole.SERVER).map(EbackupVmInfo::getManagePlane).map(EbackupVmPlane::getManageIp).filter(StringUtils::isNotEmpty).findFirst().orElse("");
            if (StringUtils.isEmpty((CharSequence)manageIp)) {
                log.warn("not find eBackup server manage ip.");
                return;
            }
            List<String> fcPortalValues = Arrays.asList(ExportReportUtils.getString("report.portal.ebackup.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.manage.ip"), manageIp), DEFAULT_USERNAME, PASSWORD_PRIVACY);
            reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, fcPortalValues));
        }
    }

    private void generateDmeDataPortalValues(AtomicInteger portalRow, List<ReportRow> reportRows) {
        if (this.isProcessSucceed(this.deployDmeStatus)) {
            String floatIp = this.processConfig.getDmeData().getOrDefault("DMEData_float_ip", "");
            List<String> dmePortalValues = Arrays.asList(ExportReportUtils.getString("report.portal.dme.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.name.ip"), floatIp), DEFAULT_USERNAME, PASSWORD_PRIVACY);
            reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, dmePortalValues));
            List<String> dmeCloudSopValues = Arrays.asList(ExportReportUtils.getString("report.portal.cloud.name"), MessageFormat.format(PublicIpAddressUtils.getValue("report.portal.cloud.ip"), floatIp), DEFAULT_USERNAME, PASSWORD_PRIVACY);
            reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, dmeCloudSopValues));
            this.getTenantFloatIp().ifPresent(tenantIp -> {
                List<String> dmeTenantValues = Arrays.asList(ExportReportUtils.getString("report.portal.tenant.name"), MessageFormat.format(PublicIpAddressUtils.getValue("dme.tenant.float.ip"), tenantIp), TENANT_USERNAME, PASSWORD_PRIVACY);
                reportRows.add(ExportReportUtils.createListRows(portalRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, dmeTenantValues));
            });
        }
    }

    private Optional<String> getTenantFloatIp() {
        String deployTenant = this.processConfig.getDmeData().getOrDefault("DMEData_deploy_tenant", "NO");
        if (Objects.equals(deployTenant, "NO")) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.processConfig.getDmeData().get("DMEData_tenant_float_ip"));
    }
}

