/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.smartkit.baseserver.report.business.excel.ReportMergeRegion;
import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import com.huawei.smartkit.baseserver.report.business.excel.ReportSheet;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.constant.ReportCellStypeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.ExportReportDetailParams;
import com.huawei.yinglong.virtualization.deploy.entity.TaskDetailMergeItem;
import com.huawei.yinglong.virtualization.deploy.entity.TaskStateEnum;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetBaseGenerator;
import com.huawei.yinglong.virtualization.deploy.utils.ExportReportUtils;
import com.huawei.yinglong.virtualization.deploy.utils.VmParamUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportSheetDetailGenerator
extends ReportSheetBaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportSheetDetailGenerator.class);
    private Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps;
    private List<ProcessActivity> processActivities;

    void updateProcessActivity(List<ProcessActivity> processActivities, Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps) {
        this.processActivities = processActivities;
        this.processActivityMaps = processActivityMaps;
    }

    public Optional<ReportSheet> createSummarySheet(ProcessInstanceDto processInstanceDto) {
        AtomicInteger summaryRow = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateSummaryTaskBasicInfo(processInstanceDto, summaryRow);
        if (ExportReportUtils.hasDeployFusionComputeModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryFusionComputeBasicInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployUltraVRModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryUltraVRBasicInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployEbackupModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryEbackupBasicInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployDmeModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryDmeDataBasicInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployEDataInsightModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryEDataInsightInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployHiCloudModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryHiCLoudInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeploySfsModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummarySfsInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeploySdnModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummarySdnInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployCampusModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryCampusInfo(summaryRow));
        }
        if (ExportReportUtils.hasDeployMigrationModule(this.processConfig)) {
            summaryRow.addAndGet(1);
            reportRows.addAll(this.generateSummaryMigrationInfo(summaryRow));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.summary")).shouldAutoSizeColumn(true).rows(reportRows).build());
    }

    private List<ReportRow> generateSummaryEDataInsightInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> headers = this.reportHeaderGenerator.getSummaryEDataInsightHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.edatainsight.name.task"), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "dayuVmDeploy", "report.edatainsight.task.vm.deploy")));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "dayuServiceDeploy", "report.edatainsight.task.service.deploy")));
        return reportRows;
    }

    private List<ReportRow> generateSummaryHiCLoudInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> headers = this.reportHeaderGenerator.getSummaryHiCloudHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.hicloud.name"), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "hiCloudVmDeploy", "report.hicloud.task.vm.deploy")));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "hiCloudServiceDeploy", "report.hicloud.task.deploy")));
        return reportRows;
    }

    private List<ReportRow> generateSummarySfsInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> headers = this.reportHeaderGenerator.getSummarySfsHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.sfs.task.summary.name"), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "sfsDeploy", "report.sfs.task.deploy")));
        return reportRows;
    }

    private List<ReportRow> generateSummarySdnInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> headers = this.reportHeaderGenerator.getSummarySdnHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.sdn.task.summary.name"), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "sdnDeploy", "report.sdn.task.deploy")));
        return reportRows;
    }

    private List<ReportRow> generateSummaryCampusInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> headers = this.reportHeaderGenerator.getSummaryCampusHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.campus.task.summary.name"), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "campusCoreVmDeploy", "report.campus.task.vm.deploy")));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "campusCoreServiceDeploy", "report.campus.task.service.deploy")));
        return reportRows;
    }

    private List<ReportRow> generateSummaryMigrationInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> headers = this.reportHeaderGenerator.getSummaryMigrationHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.migration.task.summary.name"), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "fusionCubeMigrationDeploy", "report.migration.task.deploy")));
        return reportRows;
    }

    public Optional<ReportSheet> createFusionComputeTaskDetailSheet() {
        if (!ExportReportUtils.hasDeployFusionComputeModule(this.processConfig)) {
            return Optional.empty();
        }
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        AtomicInteger fcRow = new AtomicInteger(1);
        this.generateFusionComputeStatisticsInfo(reportRows, fcRow);
        fcRow.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        this.generateFusionComputeTaskDetails(reportRows, fcRow, mergeRegions);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.fc.detail")).rows(reportRows).shouldAutoSizeColumn(true).mergeRegions(mergeRegions).build());
    }

    public Optional<ReportSheet> createDmeDataTaskDetailSheet() {
        if (!ExportReportUtils.hasDeployDmeModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.dme.name", this.deployDmeStatus, Arrays.asList("dmeVmDeploy", "dmeDataDeploy"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        this.generateDmeTaskDetails(reportRows, row, mergeRegions);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.dme.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    public Optional<ReportSheet> createUltraVRTaskDetailSheet() {
        if (!ExportReportUtils.hasDeployUltraVRModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.ultravr.name", this.deployUltraVRStatus, Collections.singletonList("ultraVRDeploy"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, row));
        List<DeployTaskDetailVo> deployDetailItems = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "ultraVRDeploy");
        if (CollectionUtils.isNotEmpty(deployDetailItems)) {
            mergeRegions.addAll(ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, row, deployDetailItems, ExportReportUtils.generateOnlyOneLevelMergeCell("report.ultravr.name.deploy", ReportCellStypeEnum.ULTRAVR)));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.ultravr.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    public Optional<ReportSheet> createEDataInsightDetailSheet() {
        if (!ExportReportUtils.hasDeployEDataInsightModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.dayu.name", this.deployEDataInsightStatus, Arrays.asList("dayuVmDeploy", "dayuServiceDeploy"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        this.generateEDataInsightTaskDetails(reportRows, row, mergeRegions);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.dayu.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private void generateEDataInsightTaskDetails(List<ReportRow> reportRows, AtomicInteger fcRow, List<ReportMergeRegion> mergeRegions) {
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, fcRow));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, fcRow, "report.dayu.name.vm", "dayuVmDeploy", ReportCellStypeEnum.EDATAINSIGHT));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, fcRow, "report.dayu.name.service", "dayuServiceDeploy", ReportCellStypeEnum.EDATAINSIGHT));
    }

    public Optional<ReportSheet> createEbackupTaskDetailSheet() {
        if (!ExportReportUtils.hasDeployEbackupModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.ebackup.name", this.deployEbackupStatus, Collections.singletonList("eBackupDeploy"), row);
        row.addAndGet(1);
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, row));
        List<DeployTaskDetailVo> deployDetailItems = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "eBackupDeploy");
        if (CollectionUtils.isNotEmpty(deployDetailItems)) {
            mergeRegions.addAll(ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, row, deployDetailItems, ExportReportUtils.generateOnlyOneLevelMergeCell("report.ebackup.name.deploy", ReportCellStypeEnum.EBACKUP)));
        }
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.ebackup.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    public Optional<ReportSheet> createHiCloudDetailSheet() {
        if (!ExportReportUtils.hasDeployHiCloudModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.hicloud.name", this.deployHiCloudStatus, Arrays.asList("hiCloudVmDeploy", "hiCloudServiceDeploy"), row);
        row.addAndGet(1);
        List<ReportMergeRegion> mergeRegions = this.generateHiCloudTaskDetails(reportRows, row);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.hicloud.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    public Optional<ReportSheet> createCampusDetailSheet() {
        if (!ExportReportUtils.hasDeployCampusModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.campus.name", this.deployCampusStatus, Arrays.asList("campusCoreVmDeploy", "campusCoreServiceDeploy"), row);
        row.addAndGet(1);
        List<ReportMergeRegion> mergeRegions = this.generateCampusTaskDetails(reportRows, row);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.campus.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private List<ReportMergeRegion> generateCampusTaskDetails(List<ReportRow> reportRows, AtomicInteger campusRow) {
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, campusRow));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, campusRow, "report.campus.task.vm.deploy", "campusCoreVmDeploy", ReportCellStypeEnum.CAMPUS));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, campusRow, "report.campus.task.service.deploy", "campusCoreServiceDeploy", ReportCellStypeEnum.CAMPUS));
        return mergeRegions;
    }

    public Optional<ReportSheet> createMigrationDetailSheet() {
        if (!ExportReportUtils.hasDeployMigrationModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.migration.name", this.deployMigrationStatus, Collections.singletonList("fusionCubeMigrationDeploy"), row);
        row.addAndGet(1);
        List<ReportMergeRegion> mergeRegions = this.generateMigrationTaskDetails(reportRows, row);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.migration.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private List<ReportMergeRegion> generateMigrationTaskDetails(List<ReportRow> reportRows, AtomicInteger row) {
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, row));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, row, "report.migration.task.deploy", "fusionCubeMigrationDeploy", ReportCellStypeEnum.MIGRATION));
        return mergeRegions;
    }

    public Optional<ReportSheet> createSdnDetailSheet() {
        if (!ExportReportUtils.hasDeploySdnModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.sdn.name", this.deploySdnStatus, Collections.singletonList("sdnDeploy"), row);
        row.addAndGet(1);
        List<ReportMergeRegion> mergeRegions = this.generateSdnTaskDetails(reportRows, row);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.sdn.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private List<ReportMergeRegion> generateSdnTaskDetails(List<ReportRow> reportRows, AtomicInteger sdnRow) {
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, sdnRow));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, sdnRow, "report.sdn.task.deploy", "sdnDeploy", ReportCellStypeEnum.SDN));
        return mergeRegions;
    }

    public Optional<ReportSheet> createSfsDetailSheet() {
        if (!ExportReportUtils.hasDeploySfsModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = ExportReportUtils.generateTaskStatisticsInfo(this.processActivityMaps, "report.sfs.name", this.deploySfsStatus, Collections.singletonList("sfsDeploy"), row);
        row.addAndGet(1);
        List<ReportMergeRegion> mergeRegions = this.generateSfsTaskDetails(reportRows, row);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.sfs.detail")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private List<ReportMergeRegion> generateSfsTaskDetails(List<ReportRow> reportRows, AtomicInteger sfsRow) {
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, sfsRow));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, sfsRow, "report.sfs.task.deploy", "sfsDeploy", ReportCellStypeEnum.SFS));
        return mergeRegions;
    }

    private List<ReportMergeRegion> generateHiCloudTaskDetails(List<ReportRow> reportRows, AtomicInteger hiCloudRow) {
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, hiCloudRow));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, hiCloudRow, "report.hicloud.task.vm.deploy", "hiCloudVmDeploy", ReportCellStypeEnum.HI_CLOUD));
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, hiCloudRow, "report.hicloud.task.service.deploy", "hiCloudServiceDeploy", ReportCellStypeEnum.HI_CLOUD));
        return mergeRegions;
    }

    private void generateFusionComputeTaskDetails(List<ReportRow> reportRows, AtomicInteger fcRow, List<ReportMergeRegion> mergeRegions) {
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, fcRow));
        mergeRegions.addAll(this.generateFcFirstNodeDetailItems(reportRows, fcRow));
        mergeRegions.addAll(this.generateFcCnaDetailItems(reportRows, fcRow));
        mergeRegions.addAll(this.generateFcVrmDetailItems(reportRows, fcRow));
        mergeRegions.addAll(this.generateFcCleanEnvDetailItems(reportRows, fcRow));
    }

    private List<ReportMergeRegion> generateFcFirstNodeDetailItems(List<ReportRow> reportRows, AtomicInteger fcRow) {
        List<DeployTaskDetailVo> firstNodeDetails = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "firstNodeDeploy");
        if (firstNodeDetails.isEmpty()) {
            return Collections.emptyList();
        }
        return ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, fcRow, firstNodeDetails, ExportReportUtils.generateOnlyOneLevelMergeCell("report.detail.install.first.node", ReportCellStypeEnum.FIRST_CNA));
    }

    private List<ReportMergeRegion> generateFcCnaDetailItems(List<ReportRow> reportRows, AtomicInteger fcRow) {
        int firstRow = fcRow.get();
        LinkedList<DeployTaskDetailVo> allDetailItems = new LinkedList<DeployTaskDetailVo>();
        List<TaskDetailMergeItem> mergeRowItems = ExportReportUtils.parseChildTaskDetailItems(this.processActivityMaps, allDetailItems, "cnaDeploy", firstRow, ReportCellStypeEnum.OTHER_CNA);
        mergeRowItems.add(new TaskDetailMergeItem().setStartRow(firstRow).setMergeCol(1).setRowCount(allDetailItems.size()).setValue(ExportReportUtils.getString("report.detail.install.cna")).setCellStyle(ReportCellStypeEnum.OTHER_CNA));
        return ExportReportUtils.createTaskDetailItemRow(reportRows, fcRow, allDetailItems, mergeRowItems);
    }

    private List<ReportMergeRegion> generateFcVrmDetailItems(List<ReportRow> reportRows, AtomicInteger fcRow) {
        int firstRow = fcRow.get();
        LinkedList<DeployTaskDetailVo> allDetailItems = new LinkedList<DeployTaskDetailVo>();
        List<TaskDetailMergeItem> mergeRowItems = ExportReportUtils.parseChildTaskDetailItems(this.processActivityMaps, allDetailItems, "vrmDeploy", firstRow, ReportCellStypeEnum.VRM_DEPLOY);
        mergeRowItems.add(new TaskDetailMergeItem().setStartRow(firstRow).setMergeCol(1).setRowCount(allDetailItems.size()).setValue(ExportReportUtils.getString("report.detail.install.vrm")).setCellStyle(ReportCellStypeEnum.VRM_DEPLOY));
        return ExportReportUtils.createTaskDetailItemRow(reportRows, fcRow, allDetailItems, mergeRowItems);
    }

    private List<ReportMergeRegion> generateFcCleanEnvDetailItems(List<ReportRow> reportRows, AtomicInteger fcRow) {
        List<DeployTaskDetailVo> cleanEnvDetails = ExportReportUtils.getDeployDetailItems(this.processActivityMaps, "fcEnvClean");
        if (cleanEnvDetails.isEmpty()) {
            return Collections.emptyList();
        }
        return ExportReportUtils.generateOnlyOneLevelDetailItems(reportRows, fcRow, cleanEnvDetails, ExportReportUtils.generateOnlyOneLevelMergeCell("report.detail.install.clean.env", ReportCellStypeEnum.CLEAN_ENV));
    }

    private void generateFusionComputeStatisticsInfo(List<ReportRow> reportRows, AtomicInteger fcRow) {
        List<String> summaryFcBasicInfoHeaders = this.reportHeaderGenerator.getSummaryFcBasicInfoHeaders();
        List<String> summaryFcBasicInfoValues = this.getSummaryFcBasicInfoValues();
        reportRows.add(ExportReportUtils.createTitleCell(fcRow.getAndIncrement(), summaryFcBasicInfoValues.get(0), 9));
        reportRows.addAll(IntStream.range(1, summaryFcBasicInfoHeaders.size()).filter(idx -> idx < summaryFcBasicInfoHeaders.size() && idx < summaryFcBasicInfoValues.size()).mapToObj(idx -> ExportReportUtils.createHorizontalKeyValue(fcRow.getAndIncrement(), (String)summaryFcBasicInfoHeaders.get(idx), (String)summaryFcBasicInfoValues.get(idx))).collect(Collectors.toList()));
    }

    private List<String> getSummaryFcBasicInfoValues() {
        List<DeployTaskDetailVo> cnaDetailItems = this.getFusionComputeCnaDetailItems();
        AtomicLong succeedCount = this.calculateStatusCount(cnaDetailItems, TaskStateEnum.END);
        AtomicLong failedCount = this.calculateStatusCount(cnaDetailItems, TaskStateEnum.ERROR);
        AtomicLong notStartCount = this.calculateStatusCount(cnaDetailItems, TaskStateEnum.NOT_START);
        AtomicLong skipCount = this.calculateStatusCount(cnaDetailItems, TaskStateEnum.SKIP);
        long totalCount = this.getFusionComputeCnaCount();
        ProcessStatus firstNodeStatus = this.findSubDeployStatus("firstNodeDeploy");
        ProcessStatus vrmStatus = this.findSubDeployStatus("vrmDeploy");
        this.handleFusionComputeCnaNodeSizes(succeedCount, failedCount, notStartCount, firstNodeStatus);
        List<Long> startEndTimes = this.getFusionComputeStartEndTimes();
        return Arrays.asList(this.getFusionComputeName(), ExportReportUtils.formatTime(startEndTimes.get(0)), ExportReportUtils.formatTime(startEndTimes.get(1)), ExportReportUtils.durationTime(startEndTimes.get(1) - startEndTimes.get(0)), ExportReportUtils.formatStatus(firstNodeStatus), ExportReportUtils.formatStatus(vrmStatus), String.valueOf(totalCount), succeedCount.toString(), failedCount.toString(), skipCount.toString(), notStartCount.toString());
    }

    private void handleFusionComputeCnaNodeSizes(AtomicLong succeedCount, AtomicLong failedCount, AtomicLong notStartCount, ProcessStatus firstNodeStatus) {
        if (!InstallModeEnum.containFcCnaDeployScene(this.processConfig.getInstallMode())) {
            return;
        }
        if (this.isProcessSucceed(firstNodeStatus)) {
            succeedCount.getAndIncrement();
        } else if (firstNodeStatus == ProcessStatus.FAILED) {
            failedCount.getAndIncrement();
        } else {
            notStartCount.getAndIncrement();
        }
    }

    private long getFusionComputeCnaCount() {
        return this.processConfig.getDeployFc().stream().filter(Objects::nonNull).map(FcInstallParamsVo::getCna).filter(Objects::nonNull).filter(cnaInstallParamsVo -> CollectionUtils.isNotEmpty((Collection)cnaInstallParamsVo.getNodes())).mapToLong(cnaInstallParamsVo -> cnaInstallParamsVo.getNodes().size()).sum();
    }

    private ProcessStatus findSubDeployStatus(String deployId) {
        return this.processActivities.stream().filter(processActivity -> Objects.nonNull(processActivity.getChildren())).flatMap(processActivity -> processActivity.getChildren().stream()).filter(processActivity -> Objects.nonNull(processActivity.getChildren())).flatMap(processActivity -> processActivity.getChildren().stream()).filter(processActivity -> Objects.equals(processActivity.getId(), deployId)).map(ProcessActivity::getStatus).findFirst().orElse(ProcessStatus.NO_START);
    }

    private String getFusionComputeName() {
        if (CollectionUtils.isEmpty(this.processConfig.getDeployFc())) {
            return ExportReportUtils.getString("report.fc.name");
        }
        FcInstallParamsVo fcInstallParamsVo = this.processConfig.getDeployFc().get(0);
        if (Objects.isNull(fcInstallParamsVo) || Objects.isNull(fcInstallParamsVo.getTask())) {
            return ExportReportUtils.getString("report.fc.name");
        }
        return fcInstallParamsVo.getTask().getTaskName();
    }

    private List<DeployTaskDetailVo> getFusionComputeCnaDetailItems() {
        return this.processActivityMaps.entrySet().stream().filter(entry -> Objects.equals(((ProcessActivity)entry.getKey()).getId(), "cnaDeploy")).flatMap(entry -> ((List)entry.getValue()).stream()).filter(deployTaskDetailVo -> !CollectionUtils.isEmpty((Collection)deployTaskDetailVo.getChildren())).flatMap(deployTaskDetailVo -> deployTaskDetailVo.getChildren().stream()).collect(Collectors.toList());
    }

    private List<Long> getFusionComputeStartEndTimes() {
        List<String> fcDeployIds = Arrays.asList("firstNodeDeploy", "vrmDeploy", "cnaDeploy", "fcEnvClean");
        List<DeployTaskDetailVo> detailItems = this.processActivityMaps.entrySet().stream().filter(entry -> fcDeployIds.contains(((ProcessActivity)entry.getKey()).getId())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        return ExportReportUtils.parseStartEndTime(detailItems);
    }

    private AtomicLong calculateStatusCount(List<DeployTaskDetailVo> cnaDetailItems, TaskStateEnum taskState) {
        long count = cnaDetailItems.stream().filter(deployTaskDetailVo -> taskState.isSameState(deployTaskDetailVo.getState())).count();
        return new AtomicLong(count);
    }

    private void generateDmeTaskDetails(List<ReportRow> reportRows, AtomicInteger fcRow, List<ReportMergeRegion> mergeRegions) {
        mergeRegions.addAll(ExportReportUtils.generateDetailItemHeaders(this.reportHeaderGenerator.getTaskDetailItemHeaders(), reportRows, fcRow));
        if (VmParamUtils.isAutoCreateVm(this.processConfig.getDmeData())) {
            mergeRegions.addAll(this.generateTaskDetailItems(reportRows, fcRow, "report.dme.name.vm", "dmeVmDeploy", ReportCellStypeEnum.DME_VM));
        }
        mergeRegions.addAll(this.generateTaskDetailItems(reportRows, fcRow, "report.dme.name.data", "dmeDataDeploy", ReportCellStypeEnum.DME_DATA));
    }

    List<ReportMergeRegion> generateTaskDetailItems(List<ReportRow> reportRows, AtomicInteger row, String name, String deployId, ReportCellStypeEnum stypeEnum) {
        return ExportReportUtils.generateTaskDetailItems(ExportReportDetailParams.builder().processActivityMap(this.processActivityMaps).reportRows(reportRows).row(row).deployId(deployId).name(name).stypeEnum(stypeEnum).build());
    }

    private List<ReportRow> generateSummaryTaskBasicInfo(ProcessInstanceDto processInstanceDto, AtomicInteger summaryRow) {
        List<ReportRow> reportRows = ExportReportUtils.generateSummaryTaskBasicInfo(processInstanceDto, summaryRow);
        if (ExportReportUtils.hasDeployMigrationModule(this.processConfig)) {
            reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.migration.status"), ExportReportUtils.formatStatus(this.deployMigrationStatus)));
            return reportRows;
        }
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.fc.status"), ExportReportUtils.formatStatus(this.deployFcStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.ultravr.status"), ExportReportUtils.formatStatus(this.deployUltraVRStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.ebackup.status"), ExportReportUtils.formatStatus(this.deployEbackupStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.dme.status"), ExportReportUtils.formatStatus(this.deployDmeStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.dayu.status"), ExportReportUtils.formatStatus(this.deployEDataInsightStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.hicloud.status"), ExportReportUtils.formatStatus(this.deployHiCloudStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.sfs.status"), ExportReportUtils.formatStatus(this.deploySfsStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.sdn.status"), ExportReportUtils.formatStatus(this.deploySdnStatus)));
        reportRows.add(ExportReportUtils.createHorizontalKeyValue(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.task.campus.status"), ExportReportUtils.formatStatus(this.deployCampusStatus)));
        return reportRows;
    }

    private List<ReportRow> generateSummaryFusionComputeBasicInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> summaryFcBasicInfoHeaders = this.reportHeaderGenerator.getSummaryFcBasicInfoHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.fc.name"), summaryFcBasicInfoHeaders.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, summaryFcBasicInfoHeaders));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, this.getSummaryFcBasicInfoValues()));
        return reportRows;
    }

    private List<ReportRow> generateSummaryDmeDataBasicInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> summaryDmeBasicHeaders = this.reportHeaderGenerator.getSummaryDmeBasicHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.dme.name"), summaryDmeBasicHeaders.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, summaryDmeBasicHeaders));
        if (VmParamUtils.isAutoCreateVm(this.processConfig.getDmeData())) {
            reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "dmeVmDeploy", "report.dme.name.vm")));
        }
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "dmeDataDeploy", "report.dme.name.data")));
        return reportRows;
    }

    private List<ReportRow> generateSummaryUltraVRBasicInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> summaryUltraVRBasicHeaders = this.reportHeaderGenerator.getSummaryUltraVRBasicHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.ultravr.name"), summaryUltraVRBasicHeaders.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, summaryUltraVRBasicHeaders));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "ultraVRDeploy", "report.ultravr.name.deploy")));
        return reportRows;
    }

    private List<ReportRow> generateSummaryEbackupBasicInfo(AtomicInteger summaryRow) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        List<String> summaryUltraVRBasicHeaders = this.reportHeaderGenerator.getSummaryEbackupBasicHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(summaryRow.getAndIncrement(), ExportReportUtils.getString("report.ebackup.name"), summaryUltraVRBasicHeaders.size()));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.HEADER, summaryUltraVRBasicHeaders));
        reportRows.add(ExportReportUtils.createListRows(summaryRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, ExportReportUtils.getSummaryBasicInfoValues(this.processActivityMaps, "eBackupDeploy", "report.ebackup.name.deploy")));
        return reportRows;
    }

    public void setProcessActivityMaps(Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps) {
        this.processActivityMaps = processActivityMaps;
    }

    public void setProcessActivities(List<ProcessActivity> processActivities) {
        this.processActivities = processActivities;
    }
}

