/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.smartkit.baseserver.report.business.excel.ReportMergeRegion;
import com.huawei.smartkit.baseserver.report.business.excel.ReportRow;
import com.huawei.smartkit.baseserver.report.business.excel.ReportSheet;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.ReportCellStypeEnum;
import com.huawei.yinglong.virtualization.deploy.service.CommonReportService;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetBaseGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployParametersGenerator;
import com.huawei.yinglong.virtualization.deploy.utils.ExportReportUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportSheetParamsGenerator
extends ReportSheetBaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportSheetParamsGenerator.class);
    private final VirtualizationDeployParametersGenerator parametersGenerator;
    private final CommonReportService commonReportService;

    public Optional<ReportSheet> createFusionComputeParams() {
        if (!ExportReportUtils.hasDeployFusionComputeModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger fcRow = new AtomicInteger(1);
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        LinkedList<ReportMergeRegion> mergeRegions = new LinkedList<ReportMergeRegion>();
        this.generateFcParamBasicInfo(fcRow, reportRows);
        fcRow.addAndGet(1);
        this.generateFcParamVrmInfo(fcRow, reportRows);
        fcRow.addAndGet(1);
        this.generateFcParamCnaCommonInfo(fcRow, reportRows, mergeRegions);
        fcRow.addAndGet(1);
        this.generateFcParamNtpTimeInfo(fcRow, reportRows);
        fcRow.addAndGet(1);
        this.generateFcParamBackupInfo(fcRow, reportRows);
        fcRow.addAndGet(1);
        this.generateFcParamCnaList(fcRow, reportRows);
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.fc.param")).rows(reportRows).shouldAutoSizeColumn(true).mergeRegions(mergeRegions).build());
    }

    public Optional<ReportSheet> createDmeDataParams() {
        if (!ExportReportUtils.hasDeployDmeModule(this.processConfig)) {
            return Optional.empty();
        }
        Map<String, String> dmeDatas = this.parametersGenerator.generateDmeParams(this.processConfig);
        AtomicInteger dmeRow = new AtomicInteger(1);
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.virtualization.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), dmeRow, dmeDatas);
        dmeRow.addAndGet(1);
        reportRows.addAll(this.generateDmeParamsInfo("report.dme.name", dmeRow, this.reportHeaderGenerator.getDmeDataHeaders(), dmeDatas));
        dmeRow.addAndGet(1);
        reportRows.addAll(this.generateDmeParamsInfo("report.dme.tenant.name", dmeRow, this.reportHeaderGenerator.getDmeTenantHeaders(), dmeDatas));
        dmeRow.addAndGet(1);
        reportRows.addAll(this.generateDmeParamsInfo("report.dme.fusioncompute.name", dmeRow, this.reportHeaderGenerator.getDmeManageFcHeaders(), dmeDatas));
        dmeRow.addAndGet(1);
        reportRows.addAll(this.generateDmeParamsInfo("report.dme.name.container.cluster.service", dmeRow, this.reportHeaderGenerator.getEDmeContainerClusterServiceHeader(), dmeDatas));
        dmeRow.addAndGet(1);
        reportRows.addAll(this.generateDmeParamsInfo("report.dme.name.dcsas.service", dmeRow, this.reportHeaderGenerator.getDcsasHeaders(), dmeDatas));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.dme.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> generateDmeParamsInfo(String nameKey, AtomicInteger dmeRow, List<String> dmeTitles, Map<String, String> dmeDatas) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        reportRows.add(ExportReportUtils.createTitleCell(dmeRow.getAndIncrement(), ExportReportUtils.getString(nameKey), dmeTitles.size()));
        reportRows.add(ExportReportUtils.createListRows(dmeRow.getAndIncrement(), ReportCellStypeEnum.HEADER, dmeTitles));
        reportRows.addAll(Optional.of(dmeDatas).map(dmeParam -> this.parseParamValues((Map<String, String>)dmeParam, dmeTitles)).map(dmeValues -> ExportReportUtils.createListRows(dmeRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, dmeValues)).map(Collections::singletonList).orElse(Collections.emptyList()));
        return reportRows;
    }

    public Optional<ReportSheet> createUltraVRParams() {
        if (!ExportReportUtils.hasDeployUltraVRModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<Map<String, String>> paramMaps = Collections.singletonList(this.parametersGenerator.generateUltraVRParams(this.processConfig));
        List<ReportRow> reportRows = this.generateUltraVReBackupBasicInfo(row, paramMaps);
        List<String> ultraVRVmHeaders = this.reportHeaderGenerator.getUltraVRVmHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.ultravr.vm.info", ultraVRVmHeaders, row, paramMaps));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.ultravr.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    public Optional<ReportSheet> createDayuDataParams() {
        if (!ExportReportUtils.hasDeployEDataInsightModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        Map<String, String> eDataInsightParams = this.parametersGenerator.generateDayuParams(this.processConfig);
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.virtualization.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), row, eDataInsightParams);
        row.getAndIncrement();
        reportRows.addAll(this.createEDataInsightListParams(row, "deploy.params.template.dayu.service.info.title", eDataInsightParams, this.reportHeaderGenerator.getEDataInsightServerParamsHeaders()));
        row.getAndIncrement();
        reportRows.addAll(this.createEDataInsightListParams(row, "deploy.params.template.dayu.common.info.title", eDataInsightParams, this.reportHeaderGenerator.getEDataInsightBaseParams()));
        row.getAndIncrement();
        reportRows.addAll(this.createEDataInsightListParams(row, "deploy.params.template.dayu.password.title", eDataInsightParams, this.reportHeaderGenerator.getEDataInsightPwdParams()));
        row.getAndIncrement();
        reportRows.addAll(this.createEDataInsightListParams(row, "deploy.params.template.pacific.title", eDataInsightParams, this.reportHeaderGenerator.getEDataInsightPacificParams()));
        row.getAndIncrement();
        List<Map<String, String>> eDataInsightPlaneParams = this.parametersGenerator.generateDayuVmPlaneParams(this.processConfig);
        reportRows.addAll(this.createEDataInsightPlaneParams(row, eDataInsightPlaneParams, this.reportHeaderGenerator.getEDataInsightPlaneHeader()));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.dayu.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> createEDataInsightPlaneParams(AtomicInteger row, List<Map<String, String>> eDataInsightPlaneParams, List<String> header) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        reportRows.add(ExportReportUtils.createTitleCell(row.getAndIncrement(), ExportReportUtils.getString("deploy.params.template.dayu.plane.sheet"), header.size()));
        reportRows.add(ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.DEFAULT, header));
        eDataInsightPlaneParams.forEach(eDataInsightPlaneParam -> reportRows.add(ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.DEFAULT, header.stream().map(eDataInsightPlaneParam::get).collect(Collectors.toList()))));
        return reportRows;
    }

    private List<ReportRow> createEDataInsightListParams(AtomicInteger row, String title, Map<String, String> eDataInsightParams, List<String> header) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        reportRows.add(ExportReportUtils.createTitleCell(row.getAndIncrement(), ResourceConfigLoader.getStringFromExportMsg(title), header.size()));
        reportRows.add(ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.DEFAULT, header));
        reportRows.add(ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.DEFAULT, header.stream().map(eDataInsightParams::get).collect(Collectors.toList())));
        return reportRows;
    }

    public Optional<ReportSheet> createHiCloudDataParams() {
        if (!ExportReportUtils.hasDeployHiCloudModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateHiCloudBasicInfo(row, this.parametersGenerator.generateHiCloudParams(this.processConfig));
        reportRows.addAll(this.createBasicTableInfo("report.hicloud.vm.info", this.reportHeaderGenerator.getHiCloudVmHeaders(), row, this.parametersGenerator.generateHiCloudVmParams(this.processConfig)));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.hicloud.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    public Optional<ReportSheet> createSfsDataParams() {
        if (!ExportReportUtils.hasDeploySfsModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateSfsBasicInfo(row, this.parametersGenerator.generateSfsParams(this.processConfig));
        reportRows.addAll(this.createBasicTableInfo("report.sfs.vm.info", this.reportHeaderGenerator.getSfsVmHeaders(), row, this.parametersGenerator.generateSfsVmParams(this.processConfig)));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.sfs.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> generateSfsBasicInfo(AtomicInteger row, Map<String, String> sfsParams) {
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.fusioncompute.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), row, sfsParams);
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.sfs.param.general", this.reportHeaderGenerator.getSfsGeneralHeaders(), row, sfsParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.sfs.param.manage", this.reportHeaderGenerator.getSfsManageHeaders(), row, sfsParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.sfs.param.password", this.reportHeaderGenerator.getSfsPasswordHeaders(), row, sfsParams));
        row.addAndGet(1);
        return reportRows;
    }

    public Optional<ReportSheet> createSdnDataParams() {
        if (!ExportReportUtils.hasDeploySdnModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateSdnBasicInfo(row, this.commonReportService.generateSdnParams(this.processConfig));
        reportRows.addAll(this.createBasicTableInfo("report.sdn.vm.info", this.reportHeaderGenerator.getSdnVmHeaders(), row, this.commonReportService.generateSdnVmParams(this.processConfig)));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.sdn.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> generateSdnBasicInfo(AtomicInteger row, Map<String, String> sdnParams) {
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.fusioncompute.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), row, sdnParams);
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.sdn.param.general", this.reportHeaderGenerator.getSdnGeneralHeaders(), row, sdnParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.sdn.param.account", this.reportHeaderGenerator.getSdnAccountHeaders(), row, sdnParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.sdn.param.plan", this.reportHeaderGenerator.getSdnPlanHeaders(), row, sdnParams));
        row.addAndGet(1);
        return reportRows;
    }

    public Optional<ReportSheet> createCampusDataParams() {
        if (!ExportReportUtils.hasDeployCampusModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateCampusBasicInfo(row, this.commonReportService.generateCampusParams(this.processConfig));
        reportRows.addAll(this.createBasicTableInfo("report.campus.vm.info", this.reportHeaderGenerator.getCampusVmHeaders(), row, this.commonReportService.generateCampusVmParams(this.processConfig)));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.campus.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> generateCampusBasicInfo(AtomicInteger row, Map<String, String> campusParams) {
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.fusioncompute.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), row, campusParams);
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.campus.param.base", this.reportHeaderGenerator.getCampusBaseHeaders(), row, campusParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.campus.param.level", this.reportHeaderGenerator.getCampusLevelHeaders(), row, campusParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.campus.param.global", this.reportHeaderGenerator.getCampusGlobalHeaders(), row, campusParams));
        row.addAndGet(1);
        return reportRows;
    }

    public Optional<ReportSheet> createMigrationDataParams() {
        if (!ExportReportUtils.hasDeployMigrationModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateMigrationBasicInfo(row, this.commonReportService.generateMigrationParams(this.processConfig));
        reportRows.addAll(this.createBasicTableInfo("report.migration.vm.info", this.reportHeaderGenerator.getMigrationVmHeaders(), row, this.commonReportService.generateMigrationsVmParams(this.processConfig)));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.migration.param")).rows(reportRows).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> generateMigrationBasicInfo(AtomicInteger row, Map<String, String> migrationParams) {
        List<ReportRow> reportRows = this.createBasicTableInfo("report.migration.param.base", this.reportHeaderGenerator.getMigrationBaseHeaders(), row, migrationParams);
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.migration.param.pwd", this.reportHeaderGenerator.getMigrationPwdHeaders(), row, migrationParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.migration.param.network", this.reportHeaderGenerator.getMigrationNetworkHeaders(), row, migrationParams));
        row.addAndGet(1);
        return reportRows;
    }

    private List<ReportRow> generateHiCloudBasicInfo(AtomicInteger row, Map<String, String> hiCloudParams) {
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.fusioncompute.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), row, hiCloudParams);
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.hicloud.param.general", this.reportHeaderGenerator.getHiCloudGeneralHeaders(), row, hiCloudParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.hicloud.gde.manage", this.reportHeaderGenerator.getHiCloudGdeManageHeaders(), row, hiCloudParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.hicloud.gde.data", this.reportHeaderGenerator.getHiCloudGdeDataHeaders(), row, hiCloudParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.hicloud.gde.plan", this.reportHeaderGenerator.getHiCloudGdePlanHeaders(), row, hiCloudParams));
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.hicloud.service", this.reportHeaderGenerator.getHiCloudServiceHeaders(), row, hiCloudParams));
        row.addAndGet(1);
        return reportRows;
    }

    public Optional<ReportSheet> createEbackupParams() {
        if (!ExportReportUtils.hasDeployEbackupModule(this.processConfig)) {
            return Optional.empty();
        }
        AtomicInteger row = new AtomicInteger(1);
        List<ReportRow> reportRows = this.generateUltraVReBackupBasicInfo(row, Collections.singletonList(this.parametersGenerator.generateEbackupBasicParams(this.processConfig)));
        List<String> ebackupVmHeaders = this.reportHeaderGenerator.getEbackupVmHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.ebackup.vm.info", ebackupVmHeaders, row, this.parametersGenerator.generateEbackupVmParams(this.processConfig)));
        row.addAndGet(1);
        List<String> vmPlaneHeaders = this.reportHeaderGenerator.getEbackupVmPlaneHeaders();
        reportRows.addAll(this.createTableHeaderInfos("report.ebackup.vm.plane.info", vmPlaneHeaders, row));
        LinkedList mergeRegions = new LinkedList();
        reportRows.addAll(this.parametersGenerator.generateEbackupVmPlaneParams(this.processConfig).entrySet().stream().flatMap(vmPlane -> this.generateEbackupVmPlaneInfo((String)vmPlane.getKey(), (List)vmPlane.getValue(), row, mergeRegions).stream()).collect(Collectors.toList()));
        return Optional.of(ReportSheet.builder().name(ExportReportUtils.getString("report.sheet.name.ebackup.param")).rows(reportRows).mergeRegions(mergeRegions).shouldAutoSizeColumn(true).build());
    }

    private List<ReportRow> generateEbackupVmPlaneInfo(String vmName, List<Map<String, String>> paramMaps, AtomicInteger row, List<ReportMergeRegion> mergeRegions) {
        mergeRegions.add(ReportMergeRegion.builder().firstRow(row.get()).firstCol(1).lastRow(row.get() + paramMaps.size() - 1).lastCol(1).build());
        List<String> headers = this.reportHeaderGenerator.getEbackupVmPlaneHeaders();
        return paramMaps.stream().peek(baseParam -> baseParam.put(headers.get(0), vmName)).map(baseParam -> this.parseParamValues((Map<String, String>)baseParam, headers)).map(baseValues -> ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.DEFAULT, baseValues)).collect(Collectors.toList());
    }

    private List<ReportRow> generateUltraVReBackupBasicInfo(AtomicInteger row, List<Map<String, String>> paramMaps) {
        List<ReportRow> reportRows = this.createBasicTableInfo("report.common.template.info", this.reportHeaderGenerator.getTemplateInfoHeaders(), row, paramMaps);
        row.addAndGet(1);
        reportRows.addAll(this.createBasicTableInfo("report.common.fusioncompute.info", this.reportHeaderGenerator.getFusionComputeInfoHeaders(), row, paramMaps));
        row.addAndGet(1);
        return reportRows;
    }

    private List<ReportRow> createBasicTableInfo(String title, List<String> headers, AtomicInteger row, Map<String, String> paramMaps) {
        return this.createBasicTableInfo(title, headers, row, Collections.singletonList(paramMaps));
    }

    private List<ReportRow> createBasicTableInfo(String title, List<String> headers, AtomicInteger row, List<Map<String, String>> paramMaps) {
        List<ReportRow> reportRows = this.createTableHeaderInfos(title, headers, row);
        reportRows.addAll(paramMaps.stream().map(baseParam -> this.parseParamValues((Map<String, String>)baseParam, headers)).map(baseValues -> ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.DEFAULT, baseValues)).collect(Collectors.toList()));
        return reportRows;
    }

    private List<ReportRow> createTableHeaderInfos(String title, List<String> headers, AtomicInteger row) {
        LinkedList<ReportRow> reportRows = new LinkedList<ReportRow>();
        reportRows.add(ExportReportUtils.createTitleCell(row.getAndIncrement(), ExportReportUtils.getString(title), headers.size()));
        reportRows.add(ExportReportUtils.createListRows(row.getAndIncrement(), ReportCellStypeEnum.HEADER, headers));
        return reportRows;
    }

    private void generateFcParamBasicInfo(AtomicInteger fcRow, List<ReportRow> reportRows) {
        List<String> fcParamBasicHeaders = this.reportHeaderGenerator.getFcBasicInfoHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.fc.basic.info", fcParamBasicHeaders, fcRow, Collections.singletonList(this.parametersGenerator.generateFcBaseParams(this.processConfig))));
    }

    private void generateFcParamNtpTimeInfo(AtomicInteger fcRow, List<ReportRow> reportRows) {
        List<String> fcParamNtpTimeHeaders = this.reportHeaderGenerator.getFcNtpTimeInfoHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.fc.ntp.time.info", fcParamNtpTimeHeaders, fcRow, Collections.singletonList(this.parametersGenerator.generateFcVrmNtpTimeParams(this.processConfig))));
    }

    private void generateFcParamBackupInfo(AtomicInteger fcRow, List<ReportRow> reportRows) {
        List<String> fcParamBasicHeaders = this.reportHeaderGenerator.getFcBackupInfoHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.fc.backup.info", fcParamBasicHeaders, fcRow, Collections.singletonList(this.parametersGenerator.generateFcVrmBackupParams(this.processConfig))));
    }

    private void generateFcParamVrmInfo(AtomicInteger fcRow, List<ReportRow> reportRows) {
        List<String> fcParamVrmHeaders = this.reportHeaderGenerator.getFcVrmInfoHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.fc.vrm.info", fcParamVrmHeaders, fcRow, Collections.singletonList(this.parametersGenerator.generateVrmParams(this.processConfig))));
    }

    private void generateFcParamCnaCommonInfo(AtomicInteger fcRow, List<ReportRow> reportRows, List<ReportMergeRegion> mergeRegions) {
        int dhcpSize = 4;
        List<String> fcCnaCommonHeaders = this.reportHeaderGenerator.getFcCnaCommonInfoHeaders();
        reportRows.add(ExportReportUtils.createTitleCell(fcRow.getAndIncrement(), ExportReportUtils.getString("report.fc.cna.common.info"), fcCnaCommonHeaders.size()));
        HashMap<Integer, String> colValueMaps = new HashMap<Integer, String>();
        colValueMaps.put(1, ExportReportUtils.getString("report.fc.dhcp.service"));
        mergeRegions.add(ReportMergeRegion.builder().firstRow(fcRow.get()).firstCol(1).lastRow(fcRow.get()).lastCol(4).build());
        colValueMaps.put(5, ExportReportUtils.getString("report.fc.cna.install.info"));
        mergeRegions.add(ReportMergeRegion.builder().firstRow(fcRow.get()).firstCol(5).lastRow(fcRow.get()).lastCol(fcCnaCommonHeaders.size()).build());
        reportRows.add(ExportReportUtils.createMergeTitleCell(fcRow.getAndIncrement(), ReportCellStypeEnum.HEADER_CENTER, colValueMaps));
        reportRows.add(ExportReportUtils.createListRows(fcRow.getAndIncrement(), ReportCellStypeEnum.HEADER, fcCnaCommonHeaders));
        reportRows.addAll(Optional.of(this.parametersGenerator.generateFcCommonParams(this.processConfig)).map(vrmParam -> this.parseParamValues((Map<String, String>)vrmParam, fcCnaCommonHeaders)).map(vrmValues -> ExportReportUtils.createListRows(fcRow.getAndIncrement(), ReportCellStypeEnum.DEFAULT, vrmValues)).map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private void generateFcParamCnaList(AtomicInteger fcRow, List<ReportRow> reportRows) {
        List<String> cnaHostHeaders = this.reportHeaderGenerator.getFcCnaHostHeaders();
        reportRows.addAll(this.createBasicTableInfo("report.fc.cna.list", cnaHostHeaders, fcRow, this.parametersGenerator.generateFcParams(this.processConfig)));
    }

    private List<String> parseParamValues(Map<String, String> params, List<String> keys) {
        return keys.stream().map(title -> params.getOrDefault(title, "")).collect(Collectors.toList());
    }

    public ReportSheetParamsGenerator(VirtualizationDeployParametersGenerator parametersGenerator, CommonReportService commonReportService) {
        this.parametersGenerator = parametersGenerator;
        this.commonReportService = commonReportService;
    }
}

