/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.virtualization.deploy.constant.VirtualizationDeployConstant;
import com.huawei.yinglong.virtualization.deploy.entity.SupportDevice;
import com.huawei.yinglong.virtualization.deploy.utils.FileContentUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SupportDeviceService {
    private static final Logger log = LoggerFactory.getLogger(SupportDeviceService.class);

    public List<SupportDevice> querySupportDevices(String version) {
        String supportDeviceFileName = SystemEnvUtil.getLanguage() == Locale.SIMPLIFIED_CHINESE ? "support_device_zh.json" : "support_device_en.json";
        String jsonFilePath = String.join((CharSequence)File.separator, VirtualizationDeployConstant.SUPPORT_DEVICE_DIR, supportDeviceFileName);
        String supportDeviceContents = FileContentUtils.readStringFromFile(jsonFilePath);
        List supportDevices = JSON.parseArray((String)supportDeviceContents, SupportDevice.class);
        Iterator iterator = supportDevices.iterator();
        while (iterator.hasNext()) {
            SupportDevice supportDevice = (SupportDevice)iterator.next();
            if (!supportDevice.isContainVersion(version)) {
                iterator.remove();
                continue;
            }
            List childrenDevices = ListUtils.emptyIfNull(supportDevice.getChildren());
            childrenDevices.removeIf(device -> !device.isContainVersion(version));
            supportDevice.setChildren(childrenDevices);
        }
        return supportDevices;
    }
}

