/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.virtualization.deploy.constant.VirtualizationDeployConstant;
import com.huawei.yinglong.virtualization.deploy.utils.FileContentUtils;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimezoneService {
    private static final Logger log = LoggerFactory.getLogger(TimezoneService.class);
    @Nullable
    private JSONObject timezoneObj;

    @PostConstruct
    private void initTimezone() {
        if (Objects.isNull(this.timezoneObj)) {
            String jsonFilePath = String.join((CharSequence)File.separator, VirtualizationDeployConstant.TIMEZONE_DIR, this.getTimezoneFileName());
            String timezoneContents = FileContentUtils.readStringFromFile(jsonFilePath);
            log.info("init timezone config files. size={}.", (Object)timezoneContents.length());
            if (StringUtils.isNotEmpty((CharSequence)timezoneContents)) {
                this.timezoneObj = JSON.parseObject((String)timezoneContents);
            }
        }
    }

    private String getTimezoneFileName() {
        return SystemEnvUtil.getLanguage() == Locale.SIMPLIFIED_CHINESE ? "timezone_zh.json" : "timezone_en.json";
    }

    public String parseRegionKey(String regionName) {
        JSONObject timezone = Optional.ofNullable(this.timezoneObj).map(json -> json.getJSONObject("timezone")).orElse(new JSONObject());
        return timezone.entrySet().stream().filter(entry -> Objects.equals(regionName, entry.getValue())).findFirst().map(Map.Entry::getKey).orElse("");
    }

    public String getRegionName(String regionKey) {
        return Optional.ofNullable(this.timezoneObj).map(json -> json.getJSONObject("timezone")).map(json -> json.getString(regionKey)).orElse("");
    }

    public String parseAreaKey(String regionKey, String areaName) {
        JSONObject timezone = Optional.ofNullable(this.timezoneObj).map(json -> json.getJSONObject(regionKey)).orElse(new JSONObject());
        return timezone.entrySet().stream().filter(entry -> Objects.equals(areaName, entry.getValue())).findFirst().map(Map.Entry::getKey).orElse("");
    }

    public String getAreaName(String regionKey, String areaKey) {
        return Optional.ofNullable(this.timezoneObj).map(json -> json.getJSONObject(regionKey)).map(json -> json.getString(areaKey)).orElse("");
    }

    public Optional<JSONObject> querySupportTimezones() {
        if (Objects.isNull(this.timezoneObj) || this.timezoneObj.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JSONObject((Map)this.timezoneObj));
    }
}

