/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamBackupVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamSizeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.constant.VmTypeEnum;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.EbackupVmRole;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployDayuGeneralParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployDayuVmPlaneParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupPlaneInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcHostInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcNtpTimeInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployUltraVRInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployVrmInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportAssembler;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportParams;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuParamsVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DeployDayuVmsParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsParamVo;
import com.huawei.yinglong.virtualization.deploy.service.CommonReportService;
import com.huawei.yinglong.virtualization.deploy.service.TimezoneService;
import com.huawei.yinglong.virtualization.deploy.utils.ExportParametersExcelUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ExportParametersParseUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationDeployParametersGenerator {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployParametersGenerator.class);
    private final ExportAssembler assembler = (ExportAssembler)Mappers.getMapper(ExportAssembler.class);
    private final String templatePath = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "templates", "export", ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.file"));
    @Autowired
    private BpmEngineService bpmEngineService;
    @Autowired
    private TimezoneService timezoneService;
    @Autowired
    private CommonReportService commonReportService;

    public String generateParameter(ExportParams exportParams) {
        VirtualizationDeployProcessConfig processConfig = this.getProcessConfigFromBpmService(exportParams.getTaskId());
        Optional<String> targetPath = this.generateTargetFileName(exportParams.getExportPath());
        if (!targetPath.isPresent()) {
            log.error("target export parameter file error");
            return ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.export.error.path");
        }
        DeployParamsData exportData = DeployParamsData.builder().fcBaseInfos(this.generateFcBaseParams(processConfig)).fcHostExportInfos(this.generateFcParams(processConfig)).fcCommonInfos(this.generateFcCommonParams(processConfig)).ntpTimeInfos(this.generateFcVrmNtpTimeParams(processConfig)).backupInfos(this.generateFcVrmBackupParams(processConfig)).vrmExportInfos(this.generateVrmParams(processConfig)).dmeExportInfos(this.generateDmeParams(processConfig)).ultraExportInfos(this.generateUltraVRParams(processConfig)).eBackupExportInfos(this.generateEbackupBasicParams(processConfig)).eBackupVmExportInfos(this.generateEbackupVmParams(processConfig)).eBackupPlaneExportInfos(this.generateEbackupVmPlaneParams(processConfig)).dayuExportInfos(this.generateDayuParams(processConfig)).dayuPlaneExportInfos(this.generateDayuVmPlaneParams(processConfig)).hiCloudExportInfos(this.generateHiCloudParams(processConfig)).hiCloudVmExportInfos(this.generateHiCloudVmParams(processConfig)).sfsExportInfos(this.commonReportService.generateSfsParams(processConfig)).sfsVmExportInfos(this.commonReportService.generateSfsVmParams(processConfig)).sdnExportInfos(this.commonReportService.generateSdnParams(processConfig)).sdnVmExportInfos(this.commonReportService.generateSdnVmParams(processConfig)).campusExportInfos(this.commonReportService.generateCampusParams(processConfig)).campusVmExportInfos(this.commonReportService.generateCampusVmParams(processConfig)).build();
        return ExportParametersExcelUtils.exportDeployParams(this.templatePath, targetPath.get(), exportData);
    }

    List<Map<String, String>> generateHiCloudVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasHiCloudParam(processConfig)) {
            return Collections.emptyList();
        }
        return processConfig.getHiCloudParamVo().getVmParams().stream().map(this.assembler::toExportHiCloudVmParam).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    List<Map<String, String>> generateSfsVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasSfsParam(processConfig)) {
            return Collections.emptyList();
        }
        return processConfig.getSfsParamVo().getSfsVmVo().stream().map(this.assembler::toExportSfsVmParam).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    Map<String, String> generateHiCloudParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasHiCloudParam(processConfig)) {
            return Collections.emptyMap();
        }
        HiCloudParamVo hiCloudParamVo = processConfig.getHiCloudParamVo();
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(this.assembler.toExportHiCloudParam(hiCloudParamVo.getGeneral(), hiCloudParamVo.getPassword(), hiCloudParamVo.getPlan(), hiCloudParamVo.getService()));
    }

    private boolean hasHiCloudParam(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containHiCloudDeployScene(processConfig.getInstallMode())) {
            return false;
        }
        HiCloudParamVo hiCloudParamVo = processConfig.getHiCloudParamVo();
        if (Objects.isNull(hiCloudParamVo)) {
            log.info("current HiCloud params is null");
            return false;
        }
        return true;
    }

    Map<String, String> generateSfsParams(VirtualizationDeployProcessConfig processConfig) {
        if (!this.hasSfsParam(processConfig)) {
            return Collections.emptyMap();
        }
        SfsParamVo sfsParamVo = processConfig.getSfsParamVo();
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(this.assembler.toExportSfsParam(sfsParamVo.getSfsGeneralVo(), sfsParamVo.getSfsPlanVo(), sfsParamVo.getSfsPasswordVo()));
    }

    private boolean hasSfsParam(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containSfsDeployScene(processConfig.getInstallMode())) {
            return false;
        }
        SfsParamVo sfsParamVo = processConfig.getSfsParamVo();
        if (Objects.isNull(sfsParamVo)) {
            log.info("current SFS params is null");
            return false;
        }
        return true;
    }

    public List<Map<String, String>> generateDayuVmPlaneParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containDayuDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyList();
        }
        DayuParamsVo dayuParamsVo = processConfig.getDayuParamsVo();
        if (Objects.isNull(dayuParamsVo.getDeployDayuVmsParamsEntities())) {
            log.error("current eDataInsight params is null");
            return Collections.emptyList();
        }
        List<DeployDayuVmPlaneParamsEntity> deployDayuGeneralParamsEntity = this.transferDataToPlaneParams(dayuParamsVo.getDeployDayuVmsParamsEntities());
        return deployDayuGeneralParamsEntity.stream().map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    private List<DeployDayuVmPlaneParamsEntity> transferDataToPlaneParams(List<DeployDayuVmsParamsEntity> deployDayuVmsParamsEntities) {
        return deployDayuVmsParamsEntities.stream().map(this::toDeployDayuVmPlaneParamsEntity).collect(Collectors.toList());
    }

    private DeployDayuVmPlaneParamsEntity toDeployDayuVmPlaneParamsEntity(DeployDayuVmsParamsEntity entity) {
        DeployDayuVmPlaneParamsEntity deployDayuVmPlaneParamsEntity = DeployDayuVmPlaneParamsEntity.builder().ndpComponentList(entity.getNdpComponentList()).vmName(entity.getHostName()).cnaName(entity.getCnaName()).vmType(entity.getVmTypeEnum().getName()).cpu(entity.getCpuCores()).memory(entity.getMemorySizeGb()).serviceDisk(entity.getDiskCmds().get(0).getQuantityGB()).opIp(entity.getNicConfigs().get(0).getIp()).opMask(entity.getNicConfigs().get(0).getNetmask()).opPort(entity.getNicConfigs().get(0).getPortGroupName()).dataStoreName(entity.getDataStoreName()).build();
        if (entity.getVmTypeEnum() == VmTypeEnum.DAYU_CLOUD_SOP) {
            deployDayuVmPlaneParamsEntity.setMpIp(entity.getNicConfigs().get(1).getIp());
        }
        if (entity.getDiskCmds().size() == 2) {
            deployDayuVmPlaneParamsEntity.setDataDisk(entity.getDiskCmds().get(1).getQuantityGB());
        } else {
            deployDayuVmPlaneParamsEntity.setDataDisk(0);
        }
        return deployDayuVmPlaneParamsEntity;
    }

    public Map<String, String> generateDayuParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containDayuDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        DayuParamsVo dayuParamsVo = processConfig.getDayuParamsVo();
        if (Objects.isNull(dayuParamsVo) || Objects.isNull(dayuParamsVo.getFcLoginInfo()) || Objects.isNull(dayuParamsVo.getDayuTemplateInfo())) {
            log.error("current eDataInsight params is null");
            return Collections.emptyMap();
        }
        DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity = this.assembler.toDeployDayuGeneralParamsEntity(dayuParamsVo.getDayuBaseParams(), dayuParamsVo.getFcLoginInfo(), dayuParamsVo.getDayuTemplateInfo(), dayuParamsVo.getDayuPassword(), dayuParamsVo.getPacificParams());
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(deployDayuGeneralParamsEntity);
    }

    private VirtualizationDeployProcessConfig getProcessConfigFromBpmService(String taskId) {
        ProcessConfig processConfig = (ProcessConfig)ObjectMapperUtils.transObject((Object)this.bpmEngineService.queryProcessInstance(taskId).getProcessConfig(), ProcessConfig.class, (Object)new ProcessConfig());
        return (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)processConfig.getBusiness(), VirtualizationDeployProcessConfig.class, (Object)new VirtualizationDeployProcessConfig());
    }

    Map<String, String> generateFcBaseParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFcDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        List fcParams = ListUtils.emptyIfNull(processConfig.getDeployFc());
        return fcParams.stream().findFirst().map(param -> this.assembler.toExportFcBaseBo(param.getTask())).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).orElse(Collections.emptyMap());
    }

    Map<String, String> generateFcCommonParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFcCnaDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        List fcParams = ListUtils.emptyIfNull(processConfig.getDeployFc());
        return fcParams.stream().findFirst().map(param -> this.assembler.toExportFcCommonBo(param.getCna().getDhcp(), param.getCna())).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).orElse(Collections.emptyMap());
    }

    Map<String, String> generateFcVrmNtpTimeParams(VirtualizationDeployProcessConfig processConfig) {
        return this.generateFcVrmExternalParams(processConfig, paramsVo -> {
            DeployFcNtpTimeInfoEntity ntpTimeInfoEntity = this.assembler.toExportFcNtpTimeBo(paramsVo.getTime());
            String timezoneRegion = ntpTimeInfoEntity.getTimeZoneRegion();
            ntpTimeInfoEntity.setTimeZoneRegion(this.timezoneService.getRegionName(timezoneRegion));
            String timezoneArea = ntpTimeInfoEntity.getTimeZoneArea();
            ntpTimeInfoEntity.setTimeZoneArea(this.timezoneService.getAreaName(timezoneRegion, timezoneArea));
            return ntpTimeInfoEntity;
        });
    }

    Map<String, String> generateFcVrmBackupParams(VirtualizationDeployProcessConfig processConfig) {
        return this.generateFcVrmExternalParams(processConfig, paramsVo -> this.assembler.toExportFcBackupBo((InsParamBackupVo)ObjectUtils.defaultIfNull((Object)paramsVo.getBackup(), (Object)InsParamBackupVo.builder().build())));
    }

    private Map<String, String> generateFcVrmExternalParams(VirtualizationDeployProcessConfig processConfig, Function<VrmInstallParamsVo, Object> externalMapper) {
        if (!InstallModeEnum.containFcVrmDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        List fcParams = ListUtils.emptyIfNull(processConfig.getDeployFc());
        return fcParams.stream().findFirst().map(FcInstallParamsVo::getVrm).map(externalMapper).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).orElse(Collections.emptyMap());
    }

    List<Map<String, String>> generateFcParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFcCnaDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyList();
        }
        LinkedList fcExportEntities = new LinkedList();
        List fcParams = ListUtils.emptyIfNull(processConfig.getDeployFc());
        for (FcInstallParamsVo fcInstallParamsVo : fcParams) {
            fcExportEntities.addAll(fcInstallParamsVo.getCna().getNodes().stream().map(this.assembler::toExportFcHostBo).peek(node -> this.generateFcCustomExportInfo(fcInstallParamsVo, (DeployFcHostInfoEntity)node)).collect(Collectors.toList()));
        }
        return fcExportEntities.stream().map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    private void generateFcCustomExportInfo(FcInstallParamsVo fcInstallParamsVo, DeployFcHostInfoEntity node) {
        node.setFusionComputeName(fcInstallParamsVo.getTask().getTaskName());
    }

    Map<String, String> generateVrmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFcVrmDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        List fcParams = ListUtils.emptyIfNull(processConfig.getDeployFc());
        List exportEntities = fcParams.stream().map(this::generateVrmExportEntity).collect(Collectors.toList());
        return exportEntities.stream().findFirst().map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).orElse(Collections.emptyMap());
    }

    private DeployVrmInfoEntity generateVrmExportEntity(FcInstallParamsVo fcVo) {
        DeployVrmInfoEntity vrmExportEntity = this.assembler.toExportVrmBo(fcVo.getVrm().getCna(), fcVo.getVrm().getVrm(), fcVo.getVrm().getSize());
        vrmExportEntity.setArpIp(String.join((CharSequence)";", fcVo.getVrm().getVrm().getArp01Ip(), StringUtils.defaultString((String)fcVo.getVrm().getVrm().getArp02Ip()), StringUtils.defaultString((String)fcVo.getVrm().getVrm().getArp03Ip())));
        InsParamSizeVo paramSizeVo = fcVo.getVrm().getSize();
        if (paramSizeVo.getMode().equalsIgnoreCase("normal")) {
            String containerSuffix = BooleanUtils.toBoolean((Boolean)fcVo.getVrm().getVrm().getEnableKrm()) ? "container." : "";
            vrmExportEntity.setConfigSpecifications(ResourceConfigLoader.getStringFromExportMsg("deploy.params.export.size.normal." + containerSuffix + paramSizeVo.getId()));
        } else {
            vrmExportEntity.setConfigSpecifications(ResourceConfigLoader.getStringFromExportMsgWithParams("deploy.params.export.size.custom.description", paramSizeVo.getCpu(), paramSizeVo.getMem()));
        }
        if (BooleanUtils.toBoolean((Boolean)fcVo.getVrm().getVrm().getEnableKrm())) {
            vrmExportEntity.setImageCapacity(paramSizeVo.getRegistrySizeGb());
        } else {
            vrmExportEntity.setImageCapacity(0);
        }
        return vrmExportEntity;
    }

    Map<String, String> generateUltraVRParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containUltraVRdeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        UltraVRParams ultraVRParams = processConfig.getUltraVRParams();
        if (ultraVRParams == null || ultraVRParams.getFusionComputeInfo() == null || ultraVRParams.getTemplateInfo() == null) {
            log.error("current ultra vr params is null");
            return Collections.emptyMap();
        }
        DeployUltraVRInfoEntity ultraVRInfoEntity = this.assembler.toExportUltraVRBo(ultraVRParams, ultraVRParams.getTemplateInfo(), ultraVRParams.getFusionComputeInfo());
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(ultraVRInfoEntity);
    }

    Map<String, String> generateEbackupBasicParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containEbackupDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        EbackupParams ebackupParams = processConfig.getEbackupParams();
        if (Objects.isNull(ebackupParams) || Objects.isNull(ebackupParams.getFusionComputeInfo()) || Objects.isNull(ebackupParams.getTemplateInfo())) {
            log.error("current ebackup params is null");
            return Collections.emptyMap();
        }
        DeployEbackupInfoEntity deployEbackupInfoEntity = this.assembler.toExportEbackupBo(ebackupParams.getFusionComputeInfo(), ebackupParams.getTemplateInfo());
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(deployEbackupInfoEntity);
    }

    List<Map<String, String>> generateEbackupVmParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containEbackupDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyList();
        }
        EbackupParams ebackupParams = processConfig.getEbackupParams();
        if (Objects.isNull(ebackupParams) || Objects.isNull(ebackupParams.getEbackupVmInfo())) {
            log.error("generate vm params is null");
            return Collections.emptyList();
        }
        return ebackupParams.getEbackupVmInfo().stream().map(vmInfo -> this.assembler.toExportEbackupVmBo((EbackupVmInfo)vmInfo, EbackupVmRole.of(vmInfo.getRole()) == EbackupVmRole.SERVER ? null : vmInfo.getEbackupServerInfo())).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    Map<String, List<Map<String, String>>> generateEbackupVmPlaneParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containEbackupDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        EbackupParams ebackupParams = processConfig.getEbackupParams();
        if (Objects.isNull(ebackupParams) || Objects.isNull(ebackupParams.getEbackupVmInfo())) {
            log.error("generate vm plane params is null");
            return Collections.emptyMap();
        }
        return ebackupParams.getEbackupVmInfo().stream().collect(Collectors.toMap(EbackupVmInfo::getName, this::generateVmPlaneInfo));
    }

    private List<Map<String, String>> generateVmPlaneInfo(EbackupVmInfo vmInfo) {
        Stream<EbackupVmPlaneWrapper> vmPlaneStreams = Stream.of(EbackupVmPlaneWrapper.build("deploy.template.header.ebackup.plane.manage", vmInfo.getManagePlane()), EbackupVmPlaneWrapper.build("deploy.template.header.ebackup.plane.inner", vmInfo.getInnerPlane()), EbackupVmPlaneWrapper.build("deploy.template.header.ebackup.plane.production.storage", vmInfo.getProductionPlane()), EbackupVmPlaneWrapper.build("deploy.template.header.ebackup.plane.backup.storage", vmInfo.getBackupPlane()));
        return vmPlaneStreams.map(this::toPlaneInfoEntity).map(ExportParametersParseUtils::transferTableHeaderMappingParamsByAnnotation).collect(Collectors.toList());
    }

    private DeployEbackupPlaneInfoEntity toPlaneInfoEntity(EbackupVmPlaneWrapper planeWrapper) {
        DeployEbackupPlaneInfoEntity planeInfoEntity = this.assembler.toExportEbackupPlaneBo(planeWrapper.getVmPlane());
        planeInfoEntity.setPlaneName(planeWrapper.getName());
        return planeInfoEntity;
    }

    Map<String, String> generateDmeParams(VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containDmeDeployScene(processConfig.getInstallMode())) {
            return Collections.emptyMap();
        }
        Map dmeParameters = MapUtils.emptyIfNull(processConfig.getDmeData());
        return ExportParametersParseUtils.transferTableHeaderMappingParamsByAnnotation(ExportParametersParseUtils.transferDmeMapToExportEntity(dmeParameters));
    }

    private Optional<String> generateTargetFileName(String targetDirPath) {
        String fileName = "virtualization_parameter_" + new SimpleDateFormat("yyyyMMddHHmmssSS").format(new Date()) + ".xlsx";
        String targetFilePath = String.join((CharSequence)File.separator, targetDirPath, fileName);
        File file = new File(targetFilePath);
        try {
            if (!new File(targetDirPath).canWrite()) {
                log.error("current directory can't write");
                return Optional.empty();
            }
            return Optional.of(file.getCanonicalPath());
        }
        catch (IOException exception) {
            log.error("get export target file error", (Throwable)exception);
            return Optional.empty();
        }
    }

    private static class EbackupVmPlaneWrapper {
        private final String name;
        private final EbackupVmPlane vmPlane;

        static EbackupVmPlaneWrapper build(String nameKey, EbackupVmPlane vmPlane) {
            return new EbackupVmPlaneWrapper(ResourceConfigLoader.getStringFromExportHeaderTemplate(nameKey), vmPlane);
        }

        public String getName() {
            return this.name;
        }

        public EbackupVmPlane getVmPlane() {
            return this.vmPlane;
        }

        public EbackupVmPlaneWrapper(String name, EbackupVmPlane vmPlane) {
            this.name = name;
            this.vmPlane = vmPlane;
        }
    }
}

