/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.fitframework.core.common.util.UrlUtils;
import com.huawei.smartkit.drop.util.file.ExcelUtils;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyItemVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.ConsistencyResultVo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.CnaInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamBackupVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamCnaVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamDhcpVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamNodeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamSizeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamTimeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.TaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyFilterType;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.PackageConsistencyImpl;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.EcontainerConverter;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.IntegrateConverter;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.BackupDataType;
import com.huawei.yinglong.virtualization.deploy.constant.BackupFtpProtocol;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.constant.VirtualizationDeployConstant;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NpuPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerBasicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployDayuGeneralParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployDayuVmPlaneParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupPlaneInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployEbackupVmInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcBackupInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcBaseInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcCommonInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcHostInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployFcNtpTimeInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployParamsData;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployUltraVRInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.DeployVrmInfoEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.edme.DeployDmeParamsEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.hicloud.DeployHiClodParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.hicloud.DeployHiClodVmParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.importing.DeployFcImportParam;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportAssembler;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportParams;
import com.huawei.yinglong.virtualization.deploy.entity.importing.ImportResult;
import com.huawei.yinglong.virtualization.deploy.entity.integrate.IntegrateDmeProcessConfig;
import com.huawei.yinglong.virtualization.deploy.exception.ImportTemplateException;
import com.huawei.yinglong.virtualization.deploy.service.CommonReportService;
import com.huawei.yinglong.virtualization.deploy.service.TimezoneService;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationParametersValidator;
import com.huawei.yinglong.virtualization.deploy.utils.DayuImportParamsToDeployFieldUtils;
import com.huawei.yinglong.virtualization.deploy.utils.FilePathValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersExcelUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ImportParametersParseUtils;
import com.huawei.yinglong.virtualization.deploy.utils.RegexUtils;
import com.huawei.yinglong.virtualization.deploy.utils.ToolEnvUtils;
import com.huawei.yinglong.virtualization.deploy.utils.a3000.VerifyContext;
import com.huawei.yinglong.virtualization.deploy.utils.importing.ImportEcontainerParamUtils;
import com.huawei.yinglong.virtualization.deploy.utils.importing.ImportIntegrateParamUtils;
import com.huawei.yinglong.virtualization.deploy.utils.integrate.validate.ValidateIntegrateParamsUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationDeployParametersImporter {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployParametersImporter.class);
    private final ImportAssembler assembler = (ImportAssembler)Mappers.getMapper(ImportAssembler.class);
    private A3000DeployProcessConfig a3000DeployProcessConfig;
    private IntegrateDmeProcessConfig integrateDmeProcessConfig;
    @Autowired
    private BpmContextService bpmContextService;
    @Autowired
    private VirtualizationParametersValidator parametersValidator;
    @Autowired
    private TimezoneService timezoneService;
    @Autowired
    private CommonReportService commonReportService;
    @Autowired
    private EcontainerConverter econtainerConverter;
    @Autowired
    private IntegrateConverter integrateConverter;
    @Autowired
    private PackageConsistencyImpl packageConsistencyImpl;
    private VirtualizationDeployProcessConfig parseTemplateConfig;

    private static void dealCustomSizeAndCapacity(DeployVrmInfoEntity vrmInfoEntity, InsParamSizeVo sizeVo) {
        Object[] configs = RegexUtils.parseAllIntegerFromContent(vrmInfoEntity.getConfigSpecifications()).toArray(new Integer[0]);
        log.info("current custom config [{}]", (Object)StringUtils.join((Object[])configs, (String)","));
        sizeVo.setCpu((Integer)ArrayUtils.get((Object[])configs, (int)0, (Object)4));
        sizeVo.setMem((Integer)ArrayUtils.get((Object[])configs, (int)1, (Object)6));
        sizeVo.setRegistrySizeGb(vrmInfoEntity.getImageCapacity());
    }

    private static void dealNormalSizeAndCapacity(DeployVrmInfoEntity vrmInfoEntity, InsParamSizeVo sizeVo) {
        String config = vrmInfoEntity.getConfigSpecifications();
        String key = ResourceConfigLoader.getExportKeyByMsg(config);
        Object[] split = key.split("\\.");
        sizeVo.setId((String)ArrayUtils.get((Object[])split, (int)(split.length - 1), (Object)""));
        log.info("parse capacity is {}", (Object)vrmInfoEntity.getImageCapacity());
        sizeVo.setRegistrySizeGb(vrmInfoEntity.getImageCapacity());
    }

    private static String getExportMessage(String key) {
        return ResourceConfigLoader.getStringFromExportMsg(key);
    }

    public Response<String> handleDownloadTemplate(String downloadPath, String templateFileResKey) {
        String templateFileName = ResourceConfigLoader.getStringFromExportMsg(templateFileResKey);
        log.info("Start to download template {}", (Object)templateFileName);
        String templateTargetPath = String.join((CharSequence)File.separator, downloadPath, templateFileName);
        File templateFile = new File(VirtualizationDeployConstant.PARAMS_TEMPLATE_FILE_PATH, templateFileName);
        Optional<String> opDownloadResult = this.downloadTemplate(templateTargetPath, templateFile);
        if (opDownloadResult.isPresent()) {
            return ResponseUtil.failed((String)opDownloadResult.get(), (String)"");
        }
        log.info("Download template {} successfully.", (Object)templateFileName);
        return ResponseUtil.success((Object)templateFileName);
    }

    public Optional<String> downloadTemplate(String templateTargetPath, File templateFile) {
        Optional<String> normalTemplatePath = FilePathValidateUtils.getNormalizationPath(templateTargetPath);
        if (!normalTemplatePath.isPresent() || new File(normalTemplatePath.get()).exists()) {
            log.error("download dir path is error");
            return Optional.of(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.import.error.download"));
        }
        try {
            FileUtils.copyFile((File)templateFile, (File)new File(normalTemplatePath.get()), (boolean)true);
        }
        catch (IOException exception) {
            log.error("copy template to target file error", (Throwable)exception);
            return Optional.of(ResourceConfigLoader.getStringFromExportMsg("deploy.params.template.import.error.download"));
        }
        return Optional.empty();
    }

    public Response<ImportResult<VirtualizationDeployProcessConfig>> importParameters(ImportParams importParams, boolean isNewMod) {
        ImportResult<VirtualizationDeployProcessConfig> importResult = new ImportResult<VirtualizationDeployProcessConfig>();
        importResult.setValidResult(new HashMap<String, String>());
        Optional<String> normalTemplatePath = FilePathValidateUtils.getNormalizationPath(importParams.getImportFile());
        if (!normalTemplatePath.isPresent()) {
            log.error("normalize template file path error");
            return ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.suggest"));
        }
        Optional<Response> excelErrorResponse = this.checkExcelFormat(normalTemplatePath.get());
        if (excelErrorResponse.isPresent()) {
            return excelErrorResponse.get();
        }
        String taskId = StringUtils.defaultString((String)importParams.getTaskId());
        List<String> installModes = importParams.isOnlyCna() ? Collections.singletonList(InstallModeEnum.CNA.getInstallMode()) : ((VirtualizationDeployProcessConfig)this.bpmContextService.getContext(taskId, VirtualizationDeployProcessConfig.class)).getInstallMode();
        this.importVirtualParamsByTemplate(normalTemplatePath.get(), taskId, this.getInstallMode(installModes, isNewMod), false);
        importResult.setTemplateConfig(this.parseTemplateConfig);
        if (!importParams.isOnlyCna()) {
            this.validTemplateConfig(importResult.getValidResult());
        }
        this.parseTemplateConfig.setInstallMode(installModes);
        return ResponseUtil.success(importResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Response> checkExcelFormat(String normalTemplatePath) {
        if (!normalTemplatePath.endsWith(".xlsx") && !normalTemplatePath.endsWith(".xls")) {
            return Optional.of(ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.format.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.format.suggest")));
        }
        try (BufferedInputStream fileInputStream = new BufferedInputStream(FileUtils.openInputStream((File)new File(normalTemplatePath)));){
            if (!ExcelUtils.isExcelFileFormatValid((InputStream)fileInputStream)) {
                Optional<Response> optional = Optional.of(ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.format.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.format.suggest")));
                return optional;
            }
        }
        catch (IOException e) {
            log.error("read template file failed.", (Throwable)e);
            return Optional.of(ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.suggest")));
        }
        if (ExcelUtils.isExcelFileSizeValid((File)new File(normalTemplatePath))) return Optional.empty();
        return Optional.of(ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.size.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.size.suggest")));
    }

    public Response<ImportResult<A3000DeployProcessConfig>> importA3000Parameters(ImportParams importParams) {
        ImportResult<A3000DeployProcessConfig> importResult = new ImportResult<A3000DeployProcessConfig>();
        importResult.setValidResult(new HashMap<String, String>());
        Optional<String> normalTemplatePath = FilePathValidateUtils.getNormalizationPath(importParams.getImportFile());
        if (!normalTemplatePath.isPresent()) {
            log.error("normalize a3000 template file path error");
            return ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.suggest"));
        }
        Optional<Response> excelErrorResponse = this.checkExcelFormat(normalTemplatePath.get());
        if (excelErrorResponse.isPresent()) {
            return excelErrorResponse.get();
        }
        String taskId = StringUtils.defaultString((String)importParams.getTaskId());
        List<String> modesToInstall = this.getModeToInstall();
        this.importVirtualParamsByTemplate(normalTemplatePath.get(), taskId, modesToInstall, true);
        importResult.setTemplateConfig(this.a3000DeployProcessConfig);
        this.a3000DeployProcessConfig.setInstallMode(modesToInstall);
        this.checkImportParam(importResult);
        return ResponseUtil.success(importResult);
    }

    @NotNull
    private List<String> getModeToInstall() {
        if (ToolEnvUtils.isA3000Expansion()) {
            return Stream.of(InstallModeEnum.A3000_OS).map(InstallModeEnum::getInstallMode).collect(Collectors.toList());
        }
        return Stream.of(InstallModeEnum.A3000_OS, InstallModeEnum.A3000_STORAGE, InstallModeEnum.A3000_SOFTWARE, InstallModeEnum.A3000_DRIVER_PLUGIN, InstallModeEnum.A3000_RESOURCE_MANAGE).map(InstallModeEnum::getInstallMode).collect(Collectors.toList());
    }

    public Response<ImportResult<IntegrateDmeProcessConfig>> importIntegrateParameters(ImportParams importParams) {
        ImportResult<IntegrateDmeProcessConfig> importResult = new ImportResult<IntegrateDmeProcessConfig>();
        importResult.setValidResult(new HashMap<String, String>());
        Optional<String> normalTemplatePath = FilePathValidateUtils.getNormalizationPath(importParams.getImportFile());
        if (!normalTemplatePath.isPresent()) {
            log.error("normalize integrate template file path error");
            return ResponseUtil.failed((String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.error"), (String)VirtualizationDeployParametersImporter.getExportMessage("deploy.params.template.path.suggest"));
        }
        Optional<Response> excelErrorResponse = this.checkExcelFormat(normalTemplatePath.get());
        if (excelErrorResponse.isPresent()) {
            return excelErrorResponse.get();
        }
        String taskId = StringUtils.defaultString((String)importParams.getTaskId());
        List<String> installModes = ((IntegrateDmeProcessConfig)this.bpmContextService.getContext(taskId, IntegrateDmeProcessConfig.class)).getInstallMode();
        this.importIntegrateParamsByTemplate(normalTemplatePath.get(), taskId, installModes);
        importResult.setTemplateConfig(this.integrateDmeProcessConfig);
        this.integrateDmeProcessConfig.setInstallMode(installModes);
        this.validateIntegrateTemplateConfig(importResult.getValidResult());
        return ResponseUtil.success(importResult);
    }

    private void validateIntegrateTemplateConfig(Map<String, String> validResult) {
        Response<Map<String, String>> response = ValidateIntegrateParamsUtils.validateIntegrateParams(this.integrateDmeProcessConfig);
        if (!ResponseUtil.isFailed(response) && MapUtils.isNotEmpty((Map)((Map)response.getData()))) {
            validResult.putAll((Map)response.getData());
        }
    }

    public void importIntegrateParamsByTemplate(String templatePath, String taskId, List<String> installModes) {
        log.info("start import template params,include {} scene", installModes);
        DeployParamsData exportData = ImportParametersExcelUtils.importIntegrateParamsFromExcel(templatePath, installModes);
        exportData.setTaskId(taskId);
        this.integrateDmeProcessConfig = ImportIntegrateParamUtils.transferIntegrateData(exportData, this.integrateConverter);
        this.integrateDmeProcessConfig.setTaskId(taskId);
        this.integrateDmeProcessConfig.setInstallMode(installModes);
    }

    private void checkImportParam(ImportResult<A3000DeployProcessConfig> importResult) {
        List<String> noDataError = this.checkHasData(importResult);
        List<String> locationError = VerifyContext.getInstance().doVerify();
        noDataError.addAll(locationError);
        this.checkParamPlaneValid(importResult).ifPresent(noDataError::add);
        log.info("check import params error : {}.", noDataError);
        if (CollectionUtils.isNotEmpty(noDataError)) {
            throw new ImportTemplateException(noDataError);
        }
    }

    private Optional<String> checkParamPlaneValid(ImportResult<A3000DeployProcessConfig> importResult) {
        boolean hasAscend910B = Optional.ofNullable(importResult.getTemplateConfig()).map(A3000DeployProcessConfig::getServerInfos).filter(servers -> servers.stream().anyMatch(server -> Objects.equals("Ascend910B", server.getNpuDriverType()))).isPresent();
        if (!hasAscend910B) {
            return Optional.empty();
        }
        boolean hasParamPlaneValues = Optional.ofNullable(importResult.getTemplateConfig()).map(A3000DeployProcessConfig::getNpuPlaneInfos).filter(planeInfos -> planeInfos.stream().allMatch(NpuPlaneInfo::hasValidValue)).isPresent();
        return hasParamPlaneValues ? Optional.empty() : Optional.of(ResourceConfigLoader.getStringFromExportMsg("deploy.params.no.npu.plane.info"));
    }

    private List<String> checkHasData(ImportResult<A3000DeployProcessConfig> importResult) {
        ArrayList<String> noDataError = new ArrayList<String>();
        if (CollectionUtils.isEmpty(importResult.getTemplateConfig().getServerInfos())) {
            noDataError.add(ResourceConfigLoader.getStringFromExportMsg("deploy.params.no.server.info"));
        }
        if (ToolEnvUtils.isA3000Expansion()) {
            return noDataError;
        }
        if (CollectionUtils.isEmpty(importResult.getTemplateConfig().getSwitchInfos())) {
            noDataError.add(ResourceConfigLoader.getStringFromExportMsg("deploy.params.no.switch.info"));
        }
        if (CollectionUtils.isEmpty(importResult.getTemplateConfig().getStorageInfo())) {
            noDataError.add(ResourceConfigLoader.getStringFromExportMsg("deploy.params.no.storage.info"));
        }
        return noDataError;
    }

    private List<String> getInstallMode(List<String> installMode, boolean isNewMod) {
        return Arrays.stream(InstallModeEnum.values()).map(InstallModeEnum::getInstallMode).filter(installMode::contains).filter(mode -> isNewMod == InstallModeEnum.isHighLevelServiceMod(mode)).collect(Collectors.toList());
    }

    private void validTemplateConfig(Map<String, String> validResult) {
        Response<Map<String, String>> response = this.parametersValidator.validateDcsParams(this.parseTemplateConfig);
        if (!ResponseUtil.isFailed(response) && MapUtils.isNotEmpty((Map)((Map)response.getData()))) {
            validResult.putAll((Map)response.getData());
        }
    }

    public void importVirtualParamsByTemplate(String templatePath, String taskId, List<String> installMode, boolean isA3000) {
        log.info("start import template params,include {} scene", installMode);
        DeployParamsData exportData = ImportParametersExcelUtils.importParamsFromExcel(templatePath, installMode, isA3000);
        exportData.setTaskId(taskId);
        if (ToolEnvUtils.isA3000Deploy()) {
            this.updateA3000config(ImportEcontainerParamUtils.transferA3000Data(exportData, this.econtainerConverter), taskId);
            return;
        }
        if (ToolEnvUtils.isA3000Expansion()) {
            this.updateA3000config(ImportEcontainerParamUtils.transferA3000ExpansionData(exportData, this.econtainerConverter), taskId);
            return;
        }
        this.parseTemplateConfig = new VirtualizationDeployProcessConfig();
        DeployFcImportParam fcImportParam = this.transferFcParams(exportData);
        this.parseTemplateConfig.setInstallMode(installMode);
        this.transferFcData(fcImportParam, exportData.getTaskId(), this.parseTemplateConfig);
        this.transferUltraVR(exportData, this.parseTemplateConfig);
        this.transferEbackup(exportData, this.parseTemplateConfig);
        this.transferDmeData(exportData, this.parseTemplateConfig);
        this.transferDayuData(exportData, this.parseTemplateConfig);
        this.transferHiCloudData(exportData, this.parseTemplateConfig);
        this.commonReportService.transferSfsData(exportData, this.parseTemplateConfig);
        this.commonReportService.transferCampusCoreData(exportData, this.parseTemplateConfig, this.timezoneService);
        this.commonReportService.transferSdnData(exportData, this.parseTemplateConfig);
        this.commonReportService.transferFusionCubeData(exportData, this.parseTemplateConfig);
    }

    private void updateA3000config(A3000DeployProcessConfig exportData, String taskId) {
        this.a3000DeployProcessConfig = exportData;
        this.a3000DeployProcessConfig.setTaskId(taskId);
        this.updateTimezone(this.a3000DeployProcessConfig.getServerBasicInfo());
        log.info("import a3000 template params finish.");
    }

    private void updateTimezone(ServerBasicInfo basicInfo) {
        Optional.ofNullable(basicInfo).ifPresent(info -> info.setTimezoneRegion(this.timezoneService.parseRegionKey(info.getTimezoneRegion())));
        Optional.ofNullable(basicInfo).ifPresent(info -> info.setTimezoneArea(this.timezoneService.parseAreaKey(info.getTimezoneRegion(), info.getTimezoneArea())));
    }

    private void transferHiCloudData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containHiCloudDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeployHiClodParamEntity hiClodParamEntity = new DeployHiClodParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getHiCloudExportInfos(), hiClodParamEntity);
        this.validateHiCloudPackagePath(hiClodParamEntity);
        List<DeployHiClodVmParamEntity> hiClodVmParams = exportData.getHiCloudVmExportInfos().stream().map(this::buildDeployHiCloudVmsEntity).collect(Collectors.toList());
        this.parseTemplateConfig.setHiCloudParamVo(this.assembler.toHiCloudParam(hiClodParamEntity, hiClodVmParams));
    }

    void validateHiCloudPackagePath(DeployHiClodParamEntity hiClodParamEntity) {
        if (StringUtils.isEmpty((CharSequence)hiClodParamEntity.getPackagePath()) || !new File(hiClodParamEntity.getPackagePath()).isDirectory()) {
            hiClodParamEntity.setPackagePath("");
        }
    }

    private DeployHiClodVmParamEntity buildDeployHiCloudVmsEntity(Map<String, String> vmParam) {
        DeployHiClodVmParamEntity hiClodVmParam = new DeployHiClodVmParamEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(vmParam, hiClodVmParam);
        return hiClodVmParam;
    }

    private void transferDayuData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containDayuDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity = new DeployDayuGeneralParamsEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getDayuExportInfos(), deployDayuGeneralParamsEntity);
        this.addEDataInsightSoftwareTemplateFile(deployDayuGeneralParamsEntity);
        List<DeployDayuVmPlaneParamsEntity> deployDayuVmPlaneParamsEntities = exportData.getDayuPlaneExportInfos().stream().map(this::buildDeployDayuVmsParamsEntity).collect(Collectors.toList());
        this.parseTemplateConfig.setDayuParamsVo(DayuImportParamsToDeployFieldUtils.buildDayuParams(deployDayuGeneralParamsEntity, deployDayuVmPlaneParamsEntities));
    }

    void addEDataInsightSoftwareTemplateFile(DeployDayuGeneralParamsEntity deployDayuGeneralParamsEntity) {
        if (StringUtils.isEmpty((CharSequence)deployDayuGeneralParamsEntity.getSoftwarePath()) || !new File(deployDayuGeneralParamsEntity.getSoftwarePath()).isDirectory()) {
            deployDayuGeneralParamsEntity.setSoftwarePath("");
        }
        List<ConsistencyItemVo> validPackageConsistency = this.getConsistencyItemVos(deployDayuGeneralParamsEntity.getSoftwarePath(), ConsistencyFilterType.E_DATA_INSIGHT.getValue(), Arrays.asList(13, 14));
        deployDayuGeneralParamsEntity.setSoftPackagePath(deployDayuGeneralParamsEntity.getSoftwarePath() + "\\" + this.getInstallPackageByFileType(validPackageConsistency, 14));
        deployDayuGeneralParamsEntity.setDayuTemplateFilePath(deployDayuGeneralParamsEntity.getSoftwarePath() + "\\" + this.getInstallPackageByFileType(validPackageConsistency, 13));
    }

    private DeployDayuVmPlaneParamsEntity buildDeployDayuVmsParamsEntity(Map<String, String> dayuPlaneExportInfo) {
        DeployDayuVmPlaneParamsEntity deployDayuVmsParamsEntity = DeployDayuVmPlaneParamsEntity.builder().build();
        ImportParametersParseUtils.transferMapFromImportExcel(dayuPlaneExportInfo, deployDayuVmsParamsEntity);
        return deployDayuVmsParamsEntity;
    }

    private void transferEbackup(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containEbackupDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeployEbackupInfoEntity ebackupInfoEntity = new DeployEbackupInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getEBackupExportInfos(), ebackupInfoEntity);
        this.addEbackUpTemplateFile(ebackupInfoEntity);
        EbackupParams ebackupParams = this.assembler.fromEntityToEbackup(ebackupInfoEntity, "eBackup_" + exportData.getTaskId());
        ebackupParams.setEbackupVmInfo(exportData.getEBackupVmExportInfos().stream().map(this::transferEbackupVmInfoEntity).map(vmInfo -> this.transferEbackupVmInfo(exportData, (DeployEbackupVmInfoEntity)vmInfo)).collect(Collectors.toList()));
        processConfig.setEbackupParams(ebackupParams);
    }

    void addEbackUpTemplateFile(DeployEbackupInfoEntity ebackupInfoEntity) {
        String packagePath = ebackupInfoEntity.getTemplateFile();
        if (StringUtils.isEmpty((CharSequence)packagePath) || !new File(packagePath).isDirectory()) {
            ebackupInfoEntity.setTemplateFile("");
        }
        List<ConsistencyItemVo> validPackageConsistency = this.getConsistencyItemVos(packagePath, ConsistencyFilterType.E_BACKUP.getValue(), Collections.singletonList(7));
        ebackupInfoEntity.setTemplateFile(ebackupInfoEntity.getTemplateFile() + "\\" + this.getInstallPackageByFileType(validPackageConsistency, 7));
    }

    private EbackupVmInfo transferEbackupVmInfo(DeployParamsData exportData, DeployEbackupVmInfoEntity vmInfo) {
        EbackupVmInfo ebackupVmInfo = this.assembler.fromEntityToEbackupVm(vmInfo);
        List<DeployEbackupPlaneInfoEntity> vmPlanes = exportData.getEBackupPlaneExportInfos().getOrDefault(vmInfo.getVmListName(), Collections.emptyList()).stream().map(this::transferEbackupPlaneInfoEntity).collect(Collectors.toList());
        this.setEbackupVmPlaneInfo(vmPlanes, "deploy.template.header.ebackup.plane.manage", arg_0 -> ((EbackupVmInfo)ebackupVmInfo).setManagePlane(arg_0));
        this.setEbackupVmPlaneInfo(vmPlanes, "deploy.template.header.ebackup.plane.inner", arg_0 -> ((EbackupVmInfo)ebackupVmInfo).setInnerPlane(arg_0));
        this.setEbackupVmPlaneInfo(vmPlanes, "deploy.template.header.ebackup.plane.production.storage", arg_0 -> ((EbackupVmInfo)ebackupVmInfo).setProductionPlane(arg_0));
        this.setEbackupVmPlaneInfo(vmPlanes, "deploy.template.header.ebackup.plane.backup.storage", arg_0 -> ((EbackupVmInfo)ebackupVmInfo).setBackupPlane(arg_0));
        return ebackupVmInfo;
    }

    private void setEbackupVmPlaneInfo(List<DeployEbackupPlaneInfoEntity> vmPlanes, String planeNameKey, Consumer<EbackupVmPlane> consumer) {
        vmPlanes.stream().filter(vmPlane -> Objects.equals(ResourceConfigLoader.getStringFromExportHeaderTemplate(planeNameKey), vmPlane.getPlaneName())).findFirst().ifPresent(vmPlane -> consumer.accept(this.assembler.fromEntityToVmPlane((DeployEbackupPlaneInfoEntity)vmPlane)));
    }

    private DeployEbackupPlaneInfoEntity transferEbackupPlaneInfoEntity(Map<String, String> plane) {
        DeployEbackupPlaneInfoEntity planeInfo = new DeployEbackupPlaneInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(plane, planeInfo);
        return planeInfo;
    }

    private DeployEbackupVmInfoEntity transferEbackupVmInfoEntity(Map<String, String> vmInfos) {
        DeployEbackupVmInfoEntity ebackupVmInfo = new DeployEbackupVmInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(vmInfos, ebackupVmInfo);
        return ebackupVmInfo;
    }

    private void transferUltraVR(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containUltraVRdeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeployUltraVRInfoEntity ultraVRInfoEntity = new DeployUltraVRInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getUltraExportInfos(), ultraVRInfoEntity);
        this.addUltraVrTemplateFile(ultraVRInfoEntity);
        processConfig.setUltraVRParams(this.assembler.fromEntityToUltraVR(ultraVRInfoEntity, "UltraVR_" + exportData.getTaskId()));
    }

    void addUltraVrTemplateFile(DeployUltraVRInfoEntity ultraVRInfoEntity) {
        String packagePath = ultraVRInfoEntity.getTemplateFile();
        if (StringUtils.isEmpty((CharSequence)packagePath) || !new File(packagePath).isDirectory()) {
            ultraVRInfoEntity.setTemplateFile("");
        }
        List<ConsistencyItemVo> validPackageConsistency = this.getConsistencyItemVos(packagePath, ConsistencyFilterType.ULTRAVR.getValue(), Collections.singletonList(6));
        ultraVRInfoEntity.setTemplateFile(ultraVRInfoEntity.getTemplateFile() + "\\" + this.getInstallPackageByFileType(validPackageConsistency, 6));
    }

    private List<ConsistencyItemVo> getConsistencyItemVos(String packagePath, int paramsType, List<Integer> fileType) {
        List consistencyItems = Optional.ofNullable(this.packageConsistencyImpl.syncValidatePkgConsistency(UrlUtils.encode((String)packagePath), Integer.valueOf(paramsType)).getData()).map(ConsistencyResultVo::getItems).orElse(Collections.emptyList());
        return consistencyItems.stream().filter(consistency -> consistency.getResult() == 2 || consistency.getResult() == 4).filter(consistency -> fileType.contains(consistency.getFileType())).collect(Collectors.toList());
    }

    private DeployFcImportParam transferFcParams(DeployParamsData deployParamsData) {
        DeployFcImportParam fcImportParam = new DeployFcImportParam();
        DeployFcBaseInfoEntity infoEntity = new DeployFcBaseInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getFcBaseInfos(), infoEntity);
        fcImportParam.setBaseInfoEntity(infoEntity);
        DeployVrmInfoEntity vrmInfoEntity = new DeployVrmInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getVrmExportInfos(), vrmInfoEntity);
        fcImportParam.setVrmInfoEntity(vrmInfoEntity);
        DeployFcCommonInfoEntity commonInfoEntity = new DeployFcCommonInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getFcCommonInfos(), commonInfoEntity);
        fcImportParam.setCommonInfoEntity(commonInfoEntity);
        DeployFcNtpTimeInfoEntity timeInfoEntity = new DeployFcNtpTimeInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getNtpTimeInfos(), timeInfoEntity);
        fcImportParam.setNtpTimeInfoEntity(timeInfoEntity);
        DeployFcBackupInfoEntity backupInfoEntity = new DeployFcBackupInfoEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(deployParamsData.getBackupInfos(), backupInfoEntity);
        fcImportParam.setBackupInfoEntity(backupInfoEntity);
        LinkedList<DeployFcHostInfoEntity> hostInfoEntities = new LinkedList<DeployFcHostInfoEntity>();
        deployParamsData.getFcHostExportInfos().forEach(info -> {
            DeployFcHostInfoEntity entity = new DeployFcHostInfoEntity();
            ImportParametersParseUtils.transferMapFromImportExcel(info, entity);
            hostInfoEntities.add(entity);
        });
        fcImportParam.setHostInfoEntity(hostInfoEntities);
        return fcImportParam;
    }

    private void transferDmeData(DeployParamsData exportData, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containDmeDeployScene(processConfig.getInstallMode())) {
            return;
        }
        DeployDmeParamsEntity deployDmeParamsEntity = new DeployDmeParamsEntity();
        ImportParametersParseUtils.transferMapFromImportExcel(exportData.getDmeExportInfos(), deployDmeParamsEntity);
        if (StringUtils.isEmpty((CharSequence)deployDmeParamsEntity.getPackagePath()) || !new File(deployDmeParamsEntity.getPackagePath()).isDirectory()) {
            deployDmeParamsEntity.setPackagePath("");
        }
        Map<String, String> dmeParamsMap = ImportParametersParseUtils.transferDmeMap(deployDmeParamsEntity);
        this.initDmeDefaultParams(dmeParamsMap);
        this.buildDmeParamMap(dmeParamsMap, processConfig.getInstallMode());
        processConfig.setDmeData(dmeParamsMap);
    }

    private void buildDmeParamMap(Map<String, String> dmeParamsMap, List<String> installMode) {
        if (!InstallModeEnum.containFcDeployScene(installMode)) {
            dmeParamsMap.keySet().stream().filter(this::filterDmeKeyNeedClean).forEach(key -> dmeParamsMap.put((String)key, ""));
            dmeParamsMap.put("DMEData_FC_basic_manage", "NO");
        }
    }

    private boolean filterDmeKeyNeedClean(String dmeKey) {
        if (StringUtils.isEmpty((CharSequence)dmeKey)) {
            return false;
        }
        if (Arrays.asList("DMEData_FC_Gandalf_password", "DMEData_FC_root_password").contains(dmeKey)) {
            return false;
        }
        return dmeKey.contains("DMEData_FC");
    }

    private void initDmeDefaultParams(Map<String, String> dmeParamsMap) {
        dmeParamsMap.put("DMEData_marketplace_option", "NO");
    }

    private void transferFcData(DeployFcImportParam importParam, String taskId, VirtualizationDeployProcessConfig processConfig) {
        if (!InstallModeEnum.containFcDeployScene(processConfig.getInstallMode())) {
            return;
        }
        FcInstallParamsVo installParamsVo = new FcInstallParamsVo();
        installParamsVo.setTask(this.transferTaskInfoData(importParam, taskId));
        installParamsVo.setVrm(this.transferVrmInstallData(importParam));
        installParamsVo.setCna(this.transferCnaInstallData(importParam));
        processConfig.setDeployFc(Collections.singletonList(installParamsVo));
    }

    private TaskInfoVo transferTaskInfoData(DeployFcImportParam importParam, String taskId) {
        TaskInfoVo taskInfoVo = this.assembler.fromVrmBoToTaskVo(importParam.getBaseInfoEntity(), taskId);
        DeployFcHostInfoEntity masterNode = importParam.getHostInfoEntity().stream().filter(DeployFcHostInfoEntity::getIsMaster).findFirst().orElse(new DeployFcHostInfoEntity());
        if (InstallModeEnum.containFcCnaDeployScene(this.parseTemplateConfig.getInstallMode())) {
            this.assembler.fromBaseAndHostBoToTaskInfoVo(masterNode, importParam.getCommonInfoEntity(), taskInfoVo);
        } else {
            this.assembler.fromVrmFcBoToTaskInfoVo(importParam.getVrmInfoEntity(), taskInfoVo);
        }
        int paramsType = InstallModeEnum.transferInstallSceneToValidParamsType(this.parseTemplateConfig.getInstallMode());
        String packagePath = importParam.getBaseInfoEntity().getPackagePath();
        List consistencyItems = Optional.ofNullable(this.packageConsistencyImpl.syncValidatePkgConsistency(UrlUtils.encode((String)packagePath), Integer.valueOf(paramsType)).getData()).map(ConsistencyResultVo::getItems).orElse(Collections.emptyList());
        List<ConsistencyItemVo> validPackageConsistency = consistencyItems.stream().filter(consistency -> consistency.getResult() == 2 || consistency.getResult() == 4).filter(consistency -> consistency.getFileType() < 4).collect(Collectors.toList());
        taskInfoVo.setInstallerFileName(this.getInstallPackageByFileType(validPackageConsistency, 1));
        taskInfoVo.setVrmTempFileName(this.getInstallPackageByFileType(validPackageConsistency, 2));
        taskInfoVo.setCnaIsoFileName(this.getInstallPackageByFileType(validPackageConsistency, 3));
        return taskInfoVo;
    }

    private String getInstallPackageByFileType(List<ConsistencyItemVo> consistencyFiles, int fileType) {
        return consistencyFiles.stream().filter(file -> file.getFileType() == fileType).findFirst().map(ConsistencyItemVo::getFileName).orElse("");
    }

    private CnaInstallParamsVo transferCnaInstallData(DeployFcImportParam importParam) {
        CnaInstallParamsVo cnaInstallParamsVo = new CnaInstallParamsVo();
        this.assembler.fromCommonBoToNodeInstallVo(importParam.getCommonInfoEntity(), cnaInstallParamsVo);
        cnaInstallParamsVo.setDhcp(this.transferDhcpData(importParam));
        cnaInstallParamsVo.setNodes(this.transferFcNodeData(importParam));
        cnaInstallParamsVo.setIsAutoSwap(Boolean.valueOf(false));
        cnaInstallParamsVo.setCnaDriver(cnaInstallParamsVo.getCnaDriver());
        if (StringUtils.equalsIgnoreCase((CharSequence)cnaInstallParamsVo.getInstallType(), (CharSequence)"recover")) {
            cnaInstallParamsVo.setSwapSize(Integer.valueOf(30));
        }
        return cnaInstallParamsVo;
    }

    private List<InsParamNodeVo> transferFcNodeData(DeployFcImportParam importParam) {
        return importParam.getHostInfoEntity().stream().map(this.assembler::fromCnaBoToNodeVo).collect(Collectors.toList());
    }

    private InsParamDhcpVo transferDhcpData(DeployFcImportParam importParam) {
        return this.assembler.fromVrmCommonBoToDhcpVo(importParam.getCommonInfoEntity());
    }

    private VrmInstallParamsVo transferVrmInstallData(DeployFcImportParam importParam) {
        VrmInstallParamsVo paramsVo = new VrmInstallParamsVo();
        paramsVo.setType("typical");
        paramsVo.setVrm(this.transferVrmParamsData(importParam));
        paramsVo.setCna(this.transferVrmNodeData(importParam));
        paramsVo.setSize(this.transferVrmSizeData(importParam));
        paramsVo.setTime(this.transferVrmTimeData(importParam));
        paramsVo.setBackup(this.transferVrmBackupData(importParam));
        this.cleanupSingleOptionVrmData(paramsVo);
        this.cleanupNoNeedOptionVrmData(paramsVo);
        return paramsVo;
    }

    private void cleanupSingleOptionVrmData(VrmInstallParamsVo paramsVo) {
        InsParamVrmVo insParamVrmVo = paramsVo.getVrm();
        InsParamCnaVo paramsVoCna = paramsVo.getCna();
        if (StringUtils.equalsIgnoreCase((CharSequence)insParamVrmVo.getUserMode(), (CharSequence)"normal")) {
            insParamVrmVo.setSecAdminPwd("");
            insParamVrmVo.setSysAdminPwd("");
            insParamVrmVo.setSecAuditorPwd("");
        } else {
            insParamVrmVo.setAdminPwd("");
        }
        if (BooleanUtils.isNotTrue((Boolean)insParamVrmVo.getEnableKrm())) {
            paramsVo.getSize().setRegistrySizeGb(Integer.valueOf(0));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)insParamVrmVo.getMode(), (CharSequence)"single")) {
            insParamVrmVo.setSlaveIp("");
            insParamVrmVo.setSlaveName("");
            insParamVrmVo.setFloatIp("");
            paramsVoCna.setSlaveIp("");
            paramsVoCna.setSlaveRootPwd("");
            paramsVoCna.setSlaveGandalfPwd("");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)insParamVrmVo.getCipherMode(), (CharSequence)"sm")) {
            insParamVrmVo.setEnableHsm(Boolean.valueOf(false));
            insParamVrmVo.setHsmIp("");
            insParamVrmVo.setHsm02Ip("");
            insParamVrmVo.setHsmAccount("");
            insParamVrmVo.setHsmPwd("");
            insParamVrmVo.setHsmServicePwd("");
        }
    }

    private void cleanupNoNeedOptionVrmData(VrmInstallParamsVo paramsVo) {
        InsParamBackupVo backupVo;
        InsParamTimeVo timeVo = paramsVo.getTime();
        if (!Boolean.TRUE.equals(timeVo.getIsConfigNtp())) {
            timeVo.setSyncPeriod(Integer.valueOf(64));
            timeVo.setNtpIp1("");
            timeVo.setNtpIp2("");
            timeVo.setNtpIp3("");
        }
        if (!Boolean.TRUE.equals((backupVo = paramsVo.getBackup()).getIsConfigBackup())) {
            backupVo.setBackupType(BackupDataType.THIRD.getType());
            this.clearBackupFtpParams(backupVo);
            backupVo.setBackupCnaNames(null);
        } else if (Objects.equals(BackupDataType.THIRD.getType(), backupVo.getBackupType())) {
            backupVo.setBackupCnaNames(null);
        } else if (Objects.equals(BackupDataType.HOST.getType(), backupVo.getBackupType())) {
            this.clearBackupFtpParams(backupVo);
        } else {
            log.info("other data backup type : {}.", (Object)backupVo.getBackupType());
        }
    }

    private void clearBackupFtpParams(InsParamBackupVo backupVo) {
        backupVo.setFtpProtocol(BackupFtpProtocol.FTPS.getProtocol());
        backupVo.setFtpIpAddr(null);
        backupVo.setFtpUsername("ftp");
        backupVo.setFtpPassword(null);
        backupVo.setFtpPort(Integer.valueOf(21));
        backupVo.setFtpBackupPath("/GalaxEngineBackup/VRM/");
        backupVo.setFtpCertPath(null);
    }

    private InsParamCnaVo transferVrmNodeData(DeployFcImportParam importParam) {
        return this.assembler.fromVrmBoToVrmFcVo(importParam.getVrmInfoEntity());
    }

    private InsParamVrmVo transferVrmParamsData(DeployFcImportParam importParam) {
        InsParamVrmVo insParamVrmVo = this.assembler.fromVrmBoToVrmVo(importParam.getVrmInfoEntity());
        Object[] arpIps = importParam.getVrmInfoEntity().getArpIp().split(";");
        insParamVrmVo.setArp01Ip((String)ArrayUtils.get((Object[])arpIps, (int)0, (Object)""));
        insParamVrmVo.setArp02Ip((String)ArrayUtils.get((Object[])arpIps, (int)1, (Object)""));
        insParamVrmVo.setArp03Ip((String)ArrayUtils.get((Object[])arpIps, (int)2, (Object)""));
        return insParamVrmVo;
    }

    private InsParamSizeVo transferVrmSizeData(DeployFcImportParam importParam) {
        DeployVrmInfoEntity vrmInfoEntity = importParam.getVrmInfoEntity();
        InsParamSizeVo sizeVo = this.assembler.fromVrmBoToSizeVo(vrmInfoEntity);
        if (Objects.equals(sizeVo.getMode(), "normal")) {
            VirtualizationDeployParametersImporter.dealNormalSizeAndCapacity(vrmInfoEntity, sizeVo);
        } else {
            VirtualizationDeployParametersImporter.dealCustomSizeAndCapacity(vrmInfoEntity, sizeVo);
        }
        return sizeVo;
    }

    private InsParamTimeVo transferVrmTimeData(DeployFcImportParam importParam) {
        DeployFcNtpTimeInfoEntity ntpTimeInfoEntity = importParam.getNtpTimeInfoEntity();
        ntpTimeInfoEntity.setTimeZoneRegion(this.timezoneService.parseRegionKey(ntpTimeInfoEntity.getTimeZoneRegion()));
        ntpTimeInfoEntity.setTimeZoneArea(this.timezoneService.parseAreaKey(ntpTimeInfoEntity.getTimeZoneRegion(), ntpTimeInfoEntity.getTimeZoneArea()));
        return this.assembler.fromVrmBoToTimeVo(ntpTimeInfoEntity);
    }

    private InsParamBackupVo transferVrmBackupData(DeployFcImportParam importParam) {
        DeployFcBackupInfoEntity backupInfoEntity = importParam.getBackupInfoEntity();
        return this.assembler.fromVrmBoToBackupVo(backupInfoEntity);
    }

    public A3000DeployProcessConfig getA3000DeployProcessConfig() {
        return this.a3000DeployProcessConfig;
    }

    public IntegrateDmeProcessConfig getIntegrateDmeProcessConfig() {
        return this.integrateDmeProcessConfig;
    }

    public void setTimezoneService(TimezoneService timezoneService) {
        this.timezoneService = timezoneService;
    }

    public void setCommonReportService(CommonReportService commonReportService) {
        this.commonReportService = commonReportService;
    }

    public void setEcontainerConverter(EcontainerConverter econtainerConverter) {
        this.econtainerConverter = econtainerConverter;
    }

    public void setIntegrateConverter(IntegrateConverter integrateConverter) {
        this.integrateConverter = integrateConverter;
    }

    public void setPackageConsistencyImpl(PackageConsistencyImpl packageConsistencyImpl) {
        this.packageConsistencyImpl = packageConsistencyImpl;
    }

    public VirtualizationDeployProcessConfig getParseTemplateConfig() {
        return this.parseTemplateConfig;
    }
}

