/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.virtualization.deploy.constant.VirtualizationDeployConstant;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckItem;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckMethod;
import com.huawei.yinglong.virtualization.deploy.entity.precheck.CheckResult;
import com.huawei.yinglong.virtualization.deploy.service.CheckMethodProvider;
import com.huawei.yinglong.virtualization.deploy.utils.FileContentUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationDeployPrecheckService {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployPrecheckService.class);
    private static final Map<String, CheckMethod> COMMON_CHECK_MAP = CheckMethodProvider.getCommonCheckMethod();
    @Autowired
    private BpmEngineService bpmEngineService;

    public List<CheckItem> getCheckItemsFromFile(String instanceId) {
        List<String> installMode = this.getProcessConfigFromBpmService(instanceId).getInstallMode();
        String checkResourceFileName = SystemEnvUtil.getLanguage() == Locale.SIMPLIFIED_CHINESE ? "precheck_items_zh.json" : "precheck_items_en.json";
        String jsonFilePath = String.join((CharSequence)File.separator, VirtualizationDeployConstant.PRE_CHECK_FILE_DIR, checkResourceFileName);
        String precheckContent = FileContentUtils.readStringFromFile(jsonFilePath);
        List allCheckItems = JSON.parseArray((String)precheckContent, CheckItem.class);
        return allCheckItems.stream().filter(item -> !ListUtils.retainAll(item.getInstallModes(), (Collection)installMode).isEmpty()).collect(Collectors.toList());
    }

    public List<CheckResult> executeCheck(String instanceId, List<String> checkItemIds) {
        Map<String, CheckMethod> methodMap = CheckMethodProvider.getRuntimeCheckMethod(this.getProcessConfigFromBpmService(instanceId));
        methodMap.putAll(COMMON_CHECK_MAP);
        return checkItemIds.stream().map(methodMap::get).filter(Objects::nonNull).map(CheckMethod::check).collect(Collectors.toList());
    }

    public boolean updateCheckResult(String instanceId, List<CheckItem> checkItems) {
        log.info("task {} check item result:", (Object)instanceId);
        checkItems.forEach(item -> log.info("item:{}, state:{}", (Object)item.getCheckItemName(), (Object)item.getCheckState()));
        return true;
    }

    private VirtualizationDeployProcessConfig getProcessConfigFromBpmService(String instanceId) {
        ProcessConfig processConfig = (ProcessConfig)ObjectMapperUtils.transObject((Object)this.bpmEngineService.queryProcessInstance(instanceId).getProcessConfig(), ProcessConfig.class, (Object)new ProcessConfig());
        return (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)processConfig.getBusiness(), VirtualizationDeployProcessConfig.class, (Object)new VirtualizationDeployProcessConfig());
    }
}

