/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.smartkit.baseserver.report.business.excel.ReportExcelData;
import com.huawei.smartkit.baseserver.report.business.excel.ReportSheet;
import com.huawei.smartkit.baseserver.report.service.ReportData;
import com.huawei.smartkit.baseserver.report.service.ReportGenerator;
import com.huawei.smartkit.baseserver.report.service.ReportType;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessActivityQueryDto;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.export.ExportParams;
import com.huawei.yinglong.virtualization.deploy.service.DeployReportHeaderGenerator;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetBaseGenerator;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetCommonGenerator;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetDetailGenerator;
import com.huawei.yinglong.virtualization.deploy.service.ReportSheetParamsGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployParametersGenerator;
import com.huawei.yinglong.virtualization.deploy.service.VirtualizationDeployPrecheckService;
import com.huawei.yinglong.virtualization.deploy.utils.ExportReportUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationDeployReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployReportGenerator.class);
    private static final Map<String, BiConsumer<ReportSheetBaseGenerator, ProcessStatus>> DEPLOY_ID_STATUS_MAP = new HashMap<String, BiConsumer<ReportSheetBaseGenerator, ProcessStatus>>();
    private final Map<ProcessActivity, List<DeployTaskDetailVo>> processActivityMaps = new HashMap<ProcessActivity, List<DeployTaskDetailVo>>();
    @Autowired
    private BpmEngineService bpmEngineService;
    @Autowired
    private VirtualizationDeployParametersGenerator parametersGenerator;
    @Autowired
    private DeployReportHeaderGenerator reportHeaderGenerator;
    @Autowired
    private ReportSheetParamsGenerator reportSheetParamsGenerator;
    @Autowired
    private ReportSheetCommonGenerator reportSheetCommonGenerator;
    @Autowired
    private ReportSheetDetailGenerator reportSheetDetailGenerator;
    @Autowired
    private ReportGenerator reportGenerator;
    @Autowired
    private VirtualizationDeployPrecheckService preCheckService;
    private VirtualizationDeployProcessConfig processConfig;
    private ProcessInstanceDto processInstanceDto;
    private List<ProcessActivity> processActivities;

    public String generateReport(ExportParams exportParams) {
        Optional<String> opReportPath = ExportReportUtils.canonicalReportPath(exportParams.getExportPath());
        if (!opReportPath.isPresent()) {
            log.error("report path get failed.");
            return ExportReportUtils.getString("report.error.path.invalid");
        }
        String initDataResult = this.initProcessActivityAllDatas(exportParams);
        if (StringUtils.isNotEmpty((CharSequence)initDataResult)) {
            log.error("init process activity all data failed, result={}, id={}.", (Object)initDataResult, (Object)exportParams.getTaskId());
            return initDataResult;
        }
        log.info("init data finished, fc:{}, UltraVR:{}, eBackup:{}, dme:{},eDataInsight:{}", new Object[]{ExportReportUtils.hasDeployFusionComputeModule(this.processConfig), ExportReportUtils.hasDeployUltraVRModule(this.processConfig), ExportReportUtils.hasDeployEbackupModule(this.processConfig), ExportReportUtils.hasDeployDmeModule(this.processConfig), ExportReportUtils.hasDeployEDataInsightModule(this.processConfig)});
        String reportFileName = ExportReportUtils.generateReportFileName("DCS", this.processInstanceDto.getName());
        ReportData reportData = ReportData.builder().reportType(ReportType.EXCEL_XLSX).reportPath(opReportPath.get()).pageDatas(Collections.singletonList(((ReportExcelData.ReportExcelDataBuilder)((ReportExcelData.ReportExcelDataBuilder)ReportExcelData.builder().id(1)).pageName(reportFileName)).sheets(this.createReportSheet()).build())).build();
        if (!this.reportGenerator.generateReport(reportData)) {
            return ExportReportUtils.getString("report.error.generate.failed");
        }
        ExportReportUtils.backupReportToToolBox(exportParams, reportFileName);
        return "";
    }

    String initProcessActivityAllDatas(ExportParams exportParams) {
        this.processInstanceDto = this.bpmEngineService.queryProcessInstance(exportParams.getTaskId());
        if (!ExportReportUtils.checkProcessInstanceValid(this.processInstanceDto)) {
            log.error("check process instance invalid.");
            return ExportReportUtils.getString("report.error.task.data.invalid");
        }
        ProcessConfig instanceProcessConfig = (ProcessConfig)ObjectMapperUtils.transObject((Object)this.processInstanceDto.getProcessConfig(), ProcessConfig.class, (Object)new ProcessConfig());
        this.processConfig = (VirtualizationDeployProcessConfig)ObjectMapperUtils.transObject((Object)instanceProcessConfig.getBusiness(), VirtualizationDeployProcessConfig.class, (Object)new VirtualizationDeployProcessConfig());
        if (Objects.isNull(this.processConfig) || CollectionUtils.isEmpty(this.processConfig.getInstallMode())) {
            log.error("get task params failed.");
            return ExportReportUtils.getString("report.error.task.param.invalid");
        }
        ProcessActivityQueryDto queryDto = new ProcessActivityQueryDto();
        queryDto.setInstanceId(exportParams.getTaskId());
        this.processActivities = this.bpmEngineService.queryActivityDetail(queryDto);
        if (CollectionUtils.isEmpty(this.processActivities)) {
            log.error("process activities is empty.");
            return ExportReportUtils.getString("report.error.task.step.invalid");
        }
        this.initReportSheetGenerators();
        return "";
    }

    private void setDeployStatus(String deployId, BiConsumer<ReportSheetBaseGenerator, ProcessStatus> biConsumer) {
        ProcessStatus deployStatus = ExportReportUtils.findDeployStatus(this.processActivities, deployId);
        Stream.of(this.reportSheetParamsGenerator, this.reportSheetCommonGenerator, this.reportSheetDetailGenerator).forEach(generator -> biConsumer.accept((ReportSheetBaseGenerator)generator, deployStatus));
        log.info("find deploy status, deployId : {}, status : {}.", (Object)deployId, (Object)deployStatus);
    }

    private void initReportSheetGenerators() {
        Stream.of(this.reportSheetParamsGenerator, this.reportSheetCommonGenerator, this.reportSheetDetailGenerator).forEach(generator -> generator.setProcessConfig(this.processConfig));
        DEPLOY_ID_STATUS_MAP.forEach(this::setDeployStatus);
        this.filterProcessActivityMaps();
        this.reportSheetDetailGenerator.updateProcessActivity(this.processActivities, this.processActivityMaps);
    }

    private void filterProcessActivityMaps() {
        this.processActivityMaps.clear();
        this.processActivityMaps.putAll(ExportReportUtils.filterProcessActivityMaps(this.bpmEngineService, this.processActivities));
    }

    private List<ReportSheet> createReportSheet() {
        LinkedList<ReportSheet> reportSheets = new LinkedList<ReportSheet>();
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createSummarySheet(this.processInstanceDto));
        this.addReportSheet(reportSheets, this.reportSheetCommonGenerator.createPreCheckSheet(this.processInstanceDto.getId()));
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createFusionComputeTaskDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createUltraVRTaskDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createEbackupTaskDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createDmeDataTaskDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createEDataInsightDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createHiCloudDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createSfsDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createSdnDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createCampusDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetDetailGenerator.createMigrationDetailSheet());
        this.addReportSheet(reportSheets, this.reportSheetCommonGenerator.createPortalSheet());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createFusionComputeParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createUltraVRParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createEbackupParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createDmeDataParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createDayuDataParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createHiCloudDataParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createSfsDataParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createSdnDataParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createCampusDataParams());
        this.addReportSheet(reportSheets, this.reportSheetParamsGenerator.createMigrationDataParams());
        return reportSheets;
    }

    private void addReportSheet(List<ReportSheet> reportSheets, Optional<ReportSheet> optionalReportSheet) {
        optionalReportSheet.ifPresent(reportSheets::add);
    }

    static {
        DEPLOY_ID_STATUS_MAP.put("fcDeploy#multiInstanceBody", ReportSheetBaseGenerator::setDeployFcStatus);
        DEPLOY_ID_STATUS_MAP.put("ultraVRDeployment", ReportSheetBaseGenerator::setDeployUltraVRStatus);
        DEPLOY_ID_STATUS_MAP.put("eBackupDeployment", ReportSheetBaseGenerator::setDeployEbackupStatus);
        DEPLOY_ID_STATUS_MAP.put("dmeDeploy", ReportSheetBaseGenerator::setDeployDmeStatus);
        DEPLOY_ID_STATUS_MAP.put("dayuDeploy", ReportSheetBaseGenerator::setDeployEDataInsightStatus);
        DEPLOY_ID_STATUS_MAP.put("hiCloudDeploy", ReportSheetBaseGenerator::setDeployHiCloudStatus);
        DEPLOY_ID_STATUS_MAP.put("sfsDeployment", ReportSheetBaseGenerator::setDeploySfsStatus);
        DEPLOY_ID_STATUS_MAP.put("sdnDeployment", ReportSheetBaseGenerator::setDeploySdnStatus);
        DEPLOY_ID_STATUS_MAP.put("campusCoreDeploy", ReportSheetBaseGenerator::setDeployCampusStatus);
        DEPLOY_ID_STATUS_MAP.put("fusionCubeMigrationDeployment", ReportSheetBaseGenerator::setDeployMigrationStatus);
    }
}

