/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.bpm.BpmValidateService;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationDeployValidateService
implements BpmValidateService {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationDeployValidateService.class);
    private static final String INSTALL_MODE = "installMode";

    private boolean checkCampusInstallModeIsInvalid(List<?> installMode) {
        return installMode.contains(InstallModeEnum.CAMPUS.getInstallMode()) && CollectionUtils.containsAny(installMode, Arrays.asList(InstallModeEnum.CNA.getInstallMode(), InstallModeEnum.VRM.getInstallMode(), InstallModeEnum.DME.getInstallMode()));
    }

    public List<String> validateProcessBusiness(Map<String, Object> business) {
        LinkedList<String> validResult = new LinkedList<String>();
        List installMode = Optional.ofNullable(business).map(bus -> bus.get(INSTALL_MODE)).filter(List.class::isInstance).map(List.class::cast).orElse(Collections.emptyList());
        if (this.checkCampusInstallModeIsInvalid(installMode)) {
            validResult.add(ResourceConfigLoader.getErrorMessage("deploy.install.mode.valid"));
        }
        return validResult;
    }
}

