/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeInstallParamFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.impl.DeployEbackupFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.impl.ValidateInstallParamsImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.impl.DeployUltraVRFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmDeployFitImpl;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.constant.InstallModeEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.ParamUnionValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.VmParamUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.CampusParamsValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.DayuParamsValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.HicloudParamsValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.SdnParamsValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.SfsParamsValidateUtils;
import com.huawei.yinglong.virtualization.deploy.utils.validate.fusioncubemigration.FusionCubeMigrationValidateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationParametersValidator {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationParametersValidator.class);
    private final DeployEbackupFitImpl deployEbackupImpl;
    private final DeployUltraVRFitImpl deployUltraVRImpl;
    private final VmDeployFitImpl vmDeployImpl;
    private final DmeInstallParamFitImpl dmeInstallParamImpl;
    private final ValidateInstallParamsImpl validateInstallParamsImpl;

    static void setParams(@NotNull Map<String, String> params) {
        params.put("DMEData_deploy_data_protection", "NO");
        params.put("DMEData_deploy_data_container", "NO");
        params.put("DMEData_deploy_lite_ca", "NO");
        params.put("DMEData_graph_password", "");
    }

    public Response<String> validateFcParams(int deployType, @NotNull FcInstallParamsVo paramsVo) {
        return this.validateInstallParamsImpl.validateInsParams(Integer.valueOf(deployType), paramsVo);
    }

    public Response<String> validateUltraVRParams(@NotNull UltraVRParams paramsVo) {
        return this.deployUltraVRImpl.validUltraVRParams(paramsVo);
    }

    public Response<String> validateEbackupParams(@NotNull EbackupParams paramsVo) {
        return this.deployEbackupImpl.validEbackupParams(paramsVo);
    }

    public Response<String> validateDmeParams(@NotNull Map<String, String> params) {
        VirtualizationParametersValidator.setParams(params);
        log.info("start to validate dme param!");
        Result result = this.dmeInstallParamImpl.validConfigParam(new HashMap<String, String>(params));
        if (result.getCode() != 0) {
            return ResponseUtil.success((Object)result.getDescription());
        }
        if (!VmParamUtils.isAutoCreateVm(params)) {
            return ResponseUtil.success();
        }
        log.info("start to validate vm param!");
        result = this.vmDeployImpl.validParam(VmParamUtils.createVmParam(params));
        if (result.getCode() != 0) {
            return ResponseUtil.success((Object)result.getDescription());
        }
        return ResponseUtil.success();
    }

    public Response<Map<String, String>> validateDcsParams(@NotNull VirtualizationDeployProcessConfig processConfig) {
        log.info("Start to validate DCS params, involved Scenarios : {}.", processConfig.getInstallMode());
        HashMap<String, String> validResult = new HashMap<String, String>();
        this.validFusionComputeParams(processConfig).ifPresent(validMsg -> validResult.put("fc", (String)validMsg));
        this.validUltraVRParams(processConfig).ifPresent(validMsg -> validResult.put("ultraVR", (String)validMsg));
        this.validEbackupParams(processConfig).ifPresent(validMsg -> validResult.put("eBackup", (String)validMsg));
        this.validDmeParams(processConfig).ifPresent(validMsg -> validResult.put("dme", (String)validMsg));
        this.validaDayuParams(processConfig).ifPresent(validMsg -> validResult.put("dayu", (String)validMsg));
        this.validaHicloudParams(processConfig).ifPresent(validMsg -> validResult.put("hicloud", (String)validMsg));
        this.validateSfsParams(processConfig).ifPresent(validMsg -> validResult.put("Sfs", (String)validMsg));
        this.validateSdnParams(processConfig).ifPresent(validMsg -> validResult.put("sdn", (String)validMsg));
        this.validateCampusParams(processConfig).ifPresent(validMsg -> validResult.put("eCampusCore", (String)validMsg));
        this.validateFisonCubeMigrationParams(processConfig).ifPresent(validMsg -> validResult.put("eCampusCore", (String)validMsg));
        Map<String, List<String>> unionValidMaps = ParamUnionValidateUtils.validateUnionParams(processConfig);
        this.handleUnionValidResult("ultraVR", validResult, unionValidMaps);
        this.handleUnionValidResult("eBackup", validResult, unionValidMaps);
        this.handleUnionValidResult("dme", validResult, unionValidMaps);
        log.info("validate DCS params successfully.");
        return ResponseUtil.success(validResult);
    }

    private Optional<String> validateFisonCubeMigrationParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containFusionCube82xDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getFusionCube82Params())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.fusion.cube.is.empty"));
        }
        return FusionCubeMigrationValidateUtils.validateParams(processConfig.getFusionCube82Params());
    }

    private Optional<String> validateCampusParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containCampusDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getCampusCoreParamVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.campus.is.empty"));
        }
        return CampusParamsValidateUtils.validateCampusParams(processConfig.getCampusCoreParamVo());
    }

    private Optional<String> validateSdnParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containSdnDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getSdnParamVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.sfs.is.empty"));
        }
        return SdnParamsValidateUtils.validateSdnParams(processConfig.getSdnParamVo());
    }

    Optional<String> validateSfsParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containSfsDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getSfsParamVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.sfs.is.empty"));
        }
        return SfsParamsValidateUtils.validateSfsParams(processConfig.getSfsParamVo());
    }

    private Optional<String> validaHicloudParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containHiCloudDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getHiCloudParamVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.hicloud.is.empty"));
        }
        return HicloudParamsValidateUtils.validateHicloudParams(processConfig.getHiCloudParamVo());
    }

    private Optional<String> validaDayuParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containDayuDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getDayuParamsVo())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.dayu.is.empty"));
        }
        return DayuParamsValidateUtils.validateDayuParams(processConfig.getDayuParamsVo());
    }

    private void handleUnionValidResult(String key, Map<String, String> validResult, Map<String, List<String>> unionValidMaps) {
        Optional.ofNullable(unionValidMaps.get(key)).filter(CollectionUtils::isNotEmpty).ifPresent(validMsgs -> {
            Optional.ofNullable(validResult.get(key)).filter(StringUtils::isNotEmpty).ifPresent(validMsg -> validMsgs.add(0, validMsg));
            validResult.put(key, String.join((CharSequence)"\uff1b", validMsgs));
        });
    }

    private Optional<String> validDmeParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containDmeDeployScene(installMode)) {
            return Optional.empty();
        }
        if (MapUtils.isEmpty(processConfig.getDmeData())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.dme.is.empty"));
        }
        return this.handleResponse(this.validateDmeParams(processConfig.getDmeData()));
    }

    private Optional<String> validEbackupParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containEbackupDeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getEbackupParams())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.eBackup.is.empty"));
        }
        return this.handleResponse(this.validateEbackupParams(processConfig.getEbackupParams()));
    }

    private Optional<String> validUltraVRParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containUltraVRdeployScene(installMode)) {
            return Optional.empty();
        }
        if (Objects.isNull(processConfig.getUltraVRParams())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.ultraVR.is.empty"));
        }
        return this.handleResponse(this.validateUltraVRParams(processConfig.getUltraVRParams()));
    }

    private Optional<String> validFusionComputeParams(VirtualizationDeployProcessConfig processConfig) {
        List<String> installMode = processConfig.getInstallMode();
        if (!InstallModeEnum.containFcDeployScene(installMode)) {
            return Optional.empty();
        }
        if (CollectionUtils.isEmpty(processConfig.getDeployFc())) {
            return Optional.of(ResourceConfigLoader.getErrorMessage("param.fc.is.empty"));
        }
        return this.handleResponse(this.validateFcParams(InstallModeEnum.transferInstallSceneToValidParamsType(installMode), processConfig.getDeployFc().get(0)));
    }

    private Optional<String> handleResponse(Response<String> response) {
        if (ResponseUtil.isFailed(response)) {
            return Optional.ofNullable(response.getResult()).map(Result::getDescription).filter(StringUtils::isNotEmpty);
        }
        return Optional.ofNullable(response.getData()).filter(StringUtils::isNotEmpty);
    }

    public VirtualizationParametersValidator(DeployEbackupFitImpl deployEbackupImpl, DeployUltraVRFitImpl deployUltraVRImpl, VmDeployFitImpl vmDeployImpl, DmeInstallParamFitImpl dmeInstallParamImpl, ValidateInstallParamsImpl validateInstallParamsImpl) {
        this.deployEbackupImpl = deployEbackupImpl;
        this.deployUltraVRImpl = deployUltraVRImpl;
        this.vmDeployImpl = vmDeployImpl;
        this.dmeInstallParamImpl = dmeInstallParamImpl;
        this.validateInstallParamsImpl = validateInstallParamsImpl;
    }
}

