/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.List;
import java.util.regex.Pattern;

public class BondNameVerifier
extends Verifier {
    private String resourceKey;
    private String reg;
    private RelationValue relationValue;

    public BondNameVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        return ResourceConfigLoader.getStringFromExportMsgWithParams(this.resourceKey, this.relationValue.getLocation().toString(), this.relationValue.getValue());
    }

    @Override
    public boolean doVerify() {
        return this.isValueValid();
    }

    @Override
    protected boolean isValueValid() {
        String relation = this.relationValue.getValue();
        if (StringUtils.isEmpty((CharSequence)relation)) {
            return true;
        }
        if (!ResourceConfigLoader.getStringFromExportMsg("deploy.params.export.port.type.Bond").equals(relation)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)this.value)) {
            return false;
        }
        return Pattern.compile(this.reg).matcher(this.value).matches();
    }

    @Override
    public void setParam(String param) {
        String[] split = param.split(" desc:");
        this.resourceKey = split.length > 1 ? split[1] : "deploy.params.relation.repeat.tips";
        this.reg = split[0];
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationValue = relationValues.get(0);
    }
}

