/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class IpListVerifier
extends Verifier {
    private boolean hasSameIp = false;
    private List<String> invalidIp;

    public IpListVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        if (this.hasSameIp) {
            return this.getResourceByKey("deploy.params.multi.ip.same");
        }
        return this.getResourceByKeyWithParams("deploy.params.multi.ip.invalid", String.join((CharSequence)",", this.invalidIp));
    }

    @Override
    protected boolean isValueValid() {
        List<String> list = Arrays.asList(this.value.split(","));
        if (list.size() != new HashSet<String>(list).size()) {
            this.hasSameIp = true;
            return false;
        }
        this.invalidIp = list.stream().filter(ip -> !IpUtils.isValidIpV4((String)ip)).collect(Collectors.toList());
        return this.invalidIp.isEmpty();
    }
}

