/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpPrefixVerifier
extends Verifier {
    private static final Logger log = LoggerFactory.getLogger(IpPrefixVerifier.class);
    private String param;
    private String range;

    public IpPrefixVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        return this.getResourceByKeyWithParams("deploy.params.ip.prefix.not.valid", this.range);
    }

    @Override
    protected boolean isValueValid() {
        if (!this.value.contains("/")) {
            return false;
        }
        String[] split = this.value.split("/");
        String ip = split[0];
        String prefix = split[1];
        boolean validIpV4 = IpUtils.isValidIpV4((String)ip);
        if (!validIpV4) {
            return false;
        }
        try {
            int prefixNum = Integer.parseInt(prefix);
            if (!StringUtils.isEmpty((CharSequence)this.param)) {
                String[] paramSplit = this.param.split(",");
                int min = Integer.parseInt(paramSplit[0]);
                int max = Integer.parseInt(paramSplit[1]);
                this.range = min + "~" + max;
                return prefixNum >= min && prefixNum <= max;
            }
            this.range = "1~128";
            return prefixNum >= 1 && prefixNum <= 128;
        }
        catch (NumberFormatException e) {
            log.error("parse location :{} prefix :{} error", (Object)this.currentLocation.toString(), (Object)prefix);
            return false;
        }
    }

    @Override
    public void setParam(String param) {
        this.param = param;
    }

    public void setRange(String range) {
        this.range = range;
    }
}

