/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class IpVerifier
extends Verifier {
    private final List<Location> noNeedCheck = new ArrayList<Location>();
    private String param;
    private List<RelationValue> relationValues;
    private boolean ipValid = true;
    private boolean isMatchGateway = true;
    private boolean reachable = true;

    public IpVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
        this.noNeedCheck.add(Location.builder().sheetIndex(1).row(4).column(2).build());
        this.noNeedCheck.add(Location.builder().sheetIndex(1).row(5).column(2).build());
    }

    @Override
    public String show() {
        if (!this.ipValid) {
            return this.getResourceByKeyWithParams("deploy.params.ip.invalid", this.value);
        }
        if (!this.isMatchGateway) {
            return this.getResourceByKeyWithParams("deploy.params.ip.not.match.gateway", this.value, this.relationValues.get(0).getLocation().getRow() + 1);
        }
        if (this.reachable) {
            return this.getResourceByKeyWithParams("deploy.params.ip.not.reachable", this.value);
        }
        return this.getResourceByKeyWithParams("deploy.params.ip.reachable", this.value);
    }

    @Override
    protected boolean isValueValid() {
        boolean validIpV4 = IpUtils.isValidIpV4((String)this.value);
        if (!validIpV4) {
            this.ipValid = false;
            return false;
        }
        if (CollectionUtils.isNotEmpty(this.relationValues)) {
            RelationValue netmask = this.relationValues.get(0);
            RelationValue gateway = this.relationValues.get(1);
            if (!IpUtils.calcSubnetAddress((String)this.value, (String)netmask.getValue()).equals(IpUtils.calcSubnetAddress((String)gateway.getValue(), (String)netmask.getValue()))) {
                this.isMatchGateway = false;
                return false;
            }
        }
        return this.checkReachable();
    }

    private boolean checkReachable() {
        if (StringUtils.isEmpty((CharSequence)this.param) || this.param.startsWith("false") || this.noNeedCheck.contains(this.currentLocation)) {
            return true;
        }
        if (!this.param.contains(":")) {
            return this.checkConnection();
        }
        this.reachable = Boolean.parseBoolean(this.param.split(":")[1]);
        return this.reachable == this.checkConnection();
    }

    private boolean checkConnection() {
        return com.huawei.yinglong.virtualization.deploy.utils.IpUtils.isReachable(this.value);
    }

    @Override
    public void setParam(String param) {
        this.param = param;
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationValues = relationValues;
    }
}

