/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;

public class NumberRangeVerifier
extends Verifier {
    private String param;
    private int minValue = -1;
    private int maxValue = -1;

    public NumberRangeVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
    }

    @Override
    public String show() {
        StringBuilder rangeDesc = new StringBuilder();
        if (this.minValue != -1) {
            rangeDesc.append(this.getResourceByKeyWithParams("great.equal", this.minValue));
        }
        if (this.maxValue != -1) {
            rangeDesc.append(this.getResourceByKeyWithParams("less.equal", this.maxValue));
        }
        return this.getResourceByKeyWithParams("deploy.params.number.range.value.invalid", this.value, rangeDesc);
    }

    @Override
    protected boolean isValueValid() {
        try {
            if (!this.param.contains(",")) {
                return this.value.equals(this.param);
            }
            this.parseRange();
            int valueNum = Integer.parseInt(this.value);
            return this.checkMin(valueNum) && this.checkMax(valueNum);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void parseRange() {
        String[] split = this.param.split(",");
        if (this.param.startsWith(",")) {
            this.parseMax(split[1]);
            return;
        }
        if (this.param.endsWith(",")) {
            this.parseMin(split[0]);
            return;
        }
        String min = split[0];
        String max = split[1];
        this.parseMin(min);
        this.parseMax(max);
    }

    private void parseMax(String max) {
        this.maxValue = Integer.parseInt(max);
    }

    private void parseMin(String min) {
        this.minValue = Integer.parseInt(min);
    }

    private boolean checkMin(int valueNum) {
        return this.minValue == -1 || valueNum >= this.minValue;
    }

    private boolean checkMax(int valueNum) {
        return this.maxValue == -1 || valueNum <= this.maxValue;
    }

    @Override
    public void setParam(String param) {
        this.param = param;
    }
}

