/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service.verifier;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.config.ResourceConfigLoader;
import com.huawei.yinglong.virtualization.deploy.service.verifier.Verifier;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.Location;
import com.huawei.yinglong.virtualization.deploy.service.verifier.data.RelationValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class PhysicPortVerifier
extends Verifier {
    private final List<Location> noNeedCheckLocation = new ArrayList<Location>();
    private RelationValue relationValue;
    private boolean bondMode = false;
    private List<String> invalidPort;
    private boolean isEmpty = false;

    public PhysicPortVerifier(String value, Location currentLocation) {
        super(value, currentLocation);
        this.noNeedCheckLocation.add(Location.builder().sheetIndex(1).row(2).column(6).build());
        this.noNeedCheckLocation.add(Location.builder().sheetIndex(1).row(5).column(6).build());
    }

    @Override
    public String show() {
        if (this.isEmpty) {
            return this.getResourceByKey("deploy.params.not.allow.empty");
        }
        if (CollectionUtils.isNotEmpty(this.invalidPort)) {
            return this.getResourceByKeyWithParams("deploy.params.physci.port.value.invalid", String.join((CharSequence)",", this.invalidPort));
        }
        if (this.bondMode) {
            return this.getResourceByKey("deploy.params.physci.port.bond.value.invalid");
        }
        return this.getResourceByKey("deploy.params.physci.port.not.bond.value.invalid");
    }

    @Override
    public boolean doVerify() {
        if (this.noNeedCheckLocation.contains(this.currentLocation) && StringUtils.isEmpty((CharSequence)this.value)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)this.value)) {
            this.isEmpty = true;
            return false;
        }
        return this.isValueValid();
    }

    @Override
    protected boolean isValueValid() {
        this.checkValue();
        if (CollectionUtils.isNotEmpty(this.invalidPort)) {
            return false;
        }
        String bondType = this.relationValue.getValue();
        if (!ResourceConfigLoader.getStringFromExportMsgWithParams("deploy.params.export.port.type.Bond", new Object[0]).equals(bondType)) {
            return !this.value.contains(",");
        }
        this.bondMode = true;
        return this.value.contains(",");
    }

    private void checkValue() {
        this.invalidPort = Arrays.stream(this.value.split(",")).filter(this::isInvalidPort).collect(Collectors.toList());
    }

    private boolean isInvalidPort(String port) {
        return !port.contains("/");
    }

    @Override
    public void setRelationValues(List<RelationValue> relationValues) {
        this.relationValue = relationValues.get(0);
    }
}

